/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.filter;

import java.util.LinkedHashSet;
import java.util.Set;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.WebFluxUtil;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpMessage;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class WebFluxFilterBase<T extends WebFilter>
implements WebFilter,
InitializingBean {
    private static final byte[] EMPTY_BODY = new byte[0];
    private boolean initialized = false;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private Set<String> allowPaths;
    private Set<String> skipPaths;
    private RequestMappingHandlerMapping handlerMapping;
    private Boolean enableTimeResult;

    public T setAllowPaths(String ... allowPaths) {
        if (allowPaths != null && allowPaths.length != 0) {
            this.allowPaths = new LinkedHashSet<String>();
            for (String allowPath : allowPaths) {
                this.allowPaths.add(allowPath);
            }
        }
        return this.getFilter();
    }

    public T setSkipPaths(String ... skipPaths) {
        if (skipPaths != null && skipPaths.length != 0) {
            this.skipPaths = new LinkedHashSet<String>();
            for (String skipPath : skipPaths) {
                this.skipPaths.add(skipPath);
            }
        }
        return this.getFilter();
    }

    public T setHandlerMapping(RequestMappingHandlerMapping handlerMapping) {
        this.handlerMapping = handlerMapping;
        return this.getFilter();
    }

    public T setHandlerMapping(ApplicationContext applicationContext) {
        this.handlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean(RequestMappingHandlerMapping.class);
        return this.getFilter();
    }

    public T setEnableTimeResult(Boolean enableTimeResult) {
        this.enableTimeResult = enableTimeResult;
        return this.getFilter();
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (Boolean.TRUE.equals(this.enableTimeResult)) {
            WebFluxUtil.Share.setStart((HttpMessage)exchange.getResponse(), System.nanoTime());
        }
        WebFluxUtil.Share.setLanguage(exchange);
        this.initialized();
        this.preFilter(exchange);
        Mono mono = Mono.empty();
        if (this.isMatchPath(this.allowPaths, exchange.getRequest().getPath().pathWithinApplication().value())) {
            Object handler = WebFluxUtil.getContent(this.handlerMapping.getHandler(exchange));
            Boolean isReactiveResponse = FrameworkUtil.isResponseWritable(handler);
            WebFluxUtil.Share.setReactive((HttpMessage)exchange.getResponse(), Boolean.TRUE.equals(isReactiveResponse));
            Boolean isReactiveRequest = FrameworkUtil.isRequestReadable(handler);
            mono = Boolean.TRUE.equals(isReactiveRequest) ? DataBufferUtils.join((Publisher)exchange.getRequest().getBody()).map(dataBuffer -> {
                byte[] bytes = new byte[dataBuffer.readableByteCount()];
                dataBuffer.read(bytes);
                DataBufferUtils.release((DataBuffer)dataBuffer);
                return bytes;
            }).defaultIfEmpty((Object)EMPTY_BODY).flatMap(bytes -> {
                ServerHttpRequestDecorator decorator = new ServerHttpRequestDecorator(exchange.getRequest(), (byte[])bytes, exchange){
                    final /* synthetic */ byte[] val$bytes;
                    final /* synthetic */ ServerWebExchange val$exchange;
                    {
                        this.val$bytes = byArray;
                        this.val$exchange = serverWebExchange;
                        super(delegate);
                    }

                    public Flux<DataBuffer> getBody() {
                        if (this.val$bytes.length > 0) {
                            DataBufferFactory dataBufferFactory = this.val$exchange.getResponse().bufferFactory();
                            return Flux.just((Object)dataBufferFactory.wrap(this.val$bytes));
                        }
                        return Flux.empty();
                    }
                };
                return this.onProcess(exchange.mutate().request((ServerHttpRequest)decorator).build(), chain, handler);
            }) : this.onProcess(exchange, chain, handler);
        }
        return mono;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.handlerMapping, (String)"handlerMapping is required");
        if (this.allowPaths == null) {
            this.allowPaths = new LinkedHashSet<String>();
        }
        if (this.skipPaths == null) {
            this.skipPaths = new LinkedHashSet<String>();
        }
        if (this.enableTimeResult == null) {
            this.enableTimeResult = Boolean.TRUE;
        }
        this.initialized = true;
    }

    protected abstract T getFilter();

    protected abstract void preFilter(ServerWebExchange var1);

    protected abstract Mono<Void> doFilter(ServerWebExchange var1, WebFilterChain var2, Object var3);

    protected Set<String> getAllowPaths() {
        return this.allowPaths;
    }

    protected Set<String> getSkipPaths() {
        return this.skipPaths;
    }

    protected boolean isMatchPath(Set<String> bases, String path) {
        if (bases == null) {
            return true;
        }
        for (String base : bases) {
            if (!this.antPathMatcher.match(base, path)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMatchPath(Set<String> bases, Set<String> paths) {
        if (bases == null) {
            return false;
        }
        if (paths == null) {
            return true;
        }
        for (String path : paths) {
            if (!this.isMatchPath(bases, path)) continue;
            return true;
        }
        return false;
    }

    private Mono<Void> onProcess(ServerWebExchange exchange, WebFilterChain chain, Object handler) {
        Mono<Void> mono = !this.isMatchPath(this.skipPaths, exchange.getRequest().getPath().pathWithinApplication().value()) ? this.doFilter(exchange, chain, handler) : chain.filter(exchange);
        return mono;
    }

    private void initialized() {
        if (!this.initialized) {
            throw FrameworkUtil.exception(this.getFilter().getClass().getName() + " not initialized; call initialize() before using it");
        }
    }
}

