/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.filter;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.filter.WebFluxFilterBase;
import net.ideahut.springboot.generator.MdcTraceGenerator;
import net.ideahut.springboot.interceptor.WebFluxHandlerInterceptor;
import net.ideahut.springboot.message.MessageHandler;
import net.ideahut.springboot.util.WebFluxUtil;
import org.apache.commons.lang3.RandomStringUtils;
import org.jboss.logging.MDC;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class WebFluxRequestFilter
extends WebFluxFilterBase<WebFluxRequestFilter> {
    private Map<String, String> corsHeaders;
    private Boolean traceEnable;
    private MdcTraceGenerator traceGenerator;
    private String traceKey;
    private Set<WebFluxHandlerInterceptor> interceptors;

    public WebFluxRequestFilter setCorsHeaders(Map<String, String> headers) {
        this.corsHeaders = headers != null ? new HashMap<String, String>(headers) : new HashMap<String, String>();
        return this;
    }

    public WebFluxRequestFilter setCORSHeader(String key, String value) {
        if (this.corsHeaders == null) {
            this.corsHeaders = new HashMap<String, String>();
        }
        this.corsHeaders.put(key, value);
        return this;
    }

    public WebFluxRequestFilter setTraceEnable(Boolean traceEnable) {
        this.traceEnable = traceEnable;
        return this;
    }

    public WebFluxRequestFilter setTraceGenerator(MdcTraceGenerator traceGenerator) {
        this.traceGenerator = traceGenerator;
        return this;
    }

    public WebFluxRequestFilter setTraceKey(String traceKey) {
        this.traceKey = traceKey;
        return this;
    }

    public WebFluxRequestFilter setInterceptors(WebFluxHandlerInterceptor ... interceptors) {
        if (interceptors != null && interceptors.length != 0) {
            this.interceptors = new LinkedHashSet<WebFluxHandlerInterceptor>();
            for (WebFluxHandlerInterceptor interceptor : interceptors) {
                this.interceptors.add(interceptor);
            }
        }
        return this.getFilter();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.interceptors == null) {
            this.interceptors = new LinkedHashSet<WebFluxHandlerInterceptor>();
        }
        if (this.corsHeaders == null) {
            this.corsHeaders = new HashMap<String, String>();
        }
        if (Boolean.TRUE.equals(this.traceEnable)) {
            String string = this.traceKey = this.traceKey != null ? this.traceKey.trim() : "";
            if (this.traceKey.isEmpty()) {
                this.traceKey = "traceId";
            }
            if (this.traceGenerator == null) {
                this.traceGenerator = () -> RandomStringUtils.randomAlphanumeric((int)8);
            }
        }
        LinkedHashSet<WebFluxHandlerInterceptor> candidates = new LinkedHashSet<WebFluxHandlerInterceptor>();
        for (WebFluxHandlerInterceptor interceptor : this.interceptors) {
            if (!super.isMatchPath(super.getAllowPaths(), interceptor.allowPaths())) continue;
            candidates.add(interceptor);
        }
        this.interceptors = candidates;
        super.afterPropertiesSet();
    }

    @Override
    protected void preFilter(ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        for (Map.Entry<String, String> entry : this.corsHeaders.entrySet()) {
            response.getHeaders().set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain, Object handler) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        if (HttpMethod.OPTIONS.equals((Object)request.getMethod())) {
            response.setStatusCode(HttpStatusCode.valueOf((int)HttpStatus.OK.value()));
            WebFluxUtil.Share.clear((HttpMessage)exchange.getResponse());
            return Mono.empty();
        }
        Set<WebFluxHandlerInterceptor> handlerInterceptors = this.prepareInterceptors(exchange);
        for (WebFluxHandlerInterceptor interceptor : handlerInterceptors) {
            Mono<Void> mono = interceptor.preHandle(exchange, handler);
            if (mono == null) continue;
            WebFluxUtil.Share.clear((HttpMessage)exchange.getResponse());
            return mono;
        }
        Mono mono = Boolean.TRUE.equals(this.traceEnable) ? chain.filter(exchange).doFirst(() -> {
            RequestContext.currentContext().setAttribute(MessageHandler.Attribute.LANGUAGE, (Object)WebFluxUtil.Share.getLanguage((HttpMessage)response));
            MDC.put((String)this.traceKey, (Object)this.traceGenerator.getMdcTraceValue());
        }).doFinally(r -> {
            RequestContext.destroy();
            MDC.clear();
        }) : chain.filter(exchange).doFirst(() -> RequestContext.currentContext().setAttribute(MessageHandler.Attribute.LANGUAGE, (Object)WebFluxUtil.Share.getLanguage((HttpMessage)response))).doFinally(r -> RequestContext.destroy());
        return mono.doOnSuccess(t -> {
            for (WebFluxHandlerInterceptor interceptor : handlerInterceptors) {
                interceptor.successHandle(exchange, handler);
            }
        }).doOnCancel(() -> {
            for (WebFluxHandlerInterceptor interceptor : handlerInterceptors) {
                interceptor.cancelHandle(exchange, handler);
            }
        }).doOnError(t -> {
            for (WebFluxHandlerInterceptor interceptor : handlerInterceptors) {
                interceptor.errorHandle(exchange, handler, (Throwable)t);
            }
        });
    }

    @Override
    protected WebFluxRequestFilter getFilter() {
        return this;
    }

    private Set<WebFluxHandlerInterceptor> prepareInterceptors(ServerWebExchange exchange) {
        LinkedHashSet<WebFluxHandlerInterceptor> candidates = new LinkedHashSet<WebFluxHandlerInterceptor>();
        ServerHttpRequest request = exchange.getRequest();
        String path = request.getPath().pathWithinApplication().value();
        for (WebFluxHandlerInterceptor interceptor : this.interceptors) {
            if (!super.isMatchPath(interceptor.allowPaths(), path) || super.isMatchPath(interceptor.skipPaths(), path)) continue;
            candidates.add(interceptor);
        }
        return candidates;
    }
}

