/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.wrapper.RequestWrapper;
import org.springframework.context.ApplicationContext;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public abstract class WebMvcFilterBase<T extends GenericFilterBean>
extends OncePerRequestFilter {
    private boolean initialized = false;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private Set<String> ignorePaths;
    private RequestMappingHandlerMapping handlerMapping;
    private Boolean enableTimeResult;

    public T setIgnorePaths(String ... paths) {
        this.ignorePaths = new LinkedHashSet<String>();
        if (paths != null) {
            this.ignorePaths.addAll(Arrays.asList(paths));
        }
        return this.getFilter();
    }

    public T setHandlerMapping(RequestMappingHandlerMapping handlerMapping) {
        this.handlerMapping = handlerMapping;
        return this.getFilter();
    }

    public T setHandlerMapping(ApplicationContext applicationContext) {
        this.handlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean(RequestMappingHandlerMapping.class);
        return this.getFilter();
    }

    public T setEnableTimeResult(Boolean enableTimeResult) {
        this.enableTimeResult = enableTimeResult;
        return this.getFilter();
    }

    protected Set<String> getIgnorePaths() {
        return this.ignorePaths;
    }

    protected T initialize() {
        Assert.notNull((Object)this.handlerMapping, (String)"handlerMapping is required");
        if (this.ignorePaths == null) {
            this.ignorePaths = new LinkedHashSet<String>();
        }
        if (this.enableTimeResult == null) {
            this.enableTimeResult = Boolean.TRUE;
        }
        this.initialized = true;
        return this.getFilter();
    }

    protected boolean isMatchPath(Set<String> bases, String path) {
        if (bases == null || bases.isEmpty()) {
            return true;
        }
        for (String base : bases) {
            if (!this.antPathMatcher.match(base, path)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMatchPath(Set<String> bases, Set<String> paths) {
        if (bases == null) {
            return false;
        }
        if (paths == null) {
            return true;
        }
        for (String path : paths) {
            if (!this.isMatchPath(bases, path)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        this.initialized();
        String path = request.getServletPath();
        for (String ignorePath : this.ignorePaths) {
            if (!this.antPathMatcher.match(ignorePath, path)) continue;
            return true;
        }
        return false;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        Object handler;
        if (Boolean.TRUE.equals(this.enableTimeResult)) {
            RequestContext.start();
        }
        this.initialized();
        try {
            HandlerExecutionChain hec = this.handlerMapping.getHandler(request);
            handler = hec != null ? hec.getHandler() : null;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Boolean isReadable = FrameworkUtil.isRequestReadable(handler);
        HttpServletRequest newRequest = !Boolean.TRUE.equals(isReadable) ? new RequestWrapper(request) : request;
        this.preFilter((ServletRequest)newRequest, (ServletResponse)response, chain);
        RequestContext.setRequest((HttpServletRequest)newRequest);
        RequestContext.setResponse((HttpServletResponse)response);
        this.doFilter((ServletRequest)newRequest, (ServletResponse)response, chain, handler);
    }

    protected abstract T getFilter();

    protected abstract void preFilter(ServletRequest var1, ServletResponse var2, FilterChain var3) throws ServletException, IOException;

    protected abstract void doFilter(ServletRequest var1, ServletResponse var2, FilterChain var3, Object var4) throws ServletException, IOException;

    protected void initialized() {
        if (!this.initialized) {
            throw FrameworkUtil.exception(this.getFilter().getClass().getName() + " not initialized; call initialize() before using it");
        }
    }
}

