/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.ideahut.springboot.filter.WebMvcFilterBase;
import net.ideahut.springboot.generator.MdcTraceGenerator;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.MDC;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class WebMvcRequestFilter
extends WebMvcFilterBase<WebMvcRequestFilter> {
    private Map<String, String> corsHeaders;
    private Boolean traceEnable;
    private MdcTraceGenerator traceGenerator;
    private String traceKey;

    public WebMvcRequestFilter setCorsHeaders(Map<String, String> corsHeaders) {
        this.corsHeaders = corsHeaders;
        return this;
    }

    public WebMvcRequestFilter setTraceEnable(Boolean traceEnable) {
        this.traceEnable = traceEnable;
        return this;
    }

    public WebMvcRequestFilter setTraceGenerator(MdcTraceGenerator traceGenerator) {
        this.traceGenerator = traceGenerator;
        return this;
    }

    public WebMvcRequestFilter setTraceKey(String traceKey) {
        this.traceKey = traceKey;
        return this;
    }

    @Override
    public WebMvcRequestFilter initialize() {
        if (this.corsHeaders == null) {
            this.corsHeaders = new HashMap<String, String>();
        }
        if (Boolean.TRUE.equals(this.traceEnable)) {
            String string = this.traceKey = this.traceKey != null ? this.traceKey.trim() : "";
            if (this.traceKey.isEmpty()) {
                this.traceKey = "traceId";
            }
            if (this.traceGenerator == null) {
                this.traceGenerator = () -> RandomStringUtils.randomAlphanumeric((int)8);
            }
        }
        return (WebMvcRequestFilter)((Object)super.initialize());
    }

    @Override
    protected WebMvcRequestFilter getFilter() {
        return this;
    }

    @Override
    protected void preFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse hresp = (HttpServletResponse)response;
            for (Map.Entry<String, String> entry : this.corsHeaders.entrySet()) {
                hresp.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilter(ServletRequest request, ServletResponse response, FilterChain chain, Object handler) throws ServletException, IOException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            if (HttpMethod.OPTIONS.name().equalsIgnoreCase(httpRequest.getMethod())) {
                httpResponse.setStatus(HttpStatus.OK.value());
                return;
            }
            if (Boolean.TRUE.equals(this.traceEnable)) {
                try {
                    MDC.put((String)this.traceKey, (String)this.traceGenerator.getMdcTraceValue());
                    chain.doFilter(request, response);
                }
                finally {
                    MDC.clear();
                }
            } else {
                chain.doFilter(request, response);
            }
        }
    }
}

