/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.generator;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import net.ideahut.springboot.annotation.IdPrefix;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.spi.StandardGenerator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class StringIdGenerator
implements IdentifierGenerator,
StandardGenerator {
    private static final int LENGTH = 4;
    private static final int TEN = 10;
    public static final String NAME = "StringIdGenerator";
    public static final String STRATEGY = "net.ideahut.springboot.generator.StringIdGenerator";
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    private static AtomicLong atomicLong = new AtomicLong();
    private static int suffixLength = 4;
    private static int suffixNumber = (int)Math.pow(10.0, suffixLength);
    private String entityName;

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        this.entityName = params.getProperty("entity_name");
    }

    public Serializable generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        Object id = (Serializable)session.getEntityPersister(this.entityName, object).getIdentifier(object, session);
        if (id == null || "null".equals(id)) {
            IdPrefix idPrefix = object.getClass().getAnnotation(IdPrefix.class);
            String prefix = idPrefix != null ? idPrefix.value().trim() : "";
            id = StringIdGenerator.createId(prefix);
        }
        return id;
    }

    public static void setSuffixLength(int suffixLength) {
        if (suffixLength > 0) {
            StringIdGenerator.suffixLength = suffixLength;
            suffixNumber = (int)Math.pow(10.0, suffixLength);
        }
    }

    public static String createId(String prefix) {
        String content = LocalDateTime.now().format(formatter);
        long number = atomicLong.getAndIncrement() % (long)suffixNumber;
        String suffix = StringUtils.leftPad((String)("" + number), (int)suffixLength, (char)'0');
        return (String)(!prefix.isEmpty() ? prefix + "." : "") + content + "." + suffix;
    }
}

