/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.generator;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import net.ideahut.springboot.annotation.IdPrefix;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.spi.StandardGenerator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class UUIDGenerator
implements IdentifierGenerator,
StandardGenerator {
    public static final String NAME = "UUIDGenerator";
    public static final String STRATEGY = "net.ideahut.springboot.generator.UUIDGenerator";
    private String entityName;

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        this.entityName = params.getProperty("entity_name");
    }

    public Serializable generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        Object id = (Serializable)session.getEntityPersister(this.entityName, object).getIdentifier(object, session);
        if (id == null || "null".equals(id)) {
            IdPrefix idPrefix = object.getClass().getAnnotation(IdPrefix.class);
            String prefix = idPrefix != null ? idPrefix.value() : "";
            id = prefix + UUID.randomUUID().toString();
        }
        return id;
    }
}

