/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.grid;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.bean.BeanReload;
import net.ideahut.springboot.bean.BeanShutdown;
import net.ideahut.springboot.grid.GridAdditional;
import net.ideahut.springboot.grid.GridHandler;
import net.ideahut.springboot.grid.GridHelper0;
import net.ideahut.springboot.grid.GridHelper1;
import net.ideahut.springboot.grid.GridOption;
import net.ideahut.springboot.grid.GridParent;
import net.ideahut.springboot.grid.GridSource;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.message.MessageHandler;
import net.ideahut.springboot.object.Option;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.Assert;

public class GridHandlerImpl
implements GridHandler,
InitializingBean,
BeanReload,
BeanShutdown,
BeanConfigure<GridHandler> {
    private boolean configured = false;
    private DataMapper dataMapper;
    private String prefix;
    private String location;
    private String definition;
    private Map<String, GridOption> options = new LinkedHashMap<String, GridOption>();
    private Map<String, GridAdditional> additionals = new LinkedHashMap<String, GridAdditional>();
    private ApplicationContext applicationContext;
    private RedisTemplate<String, byte[]> redisTemplate;
    private MessageHandler messageHandler;
    private Map<String, byte[]> stores = new LinkedHashMap<String, byte[]>();

    public GridHandlerImpl setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public GridHandlerImpl setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public GridHandlerImpl setLocation(String location) {
        this.location = location;
        return this;
    }

    public GridHandlerImpl setDefinition(String definition) {
        this.definition = definition;
        return this;
    }

    public GridHandlerImpl setOptions(Map<String, GridOption> options) {
        this.options = options != null ? new LinkedHashMap<String, GridOption>(options) : new LinkedHashMap();
        return this;
    }

    public GridHandlerImpl putOption(String name, GridOption option) {
        if (name != null && option != null) {
            this.options.put(name, option);
        }
        return this;
    }

    public GridHandlerImpl setAdditionals(Map<String, GridAdditional> additionals) {
        this.additionals = additionals != null ? new LinkedHashMap<String, GridAdditional>(additionals) : new LinkedHashMap();
        return this;
    }

    public GridHandlerImpl putAdditional(String name, GridAdditional additional) {
        if (name != null && additional != null) {
            this.additionals.put(name, additional);
        }
        return this;
    }

    public GridHandlerImpl setRedisTemplate(RedisTemplate<String, byte[]> redisTemplate) {
        this.redisTemplate = redisTemplate;
        return this;
    }

    public GridHandlerImpl setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.location, (String)"location is required");
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        if (this.prefix == null) {
            this.prefix = GridHandler.class.getSimpleName();
        }
    }

    @Override
    public Callable<GridHandler> onConfigureBean(ApplicationContext applicationContext) {
        final GridHandlerImpl self = this;
        self.applicationContext = applicationContext;
        return new Callable<GridHandler>(){

            @Override
            public GridHandler call() throws Exception {
                GridHandlerImpl.this.onReloadBean();
                GridHandlerImpl.this.configured = true;
                return self;
            }
        };
    }

    @Override
    public boolean isBeanConfigured() {
        return this.configured;
    }

    @Override
    public void onShutdownBean() {
        GridHelper0.lock(this.prefix, this.redisTemplate, this.stores, false);
    }

    public boolean onReloadBean() throws Exception {
        if (!GridHelper0.lock(this.prefix, this.redisTemplate, this.stores, true)) {
            return false;
        }
        GridHelper0.clear(this.prefix, this.dataMapper, this.redisTemplate, this.stores);
        try {
            String key;
            JsonNode jdefinition = GridHelper0.definition(this.dataMapper, this.definition);
            Map<String, GridParent> mParents = GridHelper0.parents(this.dataMapper, jdefinition);
            Map<String, List<GridSource>> mapSources = GridHelper0.sources(this.dataMapper, this.location);
            if (mapSources.size() == 1 && !"_".equals(key = mapSources.keySet().iterator().next())) {
                mapSources.put("_", mapSources.get(key));
                mapSources.remove(key);
            }
            LinkedHashMap<String, GridParent> parents = new LinkedHashMap<String, GridParent>();
            Map<String, List<GridSource>> sources = this.dataMapper.copy(mapSources, GridHelper0.TypeRef.SOURCE_MAP);
            LinkedHashMap<Object, byte[]> caches = new LinkedHashMap<Object, byte[]>();
            for (Map.Entry<String, List<GridSource>> entry : sources.entrySet()) {
                Object parent = entry.getKey();
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    GridSource source = entry.getValue().get(i);
                    String ckey = this.prefix + "-#-" + (String)parent + "-#-" + source.getName();
                    if (caches.containsKey(ckey)) {
                        throw new Exception("Duplicate grid key: " + ckey);
                    }
                    caches.put(ckey, this.dataMapper.writeAsBytes(source.getTemplate(), 1));
                    source.setTemplate(null);
                    GridParent gparent = (GridParent)parents.get(source.getParent());
                    if (gparent == null) {
                        GridParent mParent = mParents.getOrDefault(parent, new GridParent());
                        gparent = new GridParent();
                        gparent.setName((String)parent);
                        gparent.setOrder(mParent.getOrder() != null ? mParent.getOrder() : Integer.MAX_VALUE);
                        gparent.setSources(new ArrayList<GridSource>());
                        gparent.setTitle((String)(mParent.getTitle() != null && !mParent.getTitle().trim().isEmpty() ? mParent.getTitle() : ((String)parent).substring(0, 1).toUpperCase() + ((String)parent).substring(1)));
                        gparent.setDisabled(mParent.getDisabled());
                        gparent.setExcludes(mParent.getExcludes() != null ? mParent.getExcludes() : new HashSet<String>());
                        parents.put(gparent.getName(), gparent);
                    }
                    if (Boolean.TRUE.equals(gparent.getDisabled()) || gparent.getExcludes().contains(source.getName())) continue;
                    gparent.getSources().add(source);
                }
            }
            List<Object> tree = new ArrayList(parents.values());
            Collections.sort(tree, GridHelper0.Sort.PARENT_TITLE);
            Collections.sort(tree, GridHelper0.Sort.PARENT_ORDER);
            tree = tree.stream().filter(o -> !Boolean.TRUE.equals(o.getDisabled())).collect(Collectors.toList());
            for (Object parent : tree) {
                ((GridParent)parent).setOrder(null);
            }
            byte[] byArray = this.dataMapper.writeAsBytes(tree, 1);
            caches.put(GridHelper0.Keys.tree(this.prefix), byArray);
            byte[] kbytes = this.dataMapper.writeAsBytes(caches.keySet(), 1);
            caches.put(GridHelper0.Keys.keys(this.prefix), kbytes);
            if (this.redisTemplate != null) {
                this.redisTemplate.opsForValue().multiSet(caches);
            } else {
                this.stores = new HashMap<String, byte[]>(caches);
            }
        }
        catch (Exception e) {
            GridHelper0.clear(this.prefix, this.dataMapper, this.redisTemplate, this.stores);
            throw e;
        }
        finally {
            GridHelper0.lock(this.prefix, this.redisTemplate, this.stores, false);
        }
        return true;
    }

    @Override
    public ObjectNode getGrid(String parent, String name) {
        String key;
        ArrayNode jarrays;
        ObjectNode nodes;
        String cpar;
        BeanConfigure.checkBeanConfigure(this);
        String string = cpar = parent != null ? parent.trim() : "";
        if (cpar.isEmpty()) {
            cpar = "_";
        }
        String ckey = this.prefix + "-#-" + cpar + "-#-" + name;
        byte[] bytes = null;
        ValueOperations valueOps = this.redisTemplate != null ? this.redisTemplate.opsForValue() : null;
        bytes = valueOps != null ? (byte[])valueOps.get((Object)ckey) : this.stores.get(ckey);
        if (bytes == null) {
            return null;
        }
        ObjectNode jgrid = this.dataMapper.read(bytes, ObjectNode.class);
        if (jgrid.has("options")) {
            JsonNode joptions = jgrid.get("options");
            if (joptions.isArray()) {
                nodes = this.dataMapper.createObjectNode();
                jarrays = (ArrayNode)joptions;
                for (JsonNode joption : jarrays) {
                    key = joption.asText();
                    GridOption gridOption = this.options.get(key);
                    if (gridOption == null) continue;
                    List<Option> option = gridOption.getOption(this.applicationContext);
                    nodes.putArray(key).addAll(this.dataMapper.copy(option, ArrayNode.class));
                }
                jgrid.set("options", (JsonNode)nodes);
            } else {
                jgrid.remove("options");
            }
        }
        if (jgrid.has("additionals")) {
            JsonNode jadditionals = jgrid.get("additionals");
            if (jadditionals.isArray()) {
                nodes = this.dataMapper.createObjectNode();
                jarrays = (ArrayNode)jadditionals;
                for (JsonNode jadditional : jarrays) {
                    key = jadditional.asText();
                    GridAdditional gridAdditional = this.additionals.get(key);
                    if (gridAdditional == null) continue;
                    ArrayNode node = gridAdditional.getAdditional(this.applicationContext);
                    nodes.set(key, (JsonNode)node);
                }
                jgrid.set("additionals", (JsonNode)nodes);
            } else {
                jgrid.remove("additionals");
            }
        }
        return jgrid;
    }

    @Override
    public List<GridParent> getTree() {
        BeanConfigure.checkBeanConfigure(this);
        String skey = GridHelper0.Keys.tree(this.prefix);
        byte[] bytes = null;
        bytes = this.redisTemplate != null ? (byte[])this.redisTemplate.opsForValue().get((Object)skey) : this.stores.get(skey);
        return bytes != null ? this.dataMapper.read(bytes, GridHelper0.TypeRef.PARENT_LIST) : null;
    }

    @Override
    public void translate(ObjectNode grid) {
        BeanConfigure.checkBeanConfigure(this);
        if (this.messageHandler != null && grid != null) {
            Set<String> codes = GridHelper1.getWords(grid);
            Map words = this.messageHandler.getMap(codes.toArray(new String[0]));
            GridHelper1.setWords(words, grid);
        }
    }
}

