/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.grid;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.grid.GridParent;
import net.ideahut.springboot.grid.GridSource;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.util.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

final class GridHelper0 {
    private static final Logger log = LoggerFactory.getLogger(GridHelper0.class);

    private GridHelper0() {
    }

    static void clear(String prefix, DataMapper dataMapper, RedisTemplate<String, byte[]> redisTemplate, Map<String, byte[]> stores) {
        if (redisTemplate != null) {
            String lkey = Keys.keys(prefix);
            ValueOperations valueOps = redisTemplate.opsForValue();
            byte[] bytes = (byte[])valueOps.get((Object)lkey);
            if (bytes != null) {
                Set<String> keys = dataMapper.read(bytes, TypeRef.STRING_SET);
                keys.add(lkey);
                redisTemplate.delete(keys);
            }
        } else {
            stores.clear();
        }
    }

    static synchronized boolean lock(String prefix, RedisTemplate<String, byte[]> redisTemplate, Map<String, byte[]> stores, boolean yes) {
        String lockKey = Keys.lock(prefix);
        if (redisTemplate != null) {
            if (yes) {
                ValueOperations lockOps = redisTemplate.opsForValue();
                byte[] lockBytes = (byte[])lockOps.get((Object)lockKey);
                if (lockBytes != null) {
                    return false;
                }
                lockOps.set((Object)lockKey, (Object)"1".getBytes());
            } else {
                redisTemplate.delete((Object)lockKey);
            }
        } else if (yes) {
            byte[] lockBytes = stores.get(lockKey);
            if (lockBytes != null) {
                return false;
            }
            stores.put(lockKey, "1".getBytes());
        } else {
            stores.remove(lockKey);
        }
        return true;
    }

    static Map<String, List<GridSource>> sources(DataMapper dataMapper, String location) throws Exception {
        LinkedHashMap<String, List<GridSource>> map = new LinkedHashMap<String, List<GridSource>>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(GridHelper0.class.getClassLoader());
        Resource[] resources = resolver.getResources(FrameworkUtil.replacePath(location));
        for (Resource resource : resources) {
            String path = resource.getURI().getPath();
            int idx = path.lastIndexOf("/");
            String parent = path.substring(0, idx);
            idx = parent.lastIndexOf("/");
            parent = parent.substring(idx + 1);
            List list = map.getOrDefault(parent, new ArrayList());
            map.put(parent, list);
            byte[] bytes = resource.getContentAsByteArray();
            JsonNode template = dataMapper.read(bytes, JsonNode.class, 1);
            String name = template.get("name").asText();
            String title = template.get("title").asText();
            Integer order = template.has("order") ? template.get("order").asInt() : Integer.MAX_VALUE;
            GridSource source = new GridSource();
            source.setName(name);
            source.setOrder(order);
            source.setParent(parent);
            source.setTitle(title);
            source.setTemplate(template);
            list.add(source);
        }
        for (Map.Entry entry : map.entrySet()) {
            Collections.sort((List)entry.getValue(), Sort.SOURCE_TITLE);
            Collections.sort((List)entry.getValue(), Sort.SOURCE_ORDER);
        }
        for (Map.Entry entry : map.entrySet()) {
            for (GridSource source : (List)entry.getValue()) {
                source.setOrder(null);
            }
        }
        return map;
    }

    static JsonNode definition(DataMapper dataMapper, String definition) {
        if (definition != null && !definition.trim().isEmpty()) {
            try {
                byte[] bytes = FrameworkUtil.resourceBytes(FrameworkUtil.replacePath(definition));
                return dataMapper.read(bytes, JsonNode.class);
            }
            catch (Exception e) {
                log.warn("Failed to load grid definition: {}", (Object)definition);
            }
        }
        return dataMapper.createObjectNode();
    }

    static Map<String, GridParent> parents(DataMapper dataMapper, JsonNode definition) {
        LinkedHashMap<String, GridParent> parents = new LinkedHashMap<String, GridParent>();
        if (definition.has("parents")) {
            List<GridParent> items = dataMapper.copy((Object)definition.get("parents"), TypeRef.PARENT_LIST);
            while (!items.isEmpty()) {
                GridParent item = items.remove(0);
                String name = item.getName() != null ? item.getName() : "";
                if (name.isEmpty()) continue;
                parents.put(name, item);
            }
        }
        return parents;
    }

    static final class Keys {
        static final String OPTIONS = "options";
        static final String ADDITIONALS = "additionals";
        static final String PARENTS = "parents";
        static final String SEPARATOR = "-#-";
        static final String DEFAULT_PARENT = "_";

        private Keys() {
        }

        static String lock(String prefix) {
            return prefix + "--LOCK--";
        }

        static String keys(String prefix) {
            return prefix + "--KEYS--";
        }

        static String tree(String prefix) {
            return prefix + "--TREE--";
        }
    }

    static final class TypeRef {
        static final TypeReference<Set<String>> STRING_SET = new TypeReference<Set<String>>(){};
        static final TypeReference<Map<String, List<GridSource>>> SOURCE_MAP = new TypeReference<Map<String, List<GridSource>>>(){};
        static final TypeReference<List<GridParent>> PARENT_LIST = new TypeReference<List<GridParent>>(){};

        private TypeRef() {
        }
    }

    static final class Sort {
        static final Comparator<GridParent> PARENT_TITLE = new Comparator<GridParent>(){

            @Override
            public int compare(GridParent o1, GridParent o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        };
        static final Comparator<GridParent> PARENT_ORDER = new Comparator<GridParent>(){

            @Override
            public int compare(GridParent o1, GridParent o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        };
        static final Comparator<GridSource> SOURCE_TITLE = new Comparator<GridSource>(){

            @Override
            public int compare(GridSource o1, GridSource o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        };
        static final Comparator<GridSource> SOURCE_ORDER = new Comparator<GridSource>(){

            @Override
            public int compare(GridSource o1, GridSource o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        };

        private Sort() {
        }
    }

    static interface Loader {
        public void onLoaded(GridSource var1) throws Exception;
    }
}

