/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.grid;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class GridHelper1 {
    private GridHelper1() {
    }

    static Set<String> getWords(ObjectNode grid) {
        HashSet<String> codes = new HashSet<String>();
        GridHelper1.getCode(codes, (JsonNode)grid, "title");
        GridHelper1.getTable(codes, (JsonNode)grid);
        GridHelper1.getFields(codes, (JsonNode)grid);
        GridHelper1.getPicks(codes, (JsonNode)grid);
        GridHelper1.getChildren(codes, (JsonNode)grid);
        GridHelper1.getForms(codes, (JsonNode)grid);
        return codes;
    }

    static void setWords(Map<String, String> words, ObjectNode grid) {
        GridHelper1.setCode(words, (JsonNode)grid, "title");
        GridHelper1.setTable(words, (JsonNode)grid);
        GridHelper1.setFields(words, (JsonNode)grid);
        GridHelper1.setPicks(words, (JsonNode)grid);
        GridHelper1.setChildren(words, (JsonNode)grid);
        GridHelper1.setForms(words, (JsonNode)grid);
    }

    private static void getCode(Set<String> codes, JsonNode node, String key) {
        if (node.has(key)) {
            codes.add(node.get(key).asText());
        }
    }

    private static void getTable(Set<String> codes, JsonNode node) {
        if (node.has("table")) {
            JsonNode table = node.get("table");
            if (table.has("filters")) {
                ArrayNode filters = (ArrayNode)table.get("filters");
                for (JsonNode filter : filters) {
                    GridHelper1.getCode(codes, filter, "label");
                }
            }
            if (table.has("columns")) {
                ArrayNode columns = (ArrayNode)table.get("columns");
                for (JsonNode column : columns) {
                    GridHelper1.getCode(codes, column, "label");
                }
            }
        }
    }

    private static void getFields(Set<String> codes, JsonNode node) {
        if (node.has("fields")) {
            ArrayNode fields = (ArrayNode)node.get("fields");
            for (JsonNode field : fields) {
                GridHelper1.getCode(codes, field, "label");
            }
        }
    }

    private static void getPicks(Set<String> codes, JsonNode node) {
        if (node.has("picks")) {
            JsonNode picks = node.get("picks");
            Iterator iterator = picks.fieldNames();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                JsonNode pick = picks.get(name);
                GridHelper1.getCode(codes, pick, "title");
                GridHelper1.getTable(codes, pick);
            }
        }
    }

    private static void getChildren(Set<String> codes, JsonNode node) {
        if (node.has("children")) {
            ArrayNode children = (ArrayNode)node.get("children");
            for (JsonNode child : children) {
                GridHelper1.getCode(codes, child, "title");
                GridHelper1.getTable(codes, child);
                GridHelper1.getFields(codes, child);
                if (!child.has("labels")) continue;
                ArrayNode labels = (ArrayNode)child.get("labels");
                for (JsonNode label : labels) {
                    GridHelper1.getCode(codes, label, "title");
                }
            }
        }
    }

    private static void getForms(Set<String> codes, JsonNode node) {
        if (node.has("forms")) {
            ArrayNode forms = (ArrayNode)node.get("forms");
            for (JsonNode form : forms) {
                GridHelper1.getCode(codes, form, "title");
                GridHelper1.getFields(codes, form);
            }
        }
    }

    private static void setCode(Map<String, String> words, JsonNode node, String key) {
        String word;
        if (node.has(key) && (word = words.get(node.get(key).asText())) != null) {
            ((ObjectNode)node).put(key, word);
        }
    }

    private static void setTable(Map<String, String> words, JsonNode node) {
        if (node.has("table")) {
            JsonNode table = node.get("table");
            if (table.has("filters")) {
                ArrayNode filters = (ArrayNode)table.get("filters");
                for (JsonNode filter : filters) {
                    GridHelper1.setCode(words, filter, "label");
                }
            }
            if (table.has("columns")) {
                ArrayNode columns = (ArrayNode)table.get("columns");
                for (JsonNode column : columns) {
                    GridHelper1.setCode(words, column, "label");
                }
            }
        }
    }

    private static void setFields(Map<String, String> words, JsonNode node) {
        if (node.has("fields")) {
            ArrayNode fields = (ArrayNode)node.get("fields");
            for (JsonNode field : fields) {
                GridHelper1.setCode(words, field, "label");
            }
        }
    }

    private static void setPicks(Map<String, String> words, JsonNode node) {
        if (node.has("picks")) {
            JsonNode picks = node.get("picks");
            Iterator iterator = picks.fieldNames();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                JsonNode pick = picks.get(name);
                GridHelper1.setCode(words, pick, "title");
                GridHelper1.setTable(words, pick);
            }
        }
    }

    private static void setChildren(Map<String, String> words, JsonNode node) {
        if (node.has("children")) {
            ArrayNode children = (ArrayNode)node.get("children");
            for (JsonNode child : children) {
                GridHelper1.setCode(words, child, "title");
                GridHelper1.setTable(words, child);
                GridHelper1.setFields(words, child);
                if (!child.has("labels")) continue;
                ArrayNode labels = (ArrayNode)child.get("labels");
                for (JsonNode label : labels) {
                    GridHelper1.setCode(words, label, "title");
                }
            }
        }
    }

    private static void setForms(Map<String, String> words, JsonNode node) {
        if (node.has("forms")) {
            ArrayNode forms = (ArrayNode)node.get("forms");
            for (JsonNode form : forms) {
                GridHelper1.setCode(words, form, "title");
                GridHelper1.setFields(words, form);
            }
        }
    }

    private static class Field {
        private static final String TITLE = "title";
        private static final String LABEL = "label";
        private static final String TABLE = "table";
        private static final String FILTERS = "filters";
        private static final String COLUMNS = "columns";
        private static final String FIELDS = "fields";
        private static final String PICKS = "picks";
        private static final String CHILDREN = "children";
        private static final String LABELS = "labels";
        private static final String FORMS = "forms";

        private Field() {
        }
    }
}

