/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.grid;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.crud.Condition;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.JoinColumns;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.Option;
import net.ideahut.springboot.util.StringUtil;
import org.apache.commons.io.FileUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;

public class GridTool {
    private static final ObjectMapper mapper = (ObjectMapper)new DataMapperImpl().mapper(1);

    private GridTool() {
    }

    public static void generate(ConfigurableApplicationContext context, File output, Long closeInMillis) throws Exception {
        Assert.isTrue((boolean)output.isDirectory(), (String)("Invalid output directory: " + output.getPath()));
        EntityTrxManager entityTrxManager = (EntityTrxManager)context.getBean(EntityTrxManager.class);
        BeanConfigure configurer = (BeanConfigure)((Object)entityTrxManager);
        while (!configurer.isBeanConfigured()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.exit(0);
            }
        }
        Collection<TrxManagerInfo> trxManagerInfos = entityTrxManager.getTrxManagerInfos();
        for (TrxManagerInfo trxManagerInfo : trxManagerInfos) {
            File target = new File(output, trxManagerInfo.getName());
            target.mkdirs();
            for (Class<?> clazz : trxManagerInfo.getEntityClasses()) {
                EntityInfo entityInfo = trxManagerInfo.getEntityInfo(clazz);
                GridTool.generate(entityInfo, target);
            }
        }
        if (closeInMillis != null && closeInMillis > 0L) {
            Thread.sleep(closeInMillis);
        } else {
            Thread.sleep(3000L);
        }
        context.close();
    }

    public static String generate(EntityInfo entityInfo, int indent) throws Exception {
        String name = entityInfo.getEntityClass().getSimpleName();
        ObjectNode root = mapper.createObjectNode();
        root.put("name", name);
        root.put("title", name);
        GridTool.entity(root, entityInfo, true);
        return StringUtil.beautifyJson((String)root.toString(), (int)(indent > 0 ? indent : 4));
    }

    private static void generate(EntityInfo entityInfo, File target) throws Exception {
        String str = GridTool.generate(entityInfo, 4);
        String name = entityInfo.getEntityClass().getSimpleName();
        File file = new File(target, name + ".json");
        FileUtils.writeStringToFile((File)file, (String)str, (Charset)StandardCharsets.UTF_8, (boolean)false);
    }

    private static ObjectNode page(ObjectNode root) throws Exception {
        ObjectNode page = root.putObject("page");
        page.putArray("options").addAll((ArrayNode)mapper.convertValue(Arrays.asList(5, 10, 15, 20, 25, 30, 50), ArrayNode.class));
        page.put("default", 20);
        page.put("count", false);
        return page;
    }

    private static ObjectNode id(ObjectNode root, EntityInfo entityInfo) throws Exception {
        IdInfo info = entityInfo.getIdInfo();
        ObjectNode id = root.putObject("id");
        id.put("type", info.getIdType().name());
        id.putArray("fields").addAll((ArrayNode)mapper.convertValue(info.getFields(), ArrayNode.class));
        if (EntityIdType.EMBEDDED == info.getIdType()) {
            ArrayNode members = id.putArray("members");
            EntityInfo embedInfo = info.getEmbeddedEntityInfo();
            for (String fname : embedInfo.getFieldInfoNames()) {
                members.add(fname);
            }
        }
        return id;
    }

    private static ObjectNode order(ObjectNode root, EntityInfo entityInfo) throws Exception {
        ObjectNode sort = root.putObject("order");
        if (EntityAudit.class.isAssignableFrom(entityInfo.getEntityClass())) {
            sort.put("field", "createdOn");
        }
        sort.put("descending", true);
        return sort;
    }

    private static ObjectNode filter(String prefixName, FieldInfo fieldInfo, String type, Condition condition) {
        if (!EntityAudit.Name.Field.list().contains(fieldInfo.getName()) && !"deletedOn".equals(fieldInfo.getName())) {
            String fname = fieldInfo.getName();
            String pattern = fieldInfo.getFormat() != null ? fieldInfo.getFormat().trim() : "";
            ObjectNode filter = mapper.createObjectNode();
            filter.put("name", (String)(!prefixName.isEmpty() ? prefixName + "." : "") + fname);
            filter.put("label", fname.substring(0, 1).toUpperCase() + fname.substring(1));
            filter.put("type", type);
            filter.put("condition", condition.name());
            if (!pattern.isEmpty()) {
                filter.put("pattern", pattern);
            }
            return filter;
        }
        return null;
    }

    private static ObjectNode column(String prefixName, FieldInfo fieldInfo) {
        if (!"deletedOn".equals(fieldInfo.getName())) {
            String fname = fieldInfo.getName();
            ObjectNode column = mapper.createObjectNode();
            column.put("name", (String)(!prefixName.isEmpty() ? prefixName + "." : "") + fname);
            column.put("label", fname.substring(0, 1).toUpperCase() + fname.substring(1));
            column.put("field", !prefixName.isEmpty() ? prefixName : fname);
            column.put("align", "left");
            column.put("sortable", true);
            column.put("format", "");
            return column;
        }
        return null;
    }

    private static ObjectNode field(String prefixName, FieldInfo fieldInfo, String type) {
        if (!EntityAudit.Name.Field.list().contains(fieldInfo.getName()) && !"deletedOn".equals(fieldInfo.getName())) {
            String fname = fieldInfo.getName();
            String pattern = fieldInfo.getFormat() != null ? fieldInfo.getFormat().trim() : "";
            boolean nullable = Boolean.TRUE.equals(fieldInfo.getNullable());
            ObjectNode field = mapper.createObjectNode();
            field.put("name", (String)(!prefixName.isEmpty() ? prefixName + "." : "") + fname);
            field.put("label", fname.substring(0, 1).toUpperCase() + fname.substring(1));
            field.put("type", type);
            field.put("nullable", nullable);
            field.put("insertable", true);
            field.put("editable", true);
            if (!pattern.isEmpty()) {
                field.put("pattern", pattern);
            }
            ArrayNode validations = field.putArray("validations");
            if (!nullable) {
                validations.add("required");
            }
            if ("text".equals(type)) {
                Long length = fieldInfo.getLength();
                if (length != null && length > 0L) {
                    validations.add("maxlength:" + length);
                }
            } else if ("number".equals(type)) {
                validations.add("number");
            }
            if (validations.isEmpty()) {
                field.remove("validations");
            }
            return field;
        }
        return null;
    }

    private static List<Option> options(Class<?> type) throws Exception {
        if (type.isEnum()) {
            Enum[] values;
            ArrayList<Option> options = new ArrayList<Option>();
            for (Enum value : values = (Enum[])type.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                String name = (String)value.getClass().getMethod("name", new Class[0]).invoke((Object)value, new Object[0]);
                Option option = new Option(name, name);
                options.add(option);
            }
            return options;
        }
        return null;
    }

    private static boolean isIgnored(FieldInfo fieldInfo) {
        return fieldInfo.getAnnotation(JsonIgnore.class) != null;
    }

    private static ObjectNode lazyObject(ObjectNode root, FieldInfo fieldInfo) throws Exception {
        ObjectNode crud = (ObjectNode)root.get("crud");
        ArrayNode joins = null;
        joins = crud.has("joins") ? (ArrayNode)crud.get("joins") : crud.putArray("joins");
        ObjectNode field = GridTool.field("", fieldInfo, "pick");
        if (field == null) {
            return null;
        }
        if (fieldInfo.hasJoinRelations()) {
            EntityInfo srcInfo = fieldInfo.getEntityInfo();
            EntityInfo tgtInfo = srcInfo.getTrxManagerInfo().getEntityInfo(fieldInfo.getType());
            String gname = tgtInfo.getEntityClass().getSimpleName();
            ObjectNode join = mapper.createObjectNode();
            join.put("name", gname);
            join.put("store", fieldInfo.getName());
            join.put("match", "contain");
            ArrayNode relations = join.putArray("relations");
            ObjectNode relation = null;
            IdInfo tIdInfo = tgtInfo.getIdInfo();
            if (EntityIdType.COMPOSITE == tIdInfo.getIdType()) {
                JoinColumns joinColumns = fieldInfo.getJoinColumns();
                for (Map.Entry<String, String> entry : joinColumns.getRelations().entrySet()) {
                    FieldInfo fsInfo = joinColumns.getFieldInfo(entry.getKey());
                    FieldInfo ftInfo = tgtInfo.getColumnInfo(entry.getValue());
                    relation = mapper.createObjectNode();
                    relation.put("source", fieldInfo.getName() + "." + fsInfo.getName());
                    relation.put("target", ftInfo.getName());
                    relations.add((JsonNode)relation);
                }
            } else if (EntityIdType.STANDARD == tIdInfo.getIdType() || EntityIdType.EMBEDDED == tIdInfo.getIdType()) {
                relation = mapper.createObjectNode();
                relation.put("source", fieldInfo.getName());
                relation.put("target", tIdInfo.getFields().iterator().next());
                relations.add((JsonNode)relation);
            }
            if (relations.isEmpty()) {
                join.remove("relations");
            }
            joins.add((JsonNode)join);
            ObjectNode picks = null;
            picks = root.has("picks") ? (ObjectNode)root.get("picks") : root.putObject("picks");
            ObjectNode pick = null;
            Object keyname = null;
            if (picks.has(fieldInfo.getName())) {
                keyname = fieldInfo.getName() + "-" + (picks.size() + 1);
                pick = picks.putObject((String)keyname);
            } else {
                keyname = fieldInfo.getName();
                pick = picks.putObject((String)keyname);
            }
            pick.put("title", tgtInfo.getEntityClass().getSimpleName());
            GridTool.entity(pick, tgtInfo, false);
            field.put("pick", (String)keyname);
            field.put("format", "");
            field.put("toValue", "");
        } else {
            field.put("type", "text");
        }
        if (joins.isEmpty()) {
            crud.remove("joins");
        }
        return field;
    }

    private static Object[] filterAndField(String prefixName, FieldInfo fieldInfo) {
        ObjectNode filter = null;
        ObjectNode field = null;
        if (String.class.isAssignableFrom(fieldInfo.getType())) {
            filter = GridTool.filter(prefixName, fieldInfo, "text", Condition.ANY_LIKE);
            field = GridTool.field(prefixName, fieldInfo, "text");
        } else if (Character.class.isAssignableFrom(fieldInfo.getType())) {
            filter = GridTool.filter(prefixName, fieldInfo, "text", Condition.EQUAL);
            field = GridTool.field(prefixName, fieldInfo, "text");
        } else if (Number.class.isAssignableFrom(fieldInfo.getType()) || Integer.TYPE.isAssignableFrom(fieldInfo.getType()) || Long.TYPE.isAssignableFrom(fieldInfo.getType()) || Float.TYPE.isAssignableFrom(fieldInfo.getType()) || Double.TYPE.isAssignableFrom(fieldInfo.getType())) {
            filter = GridTool.filter(prefixName, fieldInfo, "number", Condition.EQUAL);
            field = GridTool.field(prefixName, fieldInfo, "number");
        } else if (Date.class.isAssignableFrom(fieldInfo.getType()) || LocalDateTime.class.isAssignableFrom(fieldInfo.getType()) || LocalDate.class.isAssignableFrom(fieldInfo.getType()) || LocalTime.class.isAssignableFrom(fieldInfo.getType())) {
            filter = GridTool.filter(prefixName, fieldInfo, "datetime", Condition.BETWEEN);
            field = GridTool.field(prefixName, fieldInfo, "datetime");
        } else {
            field = GridTool.field(prefixName, fieldInfo, "text");
        }
        return new Object[]{filter, field};
    }

    private static void filterAndFieldById(String prefixName, ObjectNode root, FieldInfo fieldInfo, boolean isAutoGenerated) {
        ObjectNode table = (ObjectNode)root.get("table");
        ArrayNode filters = (ArrayNode)table.get("filters");
        ArrayNode visibles = (ArrayNode)table.get("visibles");
        ArrayNode columns = (ArrayNode)table.get("columns");
        ArrayNode fields = (ArrayNode)root.get("fields");
        Object[] arrs = GridTool.filterAndField(prefixName, fieldInfo);
        ObjectNode filter = (ObjectNode)arrs[0];
        filters.add((JsonNode)filter);
        ObjectNode field = (ObjectNode)arrs[1];
        if (isAutoGenerated) {
            field.put("insertable", false);
        }
        field.put("editable", false);
        fields.add((JsonNode)field);
        ObjectNode column = GridTool.column(prefixName, fieldInfo);
        visibles.add(column.get("name").asText());
        columns.add((JsonNode)column);
    }

    private static void filterAndFieldById(ObjectNode root, EntityInfo entityInfo) {
        block3: {
            IdInfo idInfo;
            block4: {
                block2: {
                    idInfo = entityInfo.getIdInfo();
                    if (EntityIdType.STANDARD != idInfo.getIdType()) break block2;
                    GeneratedValue generatedValue = idInfo.getGeneratedValue();
                    boolean isAutoGenerated = generatedValue != null && (GenerationType.IDENTITY.equals((Object)generatedValue.strategy()) || GenerationType.AUTO.equals((Object)generatedValue.strategy()));
                    FieldInfo fieldInfo = entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
                    GridTool.filterAndFieldById("", root, fieldInfo, isAutoGenerated);
                    break block3;
                }
                if (EntityIdType.EMBEDDED != idInfo.getIdType()) break block4;
                String prefix = idInfo.getFields().iterator().next();
                EntityInfo embeddedInfo = idInfo.getEmbeddedEntityInfo();
                for (String fname : embeddedInfo.getFieldInfoNames()) {
                    FieldInfo fieldInfo = embeddedInfo.getFieldInfo(fname);
                    GridTool.filterAndFieldById(prefix, root, fieldInfo, false);
                }
                break block3;
            }
            if (EntityIdType.COMPOSITE != idInfo.getIdType()) break block3;
            for (String fname : idInfo.getFields()) {
                FieldInfo fieldInfo = entityInfo.getFieldInfo(fname);
                GridTool.filterAndFieldById("", root, fieldInfo, false);
            }
        }
    }

    private static void entity(ObjectNode root, EntityInfo entityInfo, boolean includeLazy) throws Exception {
        ObjectNode crud = root.putObject("crud");
        crud.put("name", entityInfo.getEntityClass().getSimpleName());
        GridTool.id(root, entityInfo);
        ObjectNode table = root.putObject("table");
        table.put("separator", "none");
        table.put("selection", "single");
        GridTool.page(table);
        GridTool.order(table, entityInfo);
        ArrayNode filters = table.putArray("filters");
        ArrayNode visibles = table.putArray("visibles");
        ArrayNode columns = table.putArray("columns");
        ArrayNode fields = root.putArray("fields");
        ObjectNode enums = root.putObject("enums");
        IdInfo idInfo = entityInfo.getIdInfo();
        GridTool.filterAndFieldById(root, entityInfo);
        HashSet<String> fnames = new HashSet<String>(entityInfo.getFieldInfoNames());
        fnames.removeAll(idInfo.getFields());
        for (String fname : fnames) {
            FieldInfo fieldInfo = entityInfo.getFieldInfo(fname);
            if (GridTool.isIgnored(fieldInfo)) continue;
            ObjectNode filter = null;
            ObjectNode column = null;
            ObjectNode field = null;
            if (includeLazy && entityInfo.getLazyObjectFields().containsKey(fieldInfo.getName())) {
                field = GridTool.lazyObject(root, fieldInfo);
            } else if (Converter.isEnum(fieldInfo.getConverter())) {
                List<Option> options = GridTool.options(fieldInfo.getType());
                if (options != null && !enums.has(fieldInfo.getType().getSimpleName())) {
                    enums.putArray(fieldInfo.getType().getSimpleName()).addAll((ArrayNode)mapper.convertValue(options, ArrayNode.class));
                }
                if ((filter = GridTool.filter("", fieldInfo, "enum", Condition.EQUAL)) != null) {
                    filter.put("enum", fieldInfo.getType().getSimpleName());
                }
                if ((field = GridTool.field("", fieldInfo, "enum")) != null) {
                    field.put("enum", fieldInfo.getType().getSimpleName());
                }
            } else if (Boolean.class.isAssignableFrom(fieldInfo.getType()) || Boolean.TYPE.isAssignableFrom(fieldInfo.getType())) {
                String enumKey = "Boolean";
                filter = GridTool.filter("", fieldInfo, "enum", Condition.EQUAL);
                if (filter != null) {
                    filter.put("enum", enumKey);
                }
                if ((field = GridTool.field("", fieldInfo, "enum")) != null) {
                    field.put("enum", enumKey);
                }
                if (!enums.has(enumKey)) {
                    ArrayNode enumBool = enums.putArray(enumKey);
                    ObjectNode enumTrue = mapper.createObjectNode();
                    enumTrue.put("value", true);
                    enumTrue.put("label", "True");
                    enumBool.add((JsonNode)enumTrue);
                    ObjectNode enumFalse = mapper.createObjectNode();
                    enumFalse.put("value", false);
                    enumFalse.put("label", "False");
                    enumBool.add((JsonNode)enumFalse);
                }
            } else {
                Object[] arrs = GridTool.filterAndField("", fieldInfo);
                filter = (ObjectNode)arrs[0];
                field = (ObjectNode)arrs[1];
            }
            if (filter != null) {
                filters.add(filter);
            }
            if ((column = GridTool.column("", fieldInfo)) != null) {
                visibles.add(column.get("name").asText());
                columns.add((JsonNode)column);
            }
            if (field == null) continue;
            fields.add((JsonNode)field);
        }
        if (filters.isEmpty()) {
            table.remove("filters");
        }
        if (visibles.isEmpty()) {
            table.remove("visibles");
        }
        if (columns.isEmpty()) {
            table.remove("columns");
        }
        if (enums.isEmpty()) {
            root.remove("enums");
        }
        if (!includeLazy || fields.isEmpty()) {
            root.remove("fields");
        }
    }
}

