/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.htmlunit;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.htmlunit.HtmlUnitConfig;
import net.ideahut.springboot.htmlunit.HtmlUnitHandler;
import net.ideahut.springboot.htmlunit.HtmlUnitRequest;
import net.ideahut.springboot.htmlunit.HtmlUnitResponse;

public class HtmlUnitHandlerImpl
implements HtmlUnitHandler {
    @Override
    public WebClient webClient(HtmlUnitConfig input) {
        HtmlUnitConfig.Options options;
        HtmlUnitConfig config = input != null ? input : new HtmlUnitConfig();
        BrowserVersion browserVersion = config.getVersion();
        if (browserVersion == null) {
            browserVersion = BrowserVersion.BEST_SUPPORTED;
        }
        WebClient webClient = new WebClient(browserVersion);
        WebClientOptions wcOptions = webClient.getOptions();
        HtmlUnitConfig.Proxy proxy = config.getProxy();
        if (proxy != null) {
            ProxyConfig proxyConfig = new ProxyConfig();
            proxyConfig.setProxyAutoConfigUrl(proxy.getAutoConfigUrl());
            proxyConfig.setProxyHost(proxy.getHost());
            proxyConfig.setProxyPort(proxy.getPort().intValue());
            proxyConfig.setSocksProxy(proxy.getIsSocks().booleanValue());
            Set<String> bypassHosts = proxy.getBypassHosts();
            if (bypassHosts != null) {
                for (String host : bypassHosts) {
                    proxyConfig.addHostsToProxyBypass(host);
                }
            }
            wcOptions.setProxyConfig(proxyConfig);
        }
        if ((options = config.getOptions()) == null) {
            options = new HtmlUnitConfig.Options();
        }
        wcOptions.setActiveXNative((options.getActiveXNative() != null ? options.getActiveXNative() : Boolean.FALSE).booleanValue());
        wcOptions.setAppletEnabled((options.getAppletEnabled() != null ? options.getAppletEnabled() : Boolean.FALSE).booleanValue());
        wcOptions.setCssEnabled((options.getCssEnabled() != null ? options.getCssEnabled() : Boolean.FALSE).booleanValue());
        wcOptions.setDoNotTrackEnabled((options.getDoNotTrackEnabled() != null ? options.getDoNotTrackEnabled() : Boolean.TRUE).booleanValue());
        wcOptions.setDownloadImages((options.getDownloadImages() != null ? options.getDownloadImages() : Boolean.FALSE).booleanValue());
        wcOptions.setGeolocationEnabled((options.getGeolocationEnabled() != null ? options.getGeolocationEnabled() : Boolean.FALSE).booleanValue());
        if (options.getHistoryPageCacheLimit() != null) {
            wcOptions.setHistoryPageCacheLimit(options.getHistoryPageCacheLimit().intValue());
        }
        if (options.getHistorySizeLimit() != null) {
            wcOptions.setHistorySizeLimit(options.getHistorySizeLimit().intValue());
        }
        if (options.getHomePage() != null) {
            wcOptions.setHomePage(options.getHomePage());
        }
        wcOptions.setJavaScriptEnabled((options.getJavaScriptEnabled() != null ? options.getJavaScriptEnabled() : Boolean.TRUE).booleanValue());
        if (options.getMaxInMemory() != null) {
            wcOptions.setMaxInMemory(options.getMaxInMemory().intValue());
        }
        wcOptions.setPopupBlockerEnabled((options.getPopupBlockerEnabled() != null ? options.getPopupBlockerEnabled() : Boolean.TRUE).booleanValue());
        wcOptions.setPrintContentOnFailingStatusCode((options.getPrintContentOnFailingStatusCode() != null ? options.getPrintContentOnFailingStatusCode() : Boolean.FALSE).booleanValue());
        wcOptions.setRedirectEnabled((options.getIsRedirectEnabled() != null ? options.getIsRedirectEnabled() : Boolean.TRUE).booleanValue());
        if (options.getScreenHeight() != null && options.getScreenHeight() > 0) {
            wcOptions.setScreenHeight(options.getScreenHeight().intValue());
        }
        if (options.getScreenWidth() != null && options.getScreenWidth() > 0) {
            wcOptions.setScreenWidth(options.getScreenWidth().intValue());
        }
        wcOptions.setThrowExceptionOnFailingStatusCode((options.getThrowExceptionOnFailingStatusCode() != null ? options.getThrowExceptionOnFailingStatusCode() : Boolean.FALSE).booleanValue());
        wcOptions.setThrowExceptionOnScriptError((options.getThrowExceptionOnScriptError() != null ? options.getThrowExceptionOnScriptError() : Boolean.FALSE).booleanValue());
        if (options.getTimeout() != null && options.getTimeout() > 0) {
            wcOptions.setTimeout(options.getTimeout().intValue());
        }
        wcOptions.setUseInsecureSSL((options.getUseInsecureSSL() != null ? options.getUseInsecureSSL() : Boolean.TRUE).booleanValue());
        if (options.getWebSocketMaxBinaryMessageBufferSize() != null) {
            wcOptions.setWebSocketMaxBinaryMessageBufferSize(options.getWebSocketMaxBinaryMessageBufferSize().intValue());
        }
        if (options.getWebSocketMaxBinaryMessageSize() != null) {
            wcOptions.setWebSocketMaxBinaryMessageSize(options.getWebSocketMaxBinaryMessageSize().intValue());
        }
        if (options.getWebSocketMaxTextMessageBufferSize() != null) {
            wcOptions.setWebSocketMaxTextMessageBufferSize(options.getWebSocketMaxTextMessageBufferSize().intValue());
        }
        if (options.getWebSocketMaxTextMessageSize() != null) {
            wcOptions.setWebSocketMaxTextMessageSize(options.getWebSocketMaxTextMessageSize().intValue());
        }
        webClient.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
        return webClient;
    }

    @Override
    public HtmlUnitResponse browse(WebClient webClient, HtmlUnitRequest request) throws Exception {
        Map<String, String> parameters;
        Map<String, String> headers;
        HttpMethod httpMethod = HttpMethod.GET;
        String method = request.getMethod();
        String string = method = method != null ? method.trim().toUpperCase() : "";
        if (!method.isEmpty()) {
            httpMethod = HttpMethod.valueOf((String)method);
        }
        URL url = new URL(request.getUrl());
        WebRequest webRequest = new WebRequest(url, httpMethod);
        if (request.getBody() != null) {
            webRequest.setRequestBody(request.getBody());
        }
        if ((headers = request.getHeaders()) != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                webRequest.setAdditionalHeader(entry.getKey(), entry.getValue());
            }
        }
        if ((parameters = request.getParameters()) != null && !parameters.isEmpty()) {
            ArrayList<NameValuePair> lparams = new ArrayList<NameValuePair>();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                lparams.add(new NameValuePair(entry.getKey(), entry.getValue()));
            }
            webRequest.setRequestParameters(lparams);
        }
        HtmlPage page = (HtmlPage)webClient.getPage(webRequest);
        HtmlUnitResponse response = new HtmlUnitResponse();
        response.setPage(page);
        Map<String, String> scripts = request.getScripts();
        if (scripts != null && !scripts.isEmpty()) {
            HashMap<String, String> mscripts = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : scripts.entrySet()) {
                ScriptResult sresult = page.executeJavaScript(entry.getValue());
                Object oresult = sresult != null ? sresult.getJavaScriptResult() : null;
                mscripts.put(entry.getKey(), oresult != null ? oresult.toString() : "");
            }
            response.setScripts(mscripts);
        }
        WebResponse webResponse = page.getWebResponse();
        response.setBody(webResponse.getContentAsString());
        List rheaders = webResponse.getResponseHeaders();
        if (rheaders != null) {
            response.setHeaders(new HashMap<String, String>());
            for (NameValuePair nvp : rheaders) {
                if (nvp.getValue() == null) continue;
                response.getHeaders().put(nvp.getName(), nvp.getValue());
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HtmlUnitResponse browse(HtmlUnitConfig config, HtmlUnitRequest request, boolean autoClose) throws Exception {
        WebClient webClient = null;
        try {
            webClient = this.webClient(config);
            HtmlUnitResponse htmlUnitResponse = this.browse(webClient, request);
            return htmlUnitResponse;
        }
        finally {
            if (autoClose && webClient != null) {
                webClient.close();
            }
        }
    }
}

