/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.init;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.init.InitEnum;
import net.ideahut.springboot.init.InitHandler;
import net.ideahut.springboot.init.InitMapper;
import net.ideahut.springboot.init.InitRequest;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import org.apache.commons.io.IOUtils;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.sql.spi.NativeQueryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;

public class InitHandlerImpl
implements InitHandler {
    private static final Logger log = LoggerFactory.getLogger(InitHandlerImpl.class);
    private InitHandler.Endpoint endpoint;
    private Runnable servletCall;

    public InitHandlerImpl setEndpoint(InitHandler.Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public InitHandlerImpl setServletCall(Runnable servletCall) {
        this.servletCall = servletCall;
        return this;
    }

    @Override
    public void initMapper(ApplicationContext context) throws Exception {
        Map mapObjectMapper = context.getBeansOfType(ObjectMapper.class);
        for (Object mapper : mapObjectMapper.values()) {
            InitMapper.loadDefault((ObjectMapper)mapper);
        }
        Map mapDataMapper = context.getBeansOfType(DataMapper.class);
        for (DataMapper mapper : mapDataMapper.values()) {
            InitMapper.loadDefault(mapper);
        }
        Map mapInitMapper = context.getBeansOfType(InitMapper.class);
        for (InitMapper initMapper : mapInitMapper.values()) {
            initMapper.onInitMapper();
        }
    }

    @Override
    public void initClass() {
        JsonNodeType.class.getName();
        EntityNative.class.getName();
        EntityNative.ColumnConverter.class.getName();
        EntityNative.LazyLoad.class.getName();
        EntityNative.Parameter.class.getName();
        EntityNative.Select.class.getName();
        JdbcCoordinatorImpl.class.getName();
        SessionEventListenerManager.class.getName();
        QueryImplementor.class.getName();
        NativeQueryImplementor.class.getName();
        TransactionImplementor.class.getName();
    }

    @Override
    public void initServlet() {
        if (this.servletCall != null) {
            this.servletCall.run();
        } else {
            String url = this.endpoint != null ? this.endpoint.getUrl() : null;
            String string = url = url != null ? url.trim() : "";
            if (!url.isEmpty()) {
                log.info("Sending request to force DispatcherServlet initialization...");
                DataMapperImpl mapper = new DataMapperImpl();
                byte[] body = mapper.writeAsBytes(this.sampleRequest(), 1);
                long start = System.nanoTime();
                try {
                    URL u = new URL(url);
                    HttpURLConnection c = (HttpURLConnection)u.openConnection();
                    c.setConnectTimeout(5000);
                    c.setReadTimeout(30000);
                    c.setRequestMethod(HttpMethod.POST.name());
                    c.setRequestProperty("Content-Type", "application/json");
                    c.setRequestProperty("Accept", "application/json");
                    c.setDoOutput(true);
                    OutputStream o = c.getOutputStream();
                    o.write(body);
                    o.flush();
                    o.close();
                    int status = c.getResponseCode();
                    String content = IOUtils.toString((InputStream)c.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    log.info("...done DispatcherServlet initialization (" + (System.nanoTime() - start) + " ns), response status: " + status + ", content: " + content);
                }
                catch (Exception e) {
                    log.error("... failed DispatcherServlet initialization (" + (System.nanoTime() - start) + " ns): " + e);
                }
            }
        }
    }

    @Override
    public void initValidation() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.sampleRequest(), new Class[0]);
        log.info("Number of violations found: " + violations.size());
    }

    private InitRequest sampleRequest() {
        InitRequest message = new InitRequest();
        message.setInitString("init string");
        message.setInitNumber(15);
        message.setInitBigDecimal(BigDecimal.TEN);
        message.setInitEnum(InitEnum.WARM);
        return message;
    }
}

