/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.job.JobEntityClass;
import net.ideahut.springboot.job.JobService;
import net.ideahut.springboot.job.SchedulerHelper;
import net.ideahut.springboot.job.dto.JobGroupDto;
import net.ideahut.springboot.job.dto.JobTriggerConfigDto;
import net.ideahut.springboot.job.dto.JobTriggerDto;
import net.ideahut.springboot.job.dto.JobTypeDto;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.task.TaskHandler;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.Session;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.Query;
import org.springframework.util.Assert;

class JobServiceImpl
implements JobService {
    private TrxManagerInfo trxManagerInfo;
    private DataMapper dataMapper;
    private EntityTrxManager entityTrxManager;
    private TaskHandler taskHandler;
    private JobEntityClass entityClass;
    private String traceKey;

    JobServiceImpl() {
    }

    JobServiceImpl setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    JobServiceImpl setEntityTrxManager(EntityTrxManager entityTrxManager) {
        this.entityTrxManager = entityTrxManager;
        return this;
    }

    JobServiceImpl setTaskHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
        return this;
    }

    JobServiceImpl setEntityClass(JobEntityClass entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    JobServiceImpl setTraceKey(String traceKey) {
        this.traceKey = traceKey;
        return this;
    }

    JobServiceImpl build() throws Exception {
        Assert.notNull((Object)this.entityTrxManager, (String)"entityTrxManager is required");
        Assert.notNull((Object)this.taskHandler, (String)"taskHandler is required");
        SchedulerHelper.fixEntityClass(this.entityTrxManager, this.entityClass);
        String string = this.traceKey = this.traceKey != null ? this.traceKey.trim() : "";
        if (this.traceKey.isEmpty()) {
            this.traceKey = "traceId";
        }
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        this.trxManagerInfo = FrameworkUtil.getTrxManagerInfo(this.entityTrxManager, this.entityClass.getTrxManagerName());
        Assert.notNull((Object)this.trxManagerInfo, (String)("TrxManagerInfo is not found: " + this.entityClass.getTrxManagerName()));
        return this;
    }

    public String getTraceKey() {
        return this.traceKey;
    }

    public List<JobGroupDto> getGroups(final String instanceId, final Boolean isActive) {
        List<Object> items = this.trxManagerInfo.transaction(new SessionCallable<List<Object>>(){

            @Override
            public List<Object> call(Session session) throws Exception {
                String iid;
                ArrayList<Object> parameters = new ArrayList<Object>();
                String hql = "select a from " + JobServiceImpl.this.entityClass.getGroup().getName() + " a inner join " + JobServiceImpl.this.entityClass.getTrigger().getName() + " b on b.groupId = a.groupId where 1=1 ";
                if (isActive != null) {
                    Character active = Boolean.TRUE.equals(isActive) ? FrameworkUtil.YES : FrameworkUtil.NO;
                    parameters.add(active);
                    hql = hql + "and a.isActive = ?" + parameters.size() + " and b.isActive = ?" + parameters.size() + " ";
                }
                hql = hql + "and (b.instanceId is null ";
                String string = iid = instanceId != null ? instanceId.trim() : "";
                if (!iid.isEmpty()) {
                    parameters.add(iid);
                    hql = hql + "or b.instanceId=?" + parameters.size();
                }
                hql = hql + ") ";
                Query query = session.createQuery(hql, Object.class);
                for (int i = 0; i < parameters.size(); ++i) {
                    query.setParameter(i + 1, parameters.get(i));
                }
                List items = query.getResultList();
                JobServiceImpl.this.trxManagerInfo.loadLazy(items, JobServiceImpl.this.entityClass.getGroup());
                return items;
            }
        });
        ArrayList<JobGroupDto> groups = new ArrayList<JobGroupDto>();
        while (!items.isEmpty()) {
            JobGroupDto group = this.dataMapper.copy(items.remove(0), JobGroupDto.class);
            groups.add(group);
        }
        return groups;
    }

    public List<JobGroupDto> getGroupsWithTriggers(final String instanceId, final Boolean isActive, final Collection<String> groupIds, Boolean includeConfigs) {
        Future futureTrigger = this.taskHandler.submit((Callable)new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                return JobServiceImpl.this.trxManagerInfo.transaction(new SessionCallable<Object[]>(){

                    @Override
                    public Object[] call(Session session) throws Exception {
                        String iid;
                        ArrayList<Object> parameters = new ArrayList<Object>();
                        String hql = "select a, b, c from " + JobServiceImpl.this.entityClass.getTrigger().getName() + " a inner join " + JobServiceImpl.this.entityClass.getType().getName() + " b on b.typeId = a.typeId inner join " + JobServiceImpl.this.entityClass.getGroup().getName() + " c on c.groupId = a.groupId where 1=1 ";
                        if (isActive != null) {
                            Character active = Boolean.TRUE.equals(isActive) ? FrameworkUtil.YES : FrameworkUtil.NO;
                            parameters.add(active);
                            hql = hql + "and a.isActive = ?" + parameters.size() + " and c.isActive = ?" + parameters.size() + " ";
                        }
                        hql = hql + "and (a.instanceId is null ";
                        String string = iid = instanceId != null ? instanceId.trim() : "";
                        if (!iid.isEmpty()) {
                            parameters.add(iid);
                            hql = hql + "or a.instanceId=?" + parameters.size();
                        }
                        hql = hql + ") ";
                        if (groupIds != null && !groupIds.isEmpty()) {
                            parameters.add(groupIds);
                            hql = hql + "and c.groupId in (?" + parameters.size() + ") ";
                        }
                        Query query = session.createQuery(hql, Object[].class);
                        for (int i = 0; i < parameters.size(); ++i) {
                            query.setParameter(i + 1, parameters.get(i));
                        }
                        HashMap<String, Integer> groupIndexes = new HashMap<String, Integer>();
                        HashMap<String, Integer[]> triggerIndexes = new HashMap<String, Integer[]>();
                        ArrayList<JobGroupDto> groups = new ArrayList<JobGroupDto>();
                        List items = query.getResultList();
                        while (!items.isEmpty()) {
                            Object[] item = (Object[])items.remove(0);
                            JobServiceImpl.this.trxManagerInfo.loadLazy(item[0], JobServiceImpl.this.entityClass.getTrigger());
                            JobTriggerDto trigger = JobServiceImpl.this.dataMapper.copy(item[0], JobTriggerDto.class);
                            trigger.setConfig(new HashMap());
                            JobServiceImpl.this.trxManagerInfo.loadLazy(item[1], JobServiceImpl.this.entityClass.getType());
                            JobTypeDto type = JobServiceImpl.this.dataMapper.copy(item[1], JobTypeDto.class);
                            trigger.setType(type);
                            JobServiceImpl.this.trxManagerInfo.loadLazy(item[2], JobServiceImpl.this.entityClass.getGroup());
                            JobGroupDto group = JobServiceImpl.this.dataMapper.copy(item[2], JobGroupDto.class);
                            trigger.setGroup(JobGroupDto.create().setGroupId(group.getGroupId()));
                            Integer groupIndex = groupIndexes.getOrDefault(group.getGroupId(), null);
                            if (groupIndex == null) {
                                groupIndex = groups.size();
                                groups.add(group);
                                groupIndexes.put(group.getGroupId(), groupIndex);
                                group.setTriggers(new ArrayList());
                            }
                            group = (JobGroupDto)groups.get(groupIndex);
                            Integer[] triggerIndex = triggerIndexes.getOrDefault(trigger.getTriggerId(), null);
                            if (triggerIndex != null) continue;
                            triggerIndex = new Integer[]{groupIndex, group.getTriggers().size()};
                            triggerIndexes.put(trigger.getTriggerId(), triggerIndex);
                            group.getTriggers().add(trigger);
                        }
                        groupIndexes.clear();
                        return new Object[]{groups, triggerIndexes};
                    }
                });
            }
        });
        Future futureConfig = null;
        if (Boolean.TRUE.equals(includeConfigs)) {
            futureConfig = this.taskHandler.submit((Callable)new Callable<List<JobTriggerConfigDto>>(){

                @Override
                public List<JobTriggerConfigDto> call() throws Exception {
                    return JobServiceImpl.this.trxManagerInfo.transaction(new SessionCallable<List<JobTriggerConfigDto>>(){

                        @Override
                        public List<JobTriggerConfigDto> call(Session session) throws Exception {
                            String iid;
                            ArrayList<Object> parameters = new ArrayList<Object>();
                            String hql = "from " + JobServiceImpl.this.entityClass.getTriggerConfig().getName() + " where triggerId IN (select a.triggerId from " + JobServiceImpl.this.entityClass.getTrigger().getName() + " a inner join " + JobServiceImpl.this.entityClass.getType().getName() + " b on b.typeId = a.typeId inner join " + JobServiceImpl.this.entityClass.getGroup().getName() + " c on c.groupId = a.groupId where 1=1 ";
                            if (isActive != null) {
                                Character active = Boolean.TRUE.equals(isActive) ? FrameworkUtil.YES : FrameworkUtil.NO;
                                parameters.add(active);
                                hql = hql + "and a.isActive = ?" + parameters.size() + " and c.isActive = ?" + parameters.size() + " ";
                            }
                            hql = hql + "and (a.instanceId is null ";
                            String string = iid = instanceId != null ? instanceId.trim() : "";
                            if (!iid.isEmpty()) {
                                parameters.add(iid);
                                hql = hql + "or a.instanceId = ?" + parameters.size();
                            }
                            hql = hql + ") ";
                            if (groupIds != null && !groupIds.isEmpty()) {
                                parameters.add(groupIds);
                                hql = hql + "and c.groupId in (?" + parameters.size() + ") ";
                            }
                            hql = hql + ")";
                            Query query = session.createQuery(hql, Object.class);
                            for (int i = 0; i < parameters.size(); ++i) {
                                query.setParameter(i + 1, parameters.get(i));
                            }
                            List items = query.getResultList();
                            ArrayList<JobTriggerConfigDto> configs = new ArrayList<JobTriggerConfigDto>();
                            while (!items.isEmpty()) {
                                Object item = items.remove(0);
                                JobServiceImpl.this.trxManagerInfo.loadLazy(item, JobServiceImpl.this.entityClass.getTriggerConfig()).nullAudit(item);
                                JobTriggerConfigDto config = JobServiceImpl.this.dataMapper.copy(item, JobTriggerConfigDto.class);
                                configs.add(config);
                            }
                            return configs;
                        }
                    });
                }
            });
        }
        try {
            Object[] objects = (Object[])futureTrigger.get();
            List groups = (List)objects[0];
            Map indexes = (Map)objects[1];
            List configs = new ArrayList();
            if (futureConfig != null) {
                configs = (List)futureConfig.get();
            }
            if (groups != null && !groups.isEmpty()) {
                while (!configs.isEmpty()) {
                    JobTriggerConfigDto config = (JobTriggerConfigDto)configs.remove(0);
                    Integer[] index = indexes.getOrDefault(config.getTriggerId(), null);
                    if (index == null) continue;
                    ((JobTriggerDto)((JobGroupDto)groups.get(index[0])).getTriggers().get(index[1])).setConfig(config.getName(), config.getValue());
                }
                indexes.clear();
            }
            return groups;
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    public JobTriggerDto getTrigger(final String triggerId, Boolean includeConfigs) {
        Future futureTrigger = this.taskHandler.submit((Callable)new Callable<JobTriggerDto>(){

            @Override
            public JobTriggerDto call() throws Exception {
                return JobServiceImpl.this.trxManagerInfo.transaction(new SessionCallable<JobTriggerDto>(){

                    @Override
                    public JobTriggerDto call(Session session) throws Exception {
                        String hql = "select a, b, c from " + JobServiceImpl.this.entityClass.getTrigger().getName() + " a inner join " + JobServiceImpl.this.entityClass.getType().getName() + " b on b.typeId = a.typeId inner join " + JobServiceImpl.this.entityClass.getGroup().getName() + " c on c.groupId = a.groupId where a.triggerId = ?1 ";
                        Query query = session.createQuery(hql, Object[].class);
                        query.setParameter(1, (Object)triggerId);
                        Object[] item = (Object[])query.uniqueResult();
                        if (item == null) {
                            return null;
                        }
                        JobServiceImpl.this.trxManagerInfo.loadLazy(item[0], JobServiceImpl.this.entityClass.getTrigger());
                        JobTriggerDto trigger = JobServiceImpl.this.dataMapper.copy(item[0], JobTriggerDto.class);
                        trigger.setConfig(new HashMap());
                        JobServiceImpl.this.trxManagerInfo.loadLazy(item[1], JobServiceImpl.this.entityClass.getType());
                        JobTypeDto type = JobServiceImpl.this.dataMapper.copy(item[1], JobTypeDto.class);
                        trigger.setType(type);
                        JobServiceImpl.this.trxManagerInfo.loadLazy(item[2], JobServiceImpl.this.entityClass.getGroup());
                        JobGroupDto group = JobServiceImpl.this.dataMapper.copy(item[2], JobGroupDto.class);
                        trigger.setGroup(group);
                        return trigger;
                    }
                });
            }
        });
        Future futureConfig = null;
        if (Boolean.TRUE.equals(includeConfigs)) {
            futureConfig = this.taskHandler.submit((Callable)new Callable<List<JobTriggerConfigDto>>(){

                @Override
                public List<JobTriggerConfigDto> call() throws Exception {
                    return JobServiceImpl.this.trxManagerInfo.transaction(new SessionCallable<List<JobTriggerConfigDto>>(){

                        @Override
                        public List<JobTriggerConfigDto> call(Session session) throws Exception {
                            String hql = "from " + JobServiceImpl.this.entityClass.getTriggerConfig().getName() + " where triggerId = ?1 ";
                            Query query = session.createQuery(hql, Object.class);
                            query.setParameter(1, (Object)triggerId);
                            List items = query.getResultList();
                            ArrayList<JobTriggerConfigDto> configs = new ArrayList<JobTriggerConfigDto>();
                            while (!items.isEmpty()) {
                                Object item = items.remove(0);
                                JobServiceImpl.this.trxManagerInfo.loadLazy(item, JobServiceImpl.this.entityClass.getTriggerConfig());
                                JobTriggerConfigDto config = JobServiceImpl.this.dataMapper.copy(item, JobTriggerConfigDto.class);
                                configs.add(config);
                            }
                            return configs;
                        }
                    });
                }
            });
        }
        try {
            JobTriggerDto trigger = (JobTriggerDto)futureTrigger.get();
            List configs = new ArrayList();
            if (futureConfig != null) {
                configs = (List)futureConfig.get();
            }
            while (!configs.isEmpty()) {
                JobTriggerConfigDto config = (JobTriggerConfigDto)configs.remove(0);
                trigger.setConfig(config.getName(), config.getValue());
            }
            return trigger;
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    public Map<String, JobTriggerDto> getTriggerMap(Collection<String> triggerIds) {
        if (triggerIds != null && !triggerIds.isEmpty()) {
            final LinkedHashSet<String> ids = new LinkedHashSet<String>(triggerIds);
            return this.trxManagerInfo.transaction(new SessionCallable<Map<String, JobTriggerDto>>(){

                @Override
                public Map<String, JobTriggerDto> call(Session session) throws Exception {
                    Query query = session.createQuery("select a, b from " + JobServiceImpl.this.entityClass.getTrigger().getName() + " a inner join " + JobServiceImpl.this.entityClass.getGroup().getName() + " b on b.groupId = a.groupId where a.triggerId in (?1)", Object[].class);
                    List items = query.setParameter(1, (Object)ids).getResultList();
                    LinkedHashMap<String, JobTriggerDto> triggers = new LinkedHashMap<String, JobTriggerDto>();
                    while (!items.isEmpty()) {
                        Object[] item = (Object[])items.remove(0);
                        JobServiceImpl.this.trxManagerInfo.loadLazy(item[0], JobServiceImpl.this.entityClass.getTrigger());
                        JobTriggerDto trigger = JobServiceImpl.this.dataMapper.copy(item[0], JobTriggerDto.class);
                        JobServiceImpl.this.trxManagerInfo.loadLazy(item[1], JobServiceImpl.this.entityClass.getGroup());
                        JobGroupDto group = JobServiceImpl.this.dataMapper.copy(item[1], JobGroupDto.class);
                        trigger.setGroup(group);
                        triggers.put(trigger.getTriggerId(), trigger);
                    }
                    return triggers;
                }
            });
        }
        return new LinkedHashMap<String, JobTriggerDto>();
    }

    public void setTypeIsRunning(final String typeId, final Boolean isRunning) {
        this.trxManagerInfo.transaction(true, new SessionCallable<Void>(){

            @Override
            public Void call(Session session) throws Exception {
                session.createMutationQuery("update " + JobServiceImpl.this.entityClass.getType().getName() + " set isRunning = ?1 where typeId = ?2").setParameter(1, (Object)(Boolean.TRUE.equals(isRunning) ? FrameworkUtil.YES : FrameworkUtil.NO)).setParameter(2, (Object)typeId).executeUpdate();
                return null;
            }
        });
    }

    public void resetAllTypeRunning() {
        this.trxManagerInfo.transaction(true, new SessionCallable<Void>(){

            @Override
            public Void call(Session session) throws Exception {
                session.createMutationQuery("update " + JobServiceImpl.this.entityClass.getType().getName() + " set isRunning = ?1").setParameter(1, (Object)FrameworkUtil.NO).executeUpdate();
                return null;
            }
        });
    }

    public void saveTypeResult(final String typeId, final Boolean isRunning, final Long lastRunTime, final String lastRunTriggerId, final String lastRunData) {
        this.trxManagerInfo.transaction(true, new SessionCallable<Void>(){

            @Override
            public Void call(Session session) throws Exception {
                MutationQuery query = session.createMutationQuery("update " + JobServiceImpl.this.entityClass.getType().getName() + " set isRunning = ?1,lastRunTime = ?2,lastRunTriggerId = ?3 " + (lastRunData != null ? ", lastRunData = ?4 " : "") + "where typeId = " + (lastRunData != null ? "?5" : "?4")).setParameter(1, (Object)(Boolean.TRUE.equals(isRunning) ? FrameworkUtil.YES : FrameworkUtil.NO)).setParameter(2, (Object)lastRunTime).setParameter(3, (Object)lastRunTriggerId);
                if (lastRunData != null) {
                    query.setParameter(4, (Object)lastRunData);
                    query.setParameter(5, (Object)typeId);
                } else {
                    query.setParameter(4, (Object)typeId);
                }
                query.executeUpdate();
                return null;
            }
        });
    }

    public void saveTriggerResult(final String triggerId, final Long lastRunTime, final String lastRunData) {
        this.trxManagerInfo.transaction(true, new SessionCallable<Void>(){

            @Override
            public Void call(Session session) throws Exception {
                MutationQuery query = session.createMutationQuery("update " + JobServiceImpl.this.entityClass.getTrigger().getName() + " set lastRunTime = ?1 " + (lastRunData != null ? ", lastRunData = ?2 " : "") + "where triggerId = " + (lastRunData != null ? "?3" : "?2")).setParameter(1, (Object)lastRunTime);
                if (lastRunData != null) {
                    query.setParameter(2, (Object)lastRunData);
                    query.setParameter(3, (Object)triggerId);
                } else {
                    query.setParameter(2, (Object)triggerId);
                }
                query.executeUpdate();
                return null;
            }
        });
    }
}

