/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.job;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.job.JobEntityClass;
import net.ideahut.springboot.job.JobService;
import net.ideahut.springboot.job.JobServiceImpl;
import net.ideahut.springboot.job.SchedulerHandler;
import net.ideahut.springboot.job.SchedulerHelper;
import net.ideahut.springboot.job.dto.JobGroupDto;
import net.ideahut.springboot.job.dto.JobTriggerDto;
import net.ideahut.springboot.job.dto.TriggerStatus;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.task.TaskHandler;
import net.ideahut.springboot.util.FrameworkUtil;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.core.QuartzScheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class SchedulerHandlerImpl
implements SchedulerHandler,
InitializingBean,
BeanConfigure<SchedulerHandler> {
    private boolean configured = false;
    protected ApplicationContext applicationContext;
    protected DataMapper dataMapper;
    protected JobService jobService;
    protected EntityTrxManager entityTrxManager;
    protected JobEntityClass entityClass;
    protected TaskHandler taskHandler;
    protected String traceKey;
    protected SchedulerFactory schedulerFactory;
    protected Scheduler scheduler;
    protected String instanceId;
    protected Set<String> jobPackages;

    public SchedulerHandlerImpl setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public SchedulerHandlerImpl setJobService(JobService jobService) {
        this.jobService = jobService;
        return this;
    }

    public SchedulerHandlerImpl setEntityTrxManager(EntityTrxManager entityTrxManager) {
        this.entityTrxManager = entityTrxManager;
        return this;
    }

    public SchedulerHandlerImpl setEntityClass(JobEntityClass entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    public SchedulerHandlerImpl setTaskHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
        return this;
    }

    public SchedulerHandlerImpl setTraceKey(String traceKey) {
        this.traceKey = traceKey;
        return this;
    }

    public SchedulerHandlerImpl setSchedulerFactory(SchedulerFactory schedulerFactory) {
        this.schedulerFactory = schedulerFactory;
        return this;
    }

    public SchedulerHandlerImpl setInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public SchedulerHandlerImpl setJobPackages(Set<String> jobPackages) {
        this.jobPackages = jobPackages;
        return this;
    }

    public SchedulerHandlerImpl setJobPackages(String ... jobPackages) {
        if (jobPackages != null) {
            this.jobPackages = new LinkedHashSet<String>();
            for (String jobPackage : jobPackages) {
                this.jobPackages.add(jobPackage);
            }
        }
        return this;
    }

    @Override
    public Callable<SchedulerHandler> onConfigureBean(ApplicationContext applicationContext) {
        final SchedulerHandlerImpl self = this;
        self.applicationContext = applicationContext;
        return new Callable<SchedulerHandler>(){

            @Override
            public SchedulerHandler call() throws Exception {
                String string = SchedulerHandlerImpl.this.instanceId = SchedulerHandlerImpl.this.instanceId != null ? SchedulerHandlerImpl.this.instanceId.trim() : "";
                if (SchedulerHandlerImpl.this.instanceId.isEmpty()) {
                    SchedulerHandlerImpl.this.instanceId = self.applicationContext.getId() != null ? self.applicationContext.getId().trim() : "";
                    Assert.hasLength((String)SchedulerHandlerImpl.this.instanceId, (String)"instanceId is required");
                }
                if (SchedulerHandlerImpl.this.jobService == null) {
                    SchedulerHandlerImpl.this.jobService = new JobServiceImpl().setEntityClass(SchedulerHandlerImpl.this.entityClass).setEntityTrxManager(SchedulerHandlerImpl.this.entityTrxManager).setTaskHandler(SchedulerHandlerImpl.this.taskHandler).setTraceKey(SchedulerHandlerImpl.this.traceKey).build();
                }
                SchedulerHandlerImpl.this.configured = true;
                return self;
            }
        };
    }

    @Override
    public boolean isBeanConfigured() {
        return this.configured;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.jobPackages == null) {
            this.jobPackages = new LinkedHashSet<String>();
        }
        if (this.schedulerFactory == null) {
            this.schedulerFactory = new StdSchedulerFactory();
        }
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
    }

    public String getInstanceId() {
        BeanConfigure.checkBeanConfigure(this);
        return this.instanceId;
    }

    public JobService jobService() {
        BeanConfigure.checkBeanConfigure(this);
        return this.jobService;
    }

    public Set<String> packages() {
        BeanConfigure.checkBeanConfigure(this);
        return this.jobPackages;
    }

    public List<JobGroupDto> groups(Boolean isActive) {
        BeanConfigure.checkBeanConfigure(this);
        return this.jobService.getGroups(this.instanceId, isActive);
    }

    public List<JobGroupDto> groupsWithTriggers(Boolean isActive, Collection<String> groupIds) {
        BeanConfigure.checkBeanConfigure(this);
        List groups = this.jobService.getGroupsWithTriggers(this.instanceId, isActive, groupIds, Boolean.valueOf(false));
        if (this.scheduler != null) {
            for (JobGroupDto group : groups) {
                for (JobTriggerDto trigger : group.getTriggers()) {
                    TriggerKey key = new TriggerKey(trigger.getTriggerId(), trigger.getGroup().getGroupId());
                    TriggerStatus status = new TriggerStatus();
                    status.setScheduled(Boolean.valueOf(false));
                    SchedulerHelper.updateStatus(this, key, status);
                    trigger.setStatus(status);
                    trigger.setLastRunData(null);
                    trigger.setLastRunTime(null);
                    trigger.setInstanceId(null);
                    trigger.setConfig(null);
                }
            }
        }
        return groups;
    }

    public synchronized boolean start() throws Exception {
        BeanConfigure.checkBeanConfigure(this);
        if (this.scheduler != null) {
            return true;
        }
        this.scheduler = this.schedulerFactory.getScheduler();
        SchedulerHelper.start(this);
        return true;
    }

    public synchronized boolean stop(boolean waitForJobsToComplete) throws Exception {
        BeanConfigure.checkBeanConfigure(this);
        if (this.scheduler == null) {
            return true;
        }
        this.scheduler.shutdown(waitForJobsToComplete);
        this.scheduler = null;
        return true;
    }

    public boolean running() throws Exception {
        BeanConfigure.checkBeanConfigure(this);
        return this.scheduler != null && this.scheduler.isStarted();
    }

    public MapStringObject metadata() throws Exception {
        SchedulerMetaData metadata;
        BeanConfigure.checkBeanConfigure(this);
        if (this.scheduler != null) {
            metadata = this.scheduler.getMetaData();
        } else {
            String version = QuartzScheduler.getVersionMajor() + "." + QuartzScheduler.getVersionMinor() + "." + QuartzScheduler.getVersionIteration();
            metadata = new SchedulerMetaData(null, null, Void.class, false, false, false, true, null, 0, Void.class, false, false, Void.class, 0, version);
        }
        return this.dataMapper.copy((Object)metadata, MapStringObject.class);
    }

    public synchronized JobTriggerDto pause(String triggerId) throws Exception {
        BeanConfigure.checkBeanConfigure(this);
        JobTriggerDto trigger = SchedulerHelper.getTrigger(this, triggerId);
        TriggerKey key = SchedulerHelper.getTriggerKey(this, trigger);
        Trigger.TriggerState state = this.scheduler.getTriggerState(key);
        if (Trigger.TriggerState.PAUSED != state) {
            this.scheduler.pauseTrigger(key);
        }
        SchedulerHelper.updateStatus(this, key, trigger.getStatus());
        return trigger;
    }

    public synchronized JobTriggerDto resume(String triggerId) throws Exception {
        BeanConfigure.checkBeanConfigure(this);
        JobTriggerDto trigger = SchedulerHelper.getTrigger(this, triggerId);
        TriggerKey key = SchedulerHelper.getTriggerKey(this, trigger);
        Trigger.TriggerState state = this.scheduler.getTriggerState(key);
        if (Trigger.TriggerState.PAUSED == state) {
            this.scheduler.resumeTrigger(key);
        }
        SchedulerHelper.updateStatus(this, key, trigger.getStatus());
        return trigger;
    }

    public synchronized JobTriggerDto trigger(String triggerId) throws Exception {
        BeanConfigure.checkBeanConfigure(this);
        JobTriggerDto trigger = SchedulerHelper.getTrigger(this, triggerId);
        JobKey jobKey = new JobKey(trigger.getTriggerId(), trigger.getGroup().getGroupId());
        Assert.isTrue((boolean)this.scheduler.checkExists(jobKey), (String)"JobKey is not available");
        this.scheduler.triggerJob(jobKey);
        TriggerKey triggerKey = new TriggerKey(trigger.getTriggerId(), trigger.getGroup().getGroupId());
        SchedulerHelper.updateStatus(this, triggerKey, trigger.getStatus());
        return trigger;
    }

    public JobTriggerDto delete(String triggerId) throws Exception {
        BeanConfigure.checkBeanConfigure(this);
        JobTriggerDto trigger = SchedulerHelper.getTrigger(this, triggerId);
        JobKey jobKey = new JobKey(trigger.getTriggerId(), trigger.getGroup().getGroupId());
        Assert.isTrue((boolean)this.scheduler.checkExists(jobKey), (String)"JobKey is not available");
        this.scheduler.deleteJob(jobKey);
        TriggerKey triggerKey = new TriggerKey(trigger.getTriggerId(), trigger.getGroup().getGroupId());
        SchedulerHelper.updateStatus(this, triggerKey, trigger.getStatus());
        return trigger;
    }

    public JobTriggerDto add(String triggerId) throws Exception {
        BeanConfigure.checkBeanConfigure(this);
        JobTriggerDto trigger = SchedulerHelper.getTrigger(this, triggerId);
        SchedulerHelper.SchedulerJob schedulerJob = SchedulerHelper.createSchedulerJob(this, trigger.getGroup(), trigger);
        this.scheduler.deleteJob(schedulerJob.getJobDetail().getKey());
        this.scheduler.scheduleJob(schedulerJob.getJobDetail(), schedulerJob.getJobTrigger());
        if (FrameworkUtil.isTrue(trigger.getIsRunOnStartup())) {
            this.scheduler.triggerJob(schedulerJob.getJobDetail().getKey(), schedulerJob.getJobDetail().getJobDataMap());
        }
        TriggerKey triggerKey = new TriggerKey(trigger.getTriggerId(), trigger.getGroup().getGroupId());
        SchedulerHelper.updateStatus(this, triggerKey, trigger.getStatus());
        return trigger;
    }

    public Map<String, TriggerStatus> status(Collection<String> triggerIds) {
        BeanConfigure.checkBeanConfigure(this);
        HashMap<String, TriggerStatus> statuses = new HashMap<String, TriggerStatus>();
        if (triggerIds != null && !triggerIds.isEmpty()) {
            LinkedHashSet<String> ids = new LinkedHashSet<String>(triggerIds);
            Map map = this.jobService.getTriggerMap(triggerIds);
            for (String id : ids) {
                TriggerStatus status = new TriggerStatus();
                status.setScheduled(Boolean.valueOf(false));
                JobTriggerDto trigger = (JobTriggerDto)map.get(id);
                if (trigger != null) {
                    TriggerKey key = new TriggerKey(trigger.getTriggerId(), trigger.getGroup().getGroupId());
                    SchedulerHelper.updateStatus(this, key, status);
                }
                statuses.put(id, status);
            }
        }
        return statuses;
    }
}

