/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.job;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.job.JobEntityClass;
import net.ideahut.springboot.job.SchedulerHandlerImpl;
import net.ideahut.springboot.job.dto.JobGroupDto;
import net.ideahut.springboot.job.dto.JobInstanceDto;
import net.ideahut.springboot.job.dto.JobTriggerConfigDto;
import net.ideahut.springboot.job.dto.JobTriggerDto;
import net.ideahut.springboot.job.dto.JobTypeDto;
import net.ideahut.springboot.job.dto.JobTypeParamDto;
import net.ideahut.springboot.job.dto.TriggerStatus;
import net.ideahut.springboot.support.CompareDtoAndEnt;
import net.ideahut.springboot.task.TaskListExecutor;
import net.ideahut.springboot.util.FrameworkUtil;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

final class SchedulerHelper {
    private static final Logger log = LoggerFactory.getLogger(SchedulerHelper.class);

    private SchedulerHelper() {
    }

    private static void compareCheck(Class<?> dtoClass, TrxManagerInfo trxManagerInfo, Class<?> entClass) {
        Assert.notNull((Object)trxManagerInfo.getEntityInfo(entClass), (String)("Entity class '" + entClass.getName() + "' is not found in TrxManager: " + trxManagerInfo.getName()));
        CompareDtoAndEnt.check(dtoClass, entClass);
    }

    static void fixEntityClass(EntityTrxManager entityTrxManager, JobEntityClass entityClass) {
        Assert.notNull((Object)entityClass, (String)"entityClass is required");
        Assert.notNull((Object)entityClass.getGroup(), (String)"entityClass.group is required");
        Assert.notNull((Object)entityClass.getInstance(), (String)"entityClass.instance is required");
        Assert.notNull((Object)entityClass.getTrigger(), (String)"entityClass.trigger is required");
        Assert.notNull((Object)entityClass.getTriggerConfig(), (String)"entityClass.triggerConfig is required");
        Assert.notNull((Object)entityClass.getType(), (String)"entityClass.type is required");
        Assert.notNull((Object)entityClass.getTypeParam(), (String)"entityClass.typeParam is required");
        String trxManagerName = entityClass.getTrxManagerName();
        trxManagerName = trxManagerName != null ? trxManagerName.trim() : "";
        entityClass.setTrxManagerName(trxManagerName);
        TrxManagerInfo trxManagerInfo = FrameworkUtil.getTrxManagerInfo(entityTrxManager, trxManagerName);
        Assert.notNull((Object)trxManagerInfo, (String)("TrxManagerInfo is not found, for: " + trxManagerName));
        SchedulerHelper.compareCheck(JobGroupDto.class, trxManagerInfo, entityClass.getGroup());
        SchedulerHelper.compareCheck(JobInstanceDto.class, trxManagerInfo, entityClass.getInstance());
        SchedulerHelper.compareCheck(JobTriggerDto.class, trxManagerInfo, entityClass.getTrigger());
        SchedulerHelper.compareCheck(JobTriggerConfigDto.class, trxManagerInfo, entityClass.getTriggerConfig());
        SchedulerHelper.compareCheck(JobTypeDto.class, trxManagerInfo, entityClass.getType());
        SchedulerHelper.compareCheck(JobTypeParamDto.class, trxManagerInfo, entityClass.getTypeParam());
    }

    private static <T extends Job> Class<T> getJobClass(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static <T extends Job> Class<T> getJobClass(Set<String> jobPackages, String classname) {
        Class<T> jobClass;
        block1: {
            String jobPackage;
            jobClass = SchedulerHelper.getJobClass(classname);
            if (jobClass != null || jobPackages == null) break block1;
            Iterator<String> iterator = jobPackages.iterator();
            while (iterator.hasNext() && (jobClass = SchedulerHelper.getJobClass((jobPackage = iterator.next()) + "." + classname)) == null) {
            }
        }
        return jobClass;
    }

    static void start(final SchedulerHandlerImpl handler) throws Exception {
        List groups = handler.jobService.getGroupsWithTriggers(handler.instanceId, Boolean.TRUE, null, Boolean.valueOf(true));
        ArrayList<SchedulerJob> candidates = new ArrayList<SchedulerJob>();
        ArrayList<JobDetail> startups = new ArrayList<JobDetail>();
        while (!groups.isEmpty()) {
            JobGroupDto group = (JobGroupDto)groups.remove(0);
            for (JobTriggerDto trigger : group.getTriggers()) {
                SchedulerJob schedulerJob = SchedulerHelper.createSchedulerJob(handler, group, trigger);
                candidates.add(schedulerJob);
                if (!FrameworkUtil.isTrue(trigger.getIsRunOnStartup())) continue;
                startups.add(schedulerJob.getJobDetail());
            }
        }
        handler.scheduler.clear();
        while (!candidates.isEmpty()) {
            SchedulerJob scJob = (SchedulerJob)candidates.remove(0);
            handler.scheduler.deleteJob(scJob.getJobDetail().getKey());
            handler.scheduler.scheduleJob(scJob.getJobDetail(), scJob.getJobTrigger());
        }
        handler.scheduler.start();
        if (!startups.isEmpty()) {
            TaskListExecutor executor = TaskListExecutor.of((Integer)(startups.size() > 3 ? 3 : startups.size()));
            while (!startups.isEmpty()) {
                final JobDetail jobDetail = (JobDetail)startups.remove(0);
                executor.add((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        handler.scheduler.triggerJob(jobDetail.getKey(), jobDetail.getJobDataMap());
                        return null;
                    }
                });
            }
            try {
                executor.concurrent(null);
            }
            catch (Exception e) {
                log.error("Scheduler-Startups", (Throwable)e);
            }
        }
    }

    static SchedulerJob createSchedulerJob(SchedulerHandlerImpl handler, JobGroupDto group, JobTriggerDto trigger) throws Exception {
        String cronExpression = trigger.getCronExpression();
        if (!CronExpression.isValidExpression((String)cronExpression)) {
            throw new Exception("Invalid cron expression: " + cronExpression);
        }
        JobTypeDto type = trigger.getType();
        Class jobClass = SchedulerHelper.getJobClass(handler.jobPackages, type.getClassname());
        CronScheduleBuilder schedule = CronScheduleBuilder.cronSchedule((String)cronExpression);
        ZoneOffset zoneOffset = null;
        if (trigger.getZoneOffsetSeconds() != null) {
            zoneOffset = ZoneOffset.ofTotalSeconds(trigger.getZoneOffsetSeconds());
        } else if (group.getZoneOffsetSeconds() != null) {
            zoneOffset = ZoneOffset.ofTotalSeconds(group.getZoneOffsetSeconds());
        }
        TimeZone timeZone = zoneOffset != null ? TimeZone.getTimeZone(zoneOffset) : TimeZone.getDefault();
        schedule.inTimeZone(timeZone);
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(trigger.getTriggerId(), group.getGroupId()).withSchedule((ScheduleBuilder)schedule);
        CronTrigger cronTrigger = (CronTrigger)triggerBuilder.build();
        JobBuilder jobBuilder = JobBuilder.newJob(jobClass).withIdentity(trigger.getTriggerId(), group.getGroupId());
        JobDetail jobDetail = jobBuilder.build();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("$TRIGGER", (Object)trigger);
        jobDataMap.put("$CONTEXT", (Object)handler.applicationContext);
        jobDataMap.put("$SERVICE", (Object)handler.jobService);
        jobDataMap.put("$MAPPER", (Object)handler.dataMapper);
        return new SchedulerJob(jobDetail, (Trigger)cronTrigger);
    }

    static void checkScheduler(SchedulerHandlerImpl handler) throws Exception {
        if (handler.scheduler == null || !handler.scheduler.isStarted()) {
            throw new Exception("Scheduler is not available");
        }
    }

    static JobTriggerDto getTrigger(SchedulerHandlerImpl handler, String triggerId) throws Exception {
        SchedulerHelper.checkScheduler(handler);
        JobTriggerDto trigger = handler.jobService.getTrigger(triggerId, Boolean.valueOf(false));
        Assert.notNull((Object)trigger, (String)"Trigger is not found");
        trigger.setStatus(new TriggerStatus());
        return trigger;
    }

    static TriggerKey getTriggerKey(SchedulerHandlerImpl handler, JobTriggerDto trigger) throws Exception {
        TriggerKey triggerKey = new TriggerKey(trigger.getTriggerId(), trigger.getGroup().getGroupId());
        Assert.isTrue((boolean)handler.scheduler.checkExists(triggerKey), (String)"TriggerKey is not available");
        return triggerKey;
    }

    static void updateStatus(SchedulerHandlerImpl handler, TriggerKey key, TriggerStatus status) {
        if (handler.scheduler != null) {
            try {
                status.setScheduled(Boolean.valueOf(handler.scheduler.checkExists(key)));
                if (Boolean.TRUE.equals(status.getScheduled())) {
                    Trigger.TriggerState state = handler.scheduler.getTriggerState(key);
                    status.setState(state != null ? state.name() : null);
                    Trigger trigger = handler.scheduler.getTrigger(key);
                    status.setEndTime(trigger.getEndTime() != null ? Long.valueOf(trigger.getEndTime().getTime()) : null);
                    status.setFinalFireTime(trigger.getFinalFireTime() != null ? Long.valueOf(trigger.getFinalFireTime().getTime()) : null);
                    status.setMayFireAgain(Boolean.valueOf(trigger.mayFireAgain()));
                    status.setNextFireTime(trigger.getNextFireTime() != null ? Long.valueOf(trigger.getNextFireTime().getTime()) : null);
                    status.setPreviousFireTime(trigger.getPreviousFireTime() != null ? Long.valueOf(trigger.getPreviousFireTime().getTime()) : null);
                    status.setPriority(Integer.valueOf(trigger.getPriority()));
                    status.setStartTime(trigger.getStartTime() != null ? Long.valueOf(trigger.getStartTime().getTime()) : null);
                }
            }
            catch (Exception e) {
                throw FrameworkUtil.exception(e);
            }
        }
    }

    static class SchedulerJob {
        private final JobDetail jobDetail;
        private final Trigger jobTrigger;

        SchedulerJob(JobDetail jobDetail, Trigger jobTrigger) {
            this.jobDetail = jobDetail;
            this.jobTrigger = jobTrigger;
        }

        public JobDetail getJobDetail() {
            return this.jobDetail;
        }

        public Trigger getJobTrigger() {
            return this.jobTrigger;
        }
    }

    static final class TypeRef {
        static final TypeReference<List<String>> STRING_LIST = new TypeReference<List<String>>(){};

        private TypeRef() {
        }
    }
}

