/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.job.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.generator.UUIDGenerator;
import net.ideahut.springboot.job.entity.JobGroup;
import net.ideahut.springboot.job.entity.JobInstance;
import net.ideahut.springboot.job.entity.JobType;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@ApiExclude
@Audit
@Entity
@Table(name="job_trigger")
public class JobTrigger
extends EntityAudit {
    @Id
    @GeneratedValue(generator="UUIDGenerator")
    @GenericGenerator(name="UUIDGenerator", type=UUIDGenerator.class)
    @Column(name="trigger_id", unique=true, nullable=false, length=64)
    private String triggerId;
    @Column(name="group_id", nullable=false, length=64)
    private String groupId;
    @Column(name="type_id", nullable=false, length=64)
    private String typeId;
    @Column(name="instance_id", length=128)
    private String instanceId;
    @Column(name="name", nullable=false, length=128)
    private String name;
    @Column(name="description")
    private String description;
    @Column(name="cron_expression", nullable=false, length=128)
    private String cronExpression;
    @Column(name="zone_offset_seconds")
    private Integer zoneOffsetSeconds;
    @Column(name="is_run_on_startup", nullable=false, length=1)
    private Character isRunOnStartup;
    @Column(name="is_active", nullable=false, length=1)
    private Character isActive;
    @Column(name="is_save_result", nullable=false, length=1)
    private Character isSaveResult;
    @Column(name="last_run_time")
    private Long lastRunTime;
    @JdbcTypeCode(value=-1)
    @Column(name="last_run_data")
    private String lastRunData;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="group_id", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_job_trigger__group"))
    private JobGroup group;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="type_id", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_job_trigger__type"))
    private JobType type;
    @OnDelete(action=OnDeleteAction.SET_NULL)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="instance_id", insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_job_trigger__instance"))
    private JobInstance instance;

    public JobTrigger() {
    }

    public JobTrigger(String triggerId) {
        this.triggerId = triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setZoneOffsetSeconds(Integer zoneOffsetSeconds) {
        this.zoneOffsetSeconds = zoneOffsetSeconds;
    }

    public void setIsRunOnStartup(Character isRunOnStartup) {
        this.isRunOnStartup = isRunOnStartup;
    }

    public void setIsActive(Character isActive) {
        this.isActive = isActive;
    }

    public void setIsSaveResult(Character isSaveResult) {
        this.isSaveResult = isSaveResult;
    }

    public void setLastRunTime(Long lastRunTime) {
        this.lastRunTime = lastRunTime;
    }

    public void setLastRunData(String lastRunData) {
        this.lastRunData = lastRunData;
    }

    public void setGroup(JobGroup group) {
        this.group = group;
    }

    public void setType(JobType type) {
        this.type = type;
    }

    public void setInstance(JobInstance instance) {
        this.instance = instance;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public Integer getZoneOffsetSeconds() {
        return this.zoneOffsetSeconds;
    }

    public Character getIsRunOnStartup() {
        return this.isRunOnStartup;
    }

    public Character getIsActive() {
        return this.isActive;
    }

    public Character getIsSaveResult() {
        return this.isSaveResult;
    }

    public Long getLastRunTime() {
        return this.lastRunTime;
    }

    public String getLastRunData() {
        return this.lastRunData;
    }

    public JobGroup getGroup() {
        return this.group;
    }

    public JobType getType() {
        return this.type;
    }

    public JobInstance getInstance() {
        return this.instance;
    }
}

