/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.job.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.job.entity.JobTrigger;
import net.ideahut.springboot.job.entity.JobTypeParam;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@ApiExclude
@Audit
@Entity
@Table(name="job_trigger_config")
public class JobTriggerConfig
extends EntityAudit {
    @Id
    @Column(name="trigger_id", nullable=false, length=64)
    private String triggerId;
    @Id
    @Column(name="type_id", nullable=false, length=64)
    private String typeId;
    @Id
    @Column(name="name", nullable=false, length=128)
    private String name;
    @JdbcTypeCode(value=-1)
    @Column(name="value")
    private String value;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="trigger_id", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_job_trigger_config__trigger"))
    private JobTrigger trigger;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="type_id", referencedColumnName="type_id", nullable=false, insertable=false, updatable=false), @JoinColumn(name="name", referencedColumnName="name", nullable=false, insertable=false, updatable=false)}, foreignKey=@ForeignKey(name="fk_job_trigger_config__type_parameter"))
    private JobTypeParam typeParam;

    public JobTriggerConfig() {
    }

    public JobTriggerConfig(String triggerId, String typeId, String name) {
        this.triggerId = triggerId;
        this.typeId = typeId;
        this.name = name;
    }

    public JobTriggerConfig(String triggerId, JobTypeParam typeParam) {
        this(triggerId, typeParam.getTypeId(), typeParam.getName());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.triggerId, this.typeId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobTriggerConfig other = (JobTriggerConfig)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.triggerId, other.triggerId) && Objects.equals(this.typeId, other.typeId);
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setTrigger(JobTrigger trigger) {
        this.trigger = trigger;
    }

    public void setTypeParam(JobTypeParam typeParam) {
        this.typeParam = typeParam;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public JobTrigger getTrigger() {
        return this.trigger;
    }

    public JobTypeParam getTypeParam() {
        return this.typeParam;
    }
}

