/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.job.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.generator.UUIDGenerator;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.JdbcTypeCode;

@ApiExclude
@Audit
@Entity
@Table(name="job_type", uniqueConstraints={@UniqueConstraint(columnNames={"classname"}, name="uq_job_type__classname")})
public class JobType
extends EntityAudit {
    @Id
    @GeneratedValue(generator="UUIDGenerator")
    @GenericGenerator(name="UUIDGenerator", type=UUIDGenerator.class)
    @Column(name="type_id", unique=true, nullable=false, length=64)
    private String typeId;
    @Column(name="name", nullable=false, length=128)
    private String name;
    @Column(name="classname", nullable=false)
    private String classname;
    @Column(name="description")
    private String description;
    @Column(name="is_single_run")
    private Character isSingleRun;
    @Column(name="is_running")
    private Character isRunning;
    @Column(name="is_save_result", nullable=false, length=1)
    private Character isSaveResult;
    @Column(name="last_run_time")
    private Long lastRunTime;
    @JdbcTypeCode(value=-1)
    @Column(name="last_run_data")
    private String lastRunData;
    @Column(name="last_run_trigger_id")
    private String lastRunTriggerId;

    public JobType() {
    }

    public JobType(String typeId) {
        this.typeId = typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIsSingleRun(Character isSingleRun) {
        this.isSingleRun = isSingleRun;
    }

    public void setIsRunning(Character isRunning) {
        this.isRunning = isRunning;
    }

    public void setIsSaveResult(Character isSaveResult) {
        this.isSaveResult = isSaveResult;
    }

    public void setLastRunTime(Long lastRunTime) {
        this.lastRunTime = lastRunTime;
    }

    public void setLastRunData(String lastRunData) {
        this.lastRunData = lastRunData;
    }

    public void setLastRunTriggerId(String lastRunTriggerId) {
        this.lastRunTriggerId = lastRunTriggerId;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getName() {
        return this.name;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getDescription() {
        return this.description;
    }

    public Character getIsSingleRun() {
        return this.isSingleRun;
    }

    public Character getIsRunning() {
        return this.isRunning;
    }

    public Character getIsSaveResult() {
        return this.isSaveResult;
    }

    public Long getLastRunTime() {
        return this.lastRunTime;
    }

    public String getLastRunData() {
        return this.lastRunData;
    }

    public String getLastRunTriggerId() {
        return this.lastRunTriggerId;
    }
}

