/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.job.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Audit;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.job.entity.JobType;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@ApiExclude
@Audit
@Entity
@Table(name="job_type_param")
public class JobTypeParam
extends EntityAudit {
    @Id
    @Column(name="type_id", nullable=false, length=64)
    private String typeId;
    @Id
    @Column(name="name", nullable=false, length=128)
    private String name;
    @Column(name="description")
    private String description;
    @OnDelete(action=OnDeleteAction.CASCADE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="type_id", nullable=false, insertable=false, updatable=false, foreignKey=@ForeignKey(name="fk_job_type_param__type"))
    private JobType type;

    public JobTypeParam() {
    }

    public JobTypeParam(String typeId, String name) {
        this.typeId = typeId;
        this.name = name;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.typeId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobTypeParam other = (JobTypeParam)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.typeId, other.typeId);
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(JobType type) {
        this.type = type;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public JobType getType() {
        return this.type;
    }
}

