/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.message;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import net.ideahut.springboot.exception.ResultRuntimeException;
import net.ideahut.springboot.message.AssertHandler;
import net.ideahut.springboot.message.AssertHelper;
import net.ideahut.springboot.message.MessageHandler;
import net.ideahut.springboot.object.Result;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AssertHandlerImpl
implements AssertHandler,
InitializingBean {
    private MessageHandler messageHandler;

    public AssertHandlerImpl setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.messageHandler, (String)"messageHandler is required");
    }

    public RuntimeException throwResult(Result result) {
        throw new ResultRuntimeException(result);
    }

    public RuntimeException throwError(String errorCode, AssertHandler.AssertMessage message) {
        throw new ResultRuntimeException(AssertHelper.getError(this.messageHandler, errorCode, message));
    }

    public RuntimeException throwError(AssertHandler.AssertMessage message) {
        throw new ResultRuntimeException(AssertHelper.getError(this.messageHandler, null, message));
    }

    public RuntimeException throwError(Throwable throwable) {
        throw new RuntimeException(throwable);
    }

    public void notNull(Object value, String errorCode, AssertHandler.AssertMessage message) {
        if (value == null) {
            throw this.throwError(errorCode, message);
        }
    }

    public void notNull(Object value, AssertHandler.AssertMessage message) {
        this.notNull(value, null, message);
    }

    public void notNull(Object value, Result result) {
        if (value == null) {
            throw this.throwResult(result);
        }
    }

    public void notEmpty(Object value, String errorCode, AssertHandler.AssertMessage message) {
        this.notEmpty(value, AssertHelper.getError(this.messageHandler, errorCode, message));
    }

    public void notEmpty(Object value, AssertHandler.AssertMessage message) {
        this.notEmpty(value, null, message);
    }

    public void notEmpty(Object value, Result result) {
        int length;
        if (value == null) {
            throw this.throwResult(result);
        }
        Class<?> type = value.getClass();
        if (Collection.class.isAssignableFrom(type) ? ((Collection)value).isEmpty() : (String.class.isAssignableFrom(type) ? ((String)value).isEmpty() : value.getClass().isArray() && (length = Array.getLength(value)) == 0)) {
            throw this.throwResult(result);
        }
    }

    public void notEqual(Object value1, Object value2, String errorCode, AssertHandler.AssertMessage message) {
        this.notEqual(value1, value2, AssertHelper.getError(this.messageHandler, errorCode, message));
    }

    public void notEqual(Object value1, Object value2, AssertHandler.AssertMessage message) {
        this.notEqual(value1, value2, null, message);
    }

    public void notEqual(Object value1, Object value2, Result result) {
        if (value1 == null && value2 == null) {
            return;
        }
        if (value1 != null && value2 == null || value1 == null) {
            throw this.throwResult(result);
        }
        Class<?>[] types = AssertHelper.getTypes(value1, value2);
        if (types[0].isPrimitive()) {
            AssertHelper.Primitive.notEqual(value1, value2, result);
        } else if (!value1.equals(value2)) {
            throw this.throwResult(result);
        }
    }

    public void notLessThan(Object value1, Object value2, String errorCode, AssertHandler.AssertMessage message) {
        this.notLessThan(value1, value2, AssertHelper.getError(this.messageHandler, errorCode, message));
    }

    public void notLessThan(Object value1, Object value2, AssertHandler.AssertMessage message) {
        this.notLessThan(value1, value2, null, message);
    }

    public void notLessThan(Object value1, Object value2, Result result) {
        Comparable c1;
        if (AssertHelper.isNull(Arrays.asList(value1, value2))) {
            throw this.throwResult(result);
        }
        Class<?>[] types = AssertHelper.getTypes(value1, value2);
        if (types[0].isPrimitive()) {
            AssertHelper.Primitive.notLessThan(value1, value2, result);
        } else if (Comparable.class.isAssignableFrom(types[0]) && (c1 = (Comparable)value1).compareTo(value2) > -1) {
            throw this.throwResult(result);
        }
    }

    public void notLessOrEqualThan(Object value1, Object value2, String errorCode, AssertHandler.AssertMessage message) {
        this.notLessOrEqualThan(value1, value2, AssertHelper.getError(this.messageHandler, errorCode, message));
    }

    public void notLessOrEqualThan(Object value1, Object value2, AssertHandler.AssertMessage message) {
        this.notLessOrEqualThan(value1, value2, null, message);
    }

    public void notLessOrEqualThan(Object value1, Object value2, Result result) {
        Comparable c1;
        if (AssertHelper.isNull(Arrays.asList(value1, value2))) {
            throw this.throwResult(result);
        }
        Class<?>[] types = AssertHelper.getTypes(value1, value2);
        if (types[0].isPrimitive()) {
            AssertHelper.Primitive.notLessOrEqualThan(value1, value2, result);
        } else if (Comparable.class.isAssignableFrom(types[0]) && (c1 = (Comparable)value1).compareTo(value2) > 0) {
            throw this.throwResult(result);
        }
    }

    public void notGreaterThan(Object value1, Object value2, String errorCode, AssertHandler.AssertMessage message) {
        this.notGreaterThan(value1, value2, AssertHelper.getError(this.messageHandler, errorCode, message));
    }

    public void notGreaterThan(Object value1, Object value2, AssertHandler.AssertMessage message) {
        this.notGreaterThan(value1, value2, null, message);
    }

    public void notGreaterThan(Object value1, Object value2, Result result) {
        Comparable c1;
        if (AssertHelper.isNull(Arrays.asList(value1, value2))) {
            throw this.throwResult(result);
        }
        Class<?>[] types = AssertHelper.getTypes(value1, value2);
        if (types[0].isPrimitive()) {
            AssertHelper.Primitive.notGreaterThan(value1, value2, result);
        } else if (Comparable.class.isAssignableFrom(types[0]) && (c1 = (Comparable)value1).compareTo(value2) < 1) {
            throw this.throwResult(result);
        }
    }

    public void notGreaterOrEqualThan(Object value1, Object value2, String errorCode, AssertHandler.AssertMessage message) {
        this.notGreaterOrEqualThan(value1, value2, AssertHelper.getError(this.messageHandler, errorCode, message));
    }

    public void notGreaterOrEqualThan(Object value1, Object value2, AssertHandler.AssertMessage message) {
        this.notGreaterOrEqualThan(value1, value2, null, message);
    }

    public void notGreaterOrEqualThan(Object value1, Object value2, Result result) {
        Comparable c1;
        if (AssertHelper.isNull(Arrays.asList(value1, value2))) {
            throw this.throwResult(result);
        }
        Class<?>[] types = AssertHelper.getTypes(value1, value2);
        if (types[0].isPrimitive()) {
            AssertHelper.Primitive.notGreaterOrEqualThan(value1, value2, result);
        } else if (Comparable.class.isAssignableFrom(types[0]) && (c1 = (Comparable)value1).compareTo(value2) < 0) {
            throw this.throwResult(result);
        }
    }

    public void notTrue(Boolean value, String errorCode, AssertHandler.AssertMessage message) {
        this.notTrue(value, AssertHelper.getError(this.messageHandler, errorCode, message));
    }

    public void notTrue(Boolean value, AssertHandler.AssertMessage message) {
        this.notTrue(value, null, message);
    }

    public void notTrue(Boolean value, Result result) {
        if (!Boolean.TRUE.equals(value)) {
            throw this.throwResult(result);
        }
    }
}

