/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.message;

import net.ideahut.springboot.exception.ResultRuntimeException;
import net.ideahut.springboot.message.AssertHandler;
import net.ideahut.springboot.message.MessageHandler;
import net.ideahut.springboot.object.Result;

final class AssertHelper {
    private AssertHelper() {
    }

    static Class<?>[] getTypes(Object value1, Object value2) {
        Class<?> type2;
        Class<?> type1 = value1.getClass();
        if (!type1.equals(type2 = value2.getClass())) {
            throw new RuntimeException("Invalid value type");
        }
        return new Class[]{type1, type2};
    }

    static boolean isNull(Object ... values) {
        if (values == null || values.length == 0) {
            return true;
        }
        for (Object value : values) {
            if (value != null) continue;
            return true;
        }
        return false;
    }

    static Result getError(MessageHandler messageHandler, String errorCode, AssertHandler.AssertMessage message) {
        String code = errorCode != null ? errorCode : "";
        String text = null;
        if (message != null && message.getCode() != null) {
            if (code.isEmpty()) {
                code = message.getCode();
            }
            text = messageHandler.getText(message.getCode(), message.getArguments());
        }
        return Result.error((String)(!code.isEmpty() ? code : "UNKNOWN"), text);
    }

    static class Primitive {
        private Primitive() {
        }

        static void notEqual(Object value1, Object value2, Result result) {
            Double d2;
            Double d1;
            Float f2;
            Float f1;
            Class<?> type = value1.getClass();
            if (Integer.TYPE.isAssignableFrom(type) ? ((Integer)value1).intValue() != ((Integer)value2).intValue() : (Float.TYPE.isAssignableFrom(type) ? (f1 = Float.valueOf(((Float)value1).floatValue())).compareTo(f2 = Float.valueOf(((Float)value2).floatValue())) != 0 : Double.TYPE.isAssignableFrom(type) && (d1 = Double.valueOf((Double)value1)).compareTo(d2 = Double.valueOf((Double)value2)) != 0)) {
                throw new ResultRuntimeException(result);
            }
        }

        static void notLessThan(Object value1, Object value2, Result result) {
            Double d2;
            Double d1;
            Float f2;
            Float f1;
            Class<?> type = value1.getClass();
            if (Integer.TYPE.isAssignableFrom(type) ? (Integer)value1 >= (Integer)value2 : (Float.TYPE.isAssignableFrom(type) ? (f1 = Float.valueOf(((Float)value1).floatValue())).compareTo(f2 = Float.valueOf(((Float)value2).floatValue())) > -1 : Double.TYPE.isAssignableFrom(type) && (d1 = Double.valueOf((Double)value1)).compareTo(d2 = Double.valueOf((Double)value2)) > -1)) {
                throw new ResultRuntimeException(result);
            }
        }

        static void notLessOrEqualThan(Object value1, Object value2, Result result) {
            Double d2;
            Double d1;
            Float f2;
            Float f1;
            Class<?> type = value1.getClass();
            if (Integer.TYPE.isAssignableFrom(type) ? (Integer)value1 > (Integer)value2 : (Float.TYPE.isAssignableFrom(type) ? (f1 = Float.valueOf(((Float)value1).floatValue())).compareTo(f2 = Float.valueOf(((Float)value2).floatValue())) > 0 : Double.TYPE.isAssignableFrom(type) && (d1 = Double.valueOf((Double)value1)).compareTo(d2 = Double.valueOf((Double)value2)) > 0)) {
                throw new ResultRuntimeException(result);
            }
        }

        static void notGreaterThan(Object value1, Object value2, Result result) {
            Double d2;
            Double d1;
            Float f2;
            Float f1;
            Class<?> type = value1.getClass();
            if (Integer.TYPE.isAssignableFrom(type) ? (Integer)value1 <= (Integer)value2 : (Float.TYPE.isAssignableFrom(type) ? (f1 = Float.valueOf(((Float)value1).floatValue())).compareTo(f2 = Float.valueOf(((Float)value2).floatValue())) < 1 : Double.TYPE.isAssignableFrom(type) && (d1 = Double.valueOf((Double)value1)).compareTo(d2 = Double.valueOf((Double)value2)) < 1)) {
                throw new ResultRuntimeException(result);
            }
        }

        static void notGreaterOrEqualThan(Object value1, Object value2, Result result) {
            Double d2;
            Double d1;
            Float f2;
            Float f1;
            Class<?> type = value1.getClass();
            if (Integer.TYPE.isAssignableFrom(type) ? (Integer)value1 < (Integer)value2 : (Float.TYPE.isAssignableFrom(type) ? (f1 = Float.valueOf(((Float)value1).floatValue())).compareTo(f2 = Float.valueOf(((Float)value2).floatValue())) < 0 : Double.TYPE.isAssignableFrom(type) && (d1 = Double.valueOf((Double)value1)).compareTo(d2 = Double.valueOf((Double)value2)) < 0)) {
                throw new ResultRuntimeException(result);
            }
        }
    }
}

