/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.message;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.message.MessageHandler;
import net.ideahut.springboot.object.Message;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.LocaleResolver;

public class ResourceBundleMessageHandler
implements MessageHandler,
InitializingBean {
    private MessageSource messageSource;
    private LocaleResolver localeResolver;
    private List<Locale> supportedLocales;
    private Locale defaultLocale;

    public ResourceBundleMessageHandler setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
        return this;
    }

    public ResourceBundleMessageHandler setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.localeResolver != null) {
            Class<?> resolverClass = this.localeResolver.getClass();
            try {
                this.supportedLocales = (List)resolverClass.getMethod("getSupportedLocales", new Class[0]).invoke((Object)this.localeResolver, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.defaultLocale = (Locale)resolverClass.getMethod("getDefaultLocale", new Class[0]).invoke((Object)this.localeResolver, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.defaultLocale == null) {
            this.defaultLocale = Locale.getDefault();
        }
        if (this.supportedLocales == null) {
            this.supportedLocales = new ArrayList<Locale>();
            this.supportedLocales.add(this.defaultLocale);
        }
    }

    private Locale getLocale() {
        RequestContext context = RequestContext.currentContext();
        Locale locale = (Locale)context.getAttribute(MessageHandler.Attribute.LOCALE);
        if (locale != null) {
            return locale;
        }
        String language = ((String)context.getAttribute(MessageHandler.Attribute.LANGUAGE, (Object)"")).trim();
        if (!language.isEmpty()) {
            try {
                locale = Locale.lookup(Locale.LanguageRange.parse(language), this.supportedLocales);
            }
            catch (Exception e) {
                locale = null;
            }
        }
        if (locale == null) {
            locale = this.defaultLocale;
        }
        context.setAttribute(MessageHandler.Attribute.LOCALE, (Object)locale);
        return locale;
    }

    private String getText(Locale locale, String code, boolean checkArgs, String ... args) {
        if (!checkArgs) {
            return this.messageSource.getMessage(code, (Object[])args, locale);
        }
        if (args != null) {
            Object[] newArgs = new String[args.length];
            for (int i = 0; i < newArgs.length; ++i) {
                newArgs[i] = this.messageSource.getMessage(args[i], null, locale);
            }
            return this.messageSource.getMessage(code, newArgs, locale);
        }
        return this.messageSource.getMessage(code, null, locale);
    }

    public String getText(String code, boolean checkArgs, String ... args) {
        Locale locale = this.getLocale();
        return this.getText(locale, code, checkArgs, args);
    }

    public String getText(String code, String ... args) {
        return this.getText(code, false, args);
    }

    public String getText(String code) {
        return this.getText(code, false, new String[0]);
    }

    public Message getMessage(String code, boolean checkArgs, String ... args) {
        String text = this.getText(code, checkArgs, args);
        return new Message(code, text);
    }

    public Message getMessage(String code, String ... args) {
        return this.getMessage(code, false, args);
    }

    public Message getMessage(String code) {
        return this.getMessage(code, false, new String[0]);
    }

    public Map<String, String> getMap(String ... codes) {
        Locale locale = this.getLocale();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (codes != null && codes.length != 0) {
            for (String code : codes) {
                map.put(code, this.getText(locale, code, false, new String[0]));
            }
        }
        return map;
    }

    public List<String> getList(String ... codes) {
        Locale locale = this.getLocale();
        ArrayList<String> list = new ArrayList<String>();
        if (codes != null && codes.length != 0) {
            for (String code : codes) {
                list.add(this.getText(locale, code, false, new String[0]));
            }
        }
        return list;
    }
}

