/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.redis;

import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import net.ideahut.springboot.redis.DepreHelper;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisProperties {
    private Integer type;
    private Standalone standalone;
    private Cluster cluster;
    private Sentinel sentinel;
    private Boolean enablePool;
    private Pool pool;
    private Boolean enableClient;
    private Client client;
    private Boolean testOnStartup;

    public RedisConnectionFactory createConnectionFactory() throws Exception {
        return this.createConnectionFactory(false);
    }

    public RedisConnectionFactory createConnectionFactory(boolean initialize) throws Exception {
        Integer rtype = 1;
        if (this.type != null) {
            rtype = this.type;
        }
        boolean isEnableClient = false;
        if (this.enableClient != null) {
            if (Boolean.TRUE.equals(this.enableClient)) {
                if (this.client == null) {
                    throw new Exception("redis.client is required");
                }
                isEnableClient = true;
            }
        } else {
            isEnableClient = this.client != null;
        }
        JedisClientConfiguration clientConfig = null;
        if (isEnableClient) {
            clientConfig = this.client.createConfig();
        }
        JedisConnectionFactory connectionFactory = null;
        switch (rtype) {
            case 1: {
                if (this.standalone == null) {
                    throw new Exception("redis.standalone is required");
                }
                RedisStandaloneConfiguration standaloneConfiguration = this.standalone.createConfig();
                if (isEnableClient) {
                    connectionFactory = new JedisConnectionFactory(standaloneConfiguration, clientConfig);
                    break;
                }
                connectionFactory = new JedisConnectionFactory(standaloneConfiguration);
                break;
            }
            case 2: {
                if (this.cluster == null) {
                    throw new Exception("redis.cluster is required");
                }
                RedisClusterConfiguration clusterConfiguration = this.cluster.createConfig();
                if (isEnableClient) {
                    connectionFactory = new JedisConnectionFactory(clusterConfiguration, clientConfig);
                    break;
                }
                connectionFactory = new JedisConnectionFactory(clusterConfiguration);
                break;
            }
            case 3: {
                if (this.sentinel == null) {
                    throw new Exception("redis.sentinel is required");
                }
                RedisSentinelConfiguration sentinelConfiguration = this.sentinel.createConfig();
                if (isEnableClient) {
                    connectionFactory = new JedisConnectionFactory(sentinelConfiguration, clientConfig);
                    break;
                }
                connectionFactory = new JedisConnectionFactory(sentinelConfiguration);
                break;
            }
            default: {
                throw new Exception("Unsupported redis.type: " + rtype);
            }
        }
        boolean isEnablePool = false;
        if (this.enablePool != null) {
            if (Boolean.TRUE.equals(this.enablePool)) {
                if (this.pool == null) {
                    throw new Exception("redis.pool is required");
                }
                isEnablePool = true;
            }
        } else {
            boolean bl = isEnablePool = this.pool != null;
        }
        if (isEnablePool) {
            this.pool.updatePoolConfig(connectionFactory.getPoolConfig());
        }
        if (initialize && connectionFactory instanceof InitializingBean) {
            connectionFactory.afterPropertiesSet();
        }
        return connectionFactory;
    }

    public <K, V> RedisTemplate<K, V> createRedisTemplate(RedisConnectionFactory connectionFactory, boolean initialize) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(connectionFactory);
        if (initialize) {
            template.afterPropertiesSet();
        }
        return template;
    }

    public <K, V> RedisTemplate<K, V> createRedisTemplate(RedisConnectionFactory connectionFactory) {
        return this.createRedisTemplate(connectionFactory, false);
    }

    public <K, V> RedisTemplate<K, V> createRedisTemplate(boolean initialize) throws Exception {
        RedisConnectionFactory connectionFactory = this.createConnectionFactory(initialize);
        return this.createRedisTemplate(connectionFactory, initialize);
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setStandalone(Standalone standalone) {
        this.standalone = standalone;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public void setSentinel(Sentinel sentinel) {
        this.sentinel = sentinel;
    }

    public void setEnablePool(Boolean enablePool) {
        this.enablePool = enablePool;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public void setEnableClient(Boolean enableClient) {
        this.enableClient = enableClient;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setTestOnStartup(Boolean testOnStartup) {
        this.testOnStartup = testOnStartup;
    }

    public Integer getType() {
        return this.type;
    }

    public Standalone getStandalone() {
        return this.standalone;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public Sentinel getSentinel() {
        return this.sentinel;
    }

    public Boolean getEnablePool() {
        return this.enablePool;
    }

    public Pool getPool() {
        return this.pool;
    }

    public Boolean getEnableClient() {
        return this.enableClient;
    }

    public Client getClient() {
        return this.client;
    }

    public Boolean getTestOnStartup() {
        return this.testOnStartup;
    }

    public static final class Type {
        public static final int STANDALONE = 1;
        public static final int CLUSTER = 2;
        public static final int SENTINEL = 3;

        private Type() {
        }
    }

    public static class Client {
        private String clientName;
        private Integer connectTimeout;
        private Integer readTimeout;
        private Boolean usePooling;
        private Boolean useSsl;

        public JedisClientConfiguration createConfig() {
            JedisClientConfiguration.JedisClientConfigurationBuilder builder = JedisClientConfiguration.builder();
            if (this.clientName != null && !this.clientName.isEmpty()) {
                builder.clientName(this.clientName);
            }
            if (this.connectTimeout != null && this.connectTimeout > 0) {
                builder.connectTimeout(Duration.ofMillis(this.connectTimeout.intValue()));
            }
            if (this.readTimeout != null && this.readTimeout > 0) {
                builder.readTimeout(Duration.ofMillis(this.readTimeout.intValue()));
            }
            if (Boolean.TRUE.equals(this.usePooling)) {
                builder.usePooling();
            }
            if (Boolean.TRUE.equals(this.useSsl)) {
                builder.useSsl();
            }
            return builder.build();
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public void setConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public void setReadTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
        }

        public void setUsePooling(Boolean usePooling) {
            this.usePooling = usePooling;
        }

        public void setUseSsl(Boolean useSsl) {
            this.useSsl = useSsl;
        }

        public String getClientName() {
            return this.clientName;
        }

        public Integer getConnectTimeout() {
            return this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return this.readTimeout;
        }

        public Boolean getUsePooling() {
            return this.usePooling;
        }

        public Boolean getUseSsl() {
            return this.useSsl;
        }
    }

    public static class Standalone {
        private String host;
        private Integer port;
        private Integer database;
        private String password;

        public RedisStandaloneConfiguration createConfig() throws Exception {
            String rhost;
            String string = rhost = this.host != null ? this.host.trim() : "";
            if (rhost.isEmpty()) {
                throw new Exception("redis.standalone.host is required");
            }
            Integer rport = this.port;
            if (rport == null || rport <= 0) {
                throw new Exception("redis.standalone.port is required or invalid value");
            }
            RedisStandaloneConfiguration configuration = new RedisStandaloneConfiguration();
            configuration.setHostName(rhost);
            configuration.setPort(rport.intValue());
            if (this.database != null) {
                configuration.setDatabase(this.database.intValue());
            }
            if (this.password != null && !this.password.isEmpty()) {
                configuration.setPassword(RedisPassword.of((String)this.password));
            }
            return configuration;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public void setDatabase(Integer database) {
            this.database = database;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }

        public Integer getDatabase() {
            return this.database;
        }

        public String getPassword() {
            return this.password;
        }
    }

    public static class Cluster {
        private List<String> nodes;
        private Integer maxRedirects;
        private String password;

        public RedisClusterConfiguration createConfig() throws Exception {
            if (this.nodes == null || this.nodes.isEmpty()) {
                throw new Exception("redis.cluster.nodes is required");
            }
            HashSet<RedisNode> rnodes = new HashSet<RedisNode>();
            for (String node : this.nodes) {
                if ((node = node.trim()).isEmpty()) continue;
                String[] split = node.split(":");
                rnodes.add(new RedisNode(split[0].trim(), Integer.valueOf(split[1].trim()).intValue()));
            }
            RedisClusterConfiguration configuration = new RedisClusterConfiguration();
            configuration.setClusterNodes(rnodes);
            if (this.maxRedirects != null && this.maxRedirects > 0) {
                configuration.setMaxRedirects(this.maxRedirects.intValue());
            }
            if (this.password != null && !this.password.isEmpty()) {
                configuration.setPassword(RedisPassword.of((String)this.password));
            }
            return configuration;
        }

        public void setNodes(List<String> nodes) {
            this.nodes = nodes;
        }

        public void setMaxRedirects(Integer maxRedirects) {
            this.maxRedirects = maxRedirects;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public List<String> getNodes() {
            return this.nodes;
        }

        public Integer getMaxRedirects() {
            return this.maxRedirects;
        }

        public String getPassword() {
            return this.password;
        }
    }

    public static class Sentinel {
        private List<String> nodes;
        private String master;
        private Integer database;
        private String password;

        public RedisSentinelConfiguration createConfig() throws Exception {
            if (this.nodes == null || this.nodes.isEmpty()) {
                throw new Exception("redis.sentinel.nodes is required");
            }
            HashSet<RedisNode> rnodes = new HashSet<RedisNode>();
            for (String node : this.nodes) {
                if ((node = node.trim()).isEmpty()) continue;
                String[] split = node.split(":");
                rnodes.add(new RedisNode(split[0].trim(), Integer.valueOf(split[1].trim()).intValue()));
            }
            RedisSentinelConfiguration configuration = new RedisSentinelConfiguration();
            configuration.setSentinels(rnodes);
            if (this.database != null) {
                configuration.setDatabase(this.database.intValue());
            }
            if (this.password != null && !this.password.isEmpty()) {
                configuration.setPassword(RedisPassword.of((String)this.password));
            }
            if (this.master != null && !this.master.isEmpty()) {
                configuration.setMaster(this.master);
            }
            return configuration;
        }

        public void setNodes(List<String> nodes) {
            this.nodes = nodes;
        }

        public void setMaster(String master) {
            this.master = master;
        }

        public void setDatabase(Integer database) {
            this.database = database;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public List<String> getNodes() {
            return this.nodes;
        }

        public String getMaster() {
            return this.master;
        }

        public Integer getDatabase() {
            return this.database;
        }

        public String getPassword() {
            return this.password;
        }
    }

    public static class Pool {
        private Boolean blockWhenExhausted;
        private EvictionPolicy evictionPolicy;
        private String evictionPolicyClassName;
        private Long evictorShutdownTimeoutMillis;
        private Boolean fairness;
        private Boolean jmxEnabled;
        private String jmxNameBase;
        private String jmxNamePrefix;
        private Boolean lifo;
        private Integer maxIdle;
        private Integer maxTotal;
        private Long maxWaitMillis;
        private Long minEvictableIdleTimeMillis;
        private Integer minIdle;
        private Integer numTestsPerEvictionRun;
        private Long softMinEvictableIdleTimeMillis;
        private Boolean testOnBorrow;
        private Boolean testOnCreate;
        private Boolean testOnReturn;
        private Boolean testWhileIdle;
        private Long timeBetweenEvictionRunsMillis;

        public void updatePoolConfig(GenericObjectPoolConfig<?> poolConfig) {
            if (this.blockWhenExhausted != null) {
                poolConfig.setBlockWhenExhausted(this.blockWhenExhausted.booleanValue());
            }
            if (this.evictionPolicy != null) {
                poolConfig.setEvictionPolicy(this.evictionPolicy);
            }
            if (this.evictionPolicyClassName != null && !this.evictionPolicyClassName.isEmpty()) {
                poolConfig.setEvictionPolicyClassName(this.evictionPolicyClassName);
            }
            if (this.fairness != null) {
                poolConfig.setFairness(this.fairness.booleanValue());
            }
            if (this.jmxEnabled != null) {
                poolConfig.setJmxEnabled(this.jmxEnabled.booleanValue());
            }
            if (this.jmxNameBase != null && !this.jmxNameBase.isEmpty()) {
                poolConfig.setJmxNameBase(this.jmxNameBase);
            }
            if (this.jmxNamePrefix != null && !this.jmxNamePrefix.isEmpty()) {
                poolConfig.setJmxNamePrefix(this.jmxNamePrefix);
            }
            if (this.lifo != null) {
                poolConfig.setLifo(this.lifo.booleanValue());
            }
            if (this.maxIdle != null && this.maxIdle > 0) {
                poolConfig.setMaxIdle(this.maxIdle.intValue());
            }
            if (this.maxTotal != null && this.maxTotal > 0) {
                poolConfig.setMaxTotal(this.maxTotal.intValue());
            }
            if (this.minIdle != null && this.minIdle > 0) {
                poolConfig.setMinIdle(this.minIdle.intValue());
            }
            if (this.numTestsPerEvictionRun != null && this.numTestsPerEvictionRun > 0) {
                poolConfig.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun.intValue());
            }
            if (this.testOnBorrow != null) {
                poolConfig.setTestOnBorrow(this.testOnBorrow.booleanValue());
            }
            if (this.testOnCreate != null) {
                poolConfig.setTestOnCreate(this.testOnCreate.booleanValue());
            }
            if (this.testOnReturn != null) {
                poolConfig.setTestOnReturn(this.testOnReturn.booleanValue());
            }
            if (this.testWhileIdle != null) {
                poolConfig.setTestWhileIdle(this.testWhileIdle.booleanValue());
            }
            DepreHelper.updatePoolConfig(poolConfig, this);
        }

        public void setBlockWhenExhausted(Boolean blockWhenExhausted) {
            this.blockWhenExhausted = blockWhenExhausted;
        }

        public void setEvictionPolicy(EvictionPolicy evictionPolicy) {
            this.evictionPolicy = evictionPolicy;
        }

        public void setEvictionPolicyClassName(String evictionPolicyClassName) {
            this.evictionPolicyClassName = evictionPolicyClassName;
        }

        public void setEvictorShutdownTimeoutMillis(Long evictorShutdownTimeoutMillis) {
            this.evictorShutdownTimeoutMillis = evictorShutdownTimeoutMillis;
        }

        public void setFairness(Boolean fairness) {
            this.fairness = fairness;
        }

        public void setJmxEnabled(Boolean jmxEnabled) {
            this.jmxEnabled = jmxEnabled;
        }

        public void setJmxNameBase(String jmxNameBase) {
            this.jmxNameBase = jmxNameBase;
        }

        public void setJmxNamePrefix(String jmxNamePrefix) {
            this.jmxNamePrefix = jmxNamePrefix;
        }

        public void setLifo(Boolean lifo) {
            this.lifo = lifo;
        }

        public void setMaxIdle(Integer maxIdle) {
            this.maxIdle = maxIdle;
        }

        public void setMaxTotal(Integer maxTotal) {
            this.maxTotal = maxTotal;
        }

        public void setMaxWaitMillis(Long maxWaitMillis) {
            this.maxWaitMillis = maxWaitMillis;
        }

        public void setMinEvictableIdleTimeMillis(Long minEvictableIdleTimeMillis) {
            this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        }

        public void setMinIdle(Integer minIdle) {
            this.minIdle = minIdle;
        }

        public void setNumTestsPerEvictionRun(Integer numTestsPerEvictionRun) {
            this.numTestsPerEvictionRun = numTestsPerEvictionRun;
        }

        public void setSoftMinEvictableIdleTimeMillis(Long softMinEvictableIdleTimeMillis) {
            this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
        }

        public void setTestOnBorrow(Boolean testOnBorrow) {
            this.testOnBorrow = testOnBorrow;
        }

        public void setTestOnCreate(Boolean testOnCreate) {
            this.testOnCreate = testOnCreate;
        }

        public void setTestOnReturn(Boolean testOnReturn) {
            this.testOnReturn = testOnReturn;
        }

        public void setTestWhileIdle(Boolean testWhileIdle) {
            this.testWhileIdle = testWhileIdle;
        }

        public void setTimeBetweenEvictionRunsMillis(Long timeBetweenEvictionRunsMillis) {
            this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        }

        public Boolean getBlockWhenExhausted() {
            return this.blockWhenExhausted;
        }

        public EvictionPolicy getEvictionPolicy() {
            return this.evictionPolicy;
        }

        public String getEvictionPolicyClassName() {
            return this.evictionPolicyClassName;
        }

        public Long getEvictorShutdownTimeoutMillis() {
            return this.evictorShutdownTimeoutMillis;
        }

        public Boolean getFairness() {
            return this.fairness;
        }

        public Boolean getJmxEnabled() {
            return this.jmxEnabled;
        }

        public String getJmxNameBase() {
            return this.jmxNameBase;
        }

        public String getJmxNamePrefix() {
            return this.jmxNamePrefix;
        }

        public Boolean getLifo() {
            return this.lifo;
        }

        public Integer getMaxIdle() {
            return this.maxIdle;
        }

        public Integer getMaxTotal() {
            return this.maxTotal;
        }

        public Long getMaxWaitMillis() {
            return this.maxWaitMillis;
        }

        public Long getMinEvictableIdleTimeMillis() {
            return this.minEvictableIdleTimeMillis;
        }

        public Integer getMinIdle() {
            return this.minIdle;
        }

        public Integer getNumTestsPerEvictionRun() {
            return this.numTestsPerEvictionRun;
        }

        public Long getSoftMinEvictableIdleTimeMillis() {
            return this.softMinEvictableIdleTimeMillis;
        }

        public Boolean getTestOnBorrow() {
            return this.testOnBorrow;
        }

        public Boolean getTestOnCreate() {
            return this.testOnCreate;
        }

        public Boolean getTestOnReturn() {
            return this.testOnReturn;
        }

        public Boolean getTestWhileIdle() {
            return this.testWhileIdle;
        }

        public Long getTimeBetweenEvictionRunsMillis() {
            return this.timeBetweenEvictionRunsMillis;
        }
    }
}

