/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.report;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ideahut.springboot.report.ReportHandler;
import net.ideahut.springboot.report.ReportInput;
import net.ideahut.springboot.report.ReportResult;
import net.ideahut.springboot.report.ReportType;
import net.ideahut.springboot.util.FrameworkUtil;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportHandlerImpl
implements ReportHandler {
    private static final Logger log = LoggerFactory.getLogger(ReportHandlerImpl.class);
    private final Map<String, Constructor<?>> exporters = new LinkedHashMap();
    private final Map<String, Constructor<?>> outputs = new LinkedHashMap();

    public ReportHandlerImpl() {
        for (ReportType reportType : ReportType.values()) {
            try {
                Constructor exporter = FrameworkUtil.classOf(reportType.getExporter()).getConstructor(new Class[0]);
                this.exporters.put(reportType.getExporter(), exporter);
                Constructor output = FrameworkUtil.classOf(reportType.getOutput()).getConstructor(OutputStream.class);
                this.outputs.put(reportType.getOutput(), output);
            }
            catch (Exception e) {
                log.warn("Failed get exporter / output for: " + reportType.name() + " [exporter: " + reportType.getExporter() + ", output: " + reportType.getOutput() + "]");
            }
        }
    }

    @Override
    public ReportResult createReport(ReportInput input, boolean useExportManager) throws Exception {
        ReportType type = input.getType();
        if (useExportManager) {
            JasperPrint print = this.createPrint(input);
            return ReportResult.of((ReportType)type, (byte[])(switch (type) {
                case ReportType.PDF -> JasperExportManager.exportReportToPdf((JasperPrint)print);
                case ReportType.XML -> JasperExportManager.exportReportToXml((JasperPrint)print).getBytes();
                default -> throw new Exception("Unsupported use export manager for type: " + type.name());
            }));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.exportReport(input, baos);
        byte[] bytes = baos.toByteArray();
        return ReportResult.of((ReportType)type, (byte[])bytes);
    }

    @Override
    public ReportResult createReport(ReportInput input) throws Exception {
        return this.createReport(input, false);
    }

    @Override
    public void exportReport(ReportInput input, OutputStream outputStream) throws Exception {
        JasperPrint print = this.createPrint(input);
        ReportType type = input.getType();
        JRAbstractExporter exporter = (JRAbstractExporter)this.exporters.get(type.getExporter()).newInstance(new Object[0]);
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(print));
        Object output = this.outputs.get(type.getOutput()).newInstance(outputStream);
        if (output instanceof OutputStreamExporterOutput) {
            exporter.setExporterOutput((ExporterOutput)((OutputStreamExporterOutput)output));
        } else if (output instanceof ExporterOutput) {
            exporter.setExporterOutput((ExporterOutput)output);
        } else {
            throw new Exception("Exporter is not defined for type: " + type.name());
        }
        exporter.exportReport();
    }

    @Override
    public JasperPrint createPrint(ReportInput input) throws JRException {
        Object first;
        JasperReport jReport = input.getReport();
        Object jrDataSource = null;
        Collection<?> datasource = input.getDatasource();
        jrDataSource = datasource != null && !datasource.isEmpty() ? ((first = datasource.iterator().next()) instanceof Map ? new JRMapCollectionDataSource(datasource) : (first instanceof Object[] ? new JRBeanArrayDataSource(datasource.toArray(new Object[0])) : new JRBeanCollectionDataSource(datasource))) : new JREmptyDataSource();
        return JasperFillManager.fillReport((JasperReport)jReport, (Map)input.getParameters(), (JRDataSource)jrDataSource);
    }
}

