/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.security;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.security.SecurityUser;
import net.ideahut.springboot.util.FrameworkUtil;
import org.mindrot.jbcrypt.BCrypt;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.Assert;

final class RedisMemoryCredentialHelper {
    private RedisMemoryCredentialHelper() {
    }

    static synchronized boolean lock(RedisTemplate<String, byte[]> redisTemplate, String redisPrefix, boolean yes) {
        String lockKey = Key.lock(redisPrefix);
        if (yes) {
            ValueOperations lockOps = redisTemplate.opsForValue();
            byte[] lockBytes = (byte[])lockOps.get((Object)lockKey);
            if (lockBytes != null) {
                return false;
            }
            lockOps.set((Object)lockKey, (Object)"1".getBytes());
        } else {
            redisTemplate.delete((Object)lockKey);
        }
        return true;
    }

    static void clear(Configuration configuration) {
        ValueOperations operations = configuration.redisTemplate.opsForValue();
        HashSet<Object> keys = new HashSet<Object>();
        String lkey = Key.userkeys(configuration.redisPrefix);
        keys.add(lkey);
        byte[] bytes = (byte[])operations.get((Object)lkey);
        if (bytes != null) {
            Set<String> users = configuration.dataMapper.read(bytes, TypeRef.STRING_SET);
            String upre = Key.user(configuration.redisPrefix);
            for (String user : users) {
                keys.add(upre + user);
            }
        }
        configuration.redisTemplate.delete(keys);
    }

    static void setUsers(Configuration configuration, Collection<SecurityUser> users) {
        HashSet<String> userKeys = new HashSet<String>();
        HashMap<Object, byte[]> redisValues = new HashMap<Object, byte[]>();
        String preuser = Key.user(configuration.redisPrefix);
        for (SecurityUser user : users) {
            Assert.hasLength((String)user.getUsername(), (String)"username is required");
            Assert.hasLength((String)user.getPassword(), (String)"password is required");
            HashSet hosts = user.getHosts();
            if (hosts == null) {
                hosts = new HashSet();
            }
            if (hosts.contains("*")) {
                hosts.clear();
            }
            user.setHosts(hosts);
            String ckey = preuser + user.getUsername();
            byte[] cval = configuration.dataMapper.writeAsBytes(user, 1);
            redisValues.put(ckey, cval);
            userKeys.add(user.getUsername());
        }
        byte[] userValues = configuration.dataMapper.writeAsBytes(userKeys, 1);
        redisValues.put(Key.userkeys(configuration.redisPrefix), userValues);
        RedisMemoryCredentialHelper.clear(configuration);
        configuration.redisTemplate.opsForValue().multiSet(redisValues);
    }

    static SecurityUser getUser(Configuration configuration, String username) {
        ValueOperations operations = configuration.redisTemplate.opsForValue();
        byte[] bytes = (byte[])operations.get((Object)(Key.user(configuration.redisPrefix) + username));
        if (bytes == null) {
            return null;
        }
        return configuration.dataMapper.read(bytes, SecurityUser.class);
    }

    static boolean registerUser(Configuration configuration, MapStringObject parameter) {
        String passwordType;
        String host;
        SecurityUser user;
        String authorization = (String)parameter.getValue("authorization", (Object)"");
        Assert.hasLength((String)authorization, (String)"authorization is required");
        Integer expiry = (Integer)parameter.getValue("expiry");
        if (expiry == null || expiry <= 0) {
            expiry = configuration.redisExpiry;
        }
        if ((user = (SecurityUser)parameter.getValue("user")) != null) {
            byte[] bytes = configuration.dataMapper.writeAsBytes(user, 1);
            configuration.redisTemplate.opsForValue().set((Object)(Key.auth(configuration.redisPrefix) + authorization), (Object)bytes, (long)expiry.intValue(), TimeUnit.MINUTES);
            return true;
        }
        String username = (String)parameter.getValue("username", (Object)"");
        Assert.hasLength((String)username, (String)"username is required");
        String password = (String)parameter.getValue("password", (Object)"");
        Assert.hasLength((String)password, (String)"password is required");
        user = RedisMemoryCredentialHelper.getUser(configuration, username);
        if (user == null) {
            return false;
        }
        Set hosts = user.getHosts();
        if (hosts != null && !hosts.isEmpty() && !hosts.contains(host = (String)parameter.getValue("host", (Object)""))) {
            return false;
        }
        boolean valid = false;
        String string = passwordType = configuration.passwordType != null ? configuration.passwordType : "";
        if ("bcrypt".equals(passwordType)) {
            valid = BCrypt.checkpw((String)password, (String)user.getPassword());
        } else if (passwordType.startsWith("sha") || passwordType.startsWith("md")) {
            String hash = FrameworkUtil.digest(passwordType, password);
            valid = password.equals(hash);
        } else {
            valid = password.equals(user.getPassword());
        }
        if (valid) {
            user.setAttribute(SecurityUser.Attribute.HOST, (String)parameter.getValue("host", (Object)""));
            user.setAttribute(SecurityUser.Attribute.AGENT, (String)parameter.getValue("agent", (Object)""));
            byte[] bytes = configuration.dataMapper.writeAsBytes(user, 1);
            configuration.redisTemplate.opsForValue().set((Object)(Key.auth(configuration.redisPrefix) + authorization), (Object)bytes, (long)expiry.intValue(), TimeUnit.MINUTES);
        }
        return valid;
    }

    static SecurityUser getSecurityUser(Configuration configuration, MapStringObject parameter) {
        byte[] bytes;
        String authorization = (String)parameter.getValue("authorization", (Object)"");
        if (!authorization.isEmpty() && (bytes = (byte[])configuration.redisTemplate.opsForValue().get((Object)(Key.auth(configuration.redisPrefix) + authorization))) != null) {
            return configuration.dataMapper.read(bytes, SecurityUser.class);
        }
        return null;
    }

    static void invalidate(Configuration configuration, MapStringObject parameter) {
        String authorization = (String)parameter.getValue("authorization", (Object)"");
        Assert.hasLength((String)authorization, (String)"authorization is required");
        configuration.redisTemplate.delete((Object)(Key.auth(configuration.redisPrefix) + authorization));
    }

    static final class Key {
        private Key() {
        }

        static String lock(String prefix) {
            return prefix + "--LOCK--";
        }

        static String userkeys(String prefix) {
            return prefix + "--USERS--";
        }

        static String user(String prefix) {
            return prefix + "::USER::";
        }

        static String auth(String prefix) {
            return prefix + "::AUTH::";
        }
    }

    static final class Configuration {
        protected DataMapper dataMapper;
        protected RedisTemplate<String, byte[]> redisTemplate;
        protected String passwordType;
        protected String redisPrefix;
        protected Integer redisExpiry;

        Configuration() {
        }
    }

    static final class TypeRef {
        static final TypeReference<Set<String>> STRING_SET = new TypeReference<Set<String>>(){};
        static final TypeReference<Set<SecurityUser>> USER_SET = new TypeReference<Set<SecurityUser>>(){};

        TypeRef() {
        }
    }
}

