/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.security;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Base64;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.security.SecurityAuthorization;
import net.ideahut.springboot.security.SecurityCredential;
import net.ideahut.springboot.util.WebMvcUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class WebMvcBasicAuthSecurity
implements SecurityAuthorization,
InitializingBean {
    private String realm;
    private SecurityCredential credential;

    public WebMvcBasicAuthSecurity setRealm(String realm) {
        this.realm = realm;
        return this;
    }

    public WebMvcBasicAuthSecurity setCredential(SecurityCredential credential) {
        this.credential = credential;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.credential, (String)"credential is required");
        if (this.realm == null) {
            this.realm = "Protected";
        }
    }

    public boolean isRequestAuthorized(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String basic;
        int idx;
        boolean authorized = false;
        String authorization = WebMvcUtil.getHeader(request, "Authorization");
        if (authorization != null && (idx = authorization.indexOf(" ")) != -1 && "Basic".equalsIgnoreCase(basic = authorization.substring(0, idx))) {
            String userpass = new String(Base64.getDecoder().decode(authorization.substring(idx + 1)));
            idx = userpass.indexOf(":");
            if (idx == -1) {
                return false;
            }
            String username = userpass.substring(0, idx);
            String password = userpass.substring(idx + 1);
            MapStringObject parameter = new MapStringObject().setValue("authorization", (Object)authorization).setValue("username", (Object)username).setValue("password", (Object)password);
            authorized = this.credential.isValidCredential(parameter);
        }
        if (!authorized) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            response.sendError(401);
        }
        return authorized;
    }
}

