/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.support;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ideahut.springboot.annotation.CompareIgnore;
import org.springframework.util.Assert;

public class CompareDtoAndEnt {
    private static final Map<Class<?>, CClass> classes = Collections.synchronizedMap(new HashMap());

    private CompareDtoAndEnt() {
    }

    private static CField getField(Class<?> clazz, Field field) {
        CField cField = null;
        CompareIgnore compareIgnore = field.getAnnotation(CompareIgnore.class);
        boolean isIgnore = compareIgnore != null && compareIgnore.value();
        int modifiers = field.getModifiers();
        if (!(isIgnore || Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers) || Modifier.isFinal(modifiers) || Modifier.isNative(modifiers))) {
            cField = new CField();
            cField.name = field.getName();
            cField.type = field.getType();
            cField.modifiers = modifiers;
            CompareDtoAndEnt.checkMethod(clazz, cField, false);
            CompareDtoAndEnt.checkMethod(clazz, cField, true);
        }
        return cField;
    }

    private static void checkMethod(Class<?> clazz, CField cField, boolean isSetter) {
        try {
            String name = cField.name.substring(0, 1).toUpperCase() + cField.name.substring(1);
            if (isSetter) {
                clazz.getMethod("set" + name, cField.type);
                cField.setter = true;
            } else {
                Method method = clazz.getMethod("get" + name, new Class[0]);
                cField.getter = method.getReturnType().equals(cField.type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static CClass getClass(Class<?> clazz) {
        if (!classes.containsKey(clazz)) {
            boolean isIgnore;
            CompareIgnore compareIgnore = clazz.getAnnotation(CompareIgnore.class);
            boolean bl = isIgnore = compareIgnore != null && compareIgnore.value();
            if (!isIgnore) {
                CClass cClass = new CClass();
                for (Class<?> theClass = clazz; theClass != null; theClass = theClass.getSuperclass()) {
                    for (Field field : theClass.getDeclaredFields()) {
                        CField cField = CompareDtoAndEnt.getField(clazz, field);
                        if (cField == null) continue;
                        cClass.fields.put(cField.name, cField);
                    }
                }
                classes.put(clazz, cClass);
            } else {
                classes.put(clazz, null);
            }
        }
        return classes.get(clazz);
    }

    public static void check(Class<?> reference, Class<?> target) {
        CClass cref = CompareDtoAndEnt.getClass(reference);
        CClass ctgt = CompareDtoAndEnt.getClass(target);
        for (Map.Entry<String, CField> entry : cref.fields.entrySet()) {
            CField cField = ctgt.fields.get(entry.getKey());
            Assert.notNull((Object)cField, (String)("Field '" + entry.getKey() + "' is not found in target: " + target.getName() + ", reference: " + reference.getName()));
            Assert.isTrue((boolean)entry.getValue().type.equals(cField.type), (String)("Invalid field '" + entry.getKey() + "' in: " + target.getName() + ", reference: " + reference.getName()));
            if (!Modifier.isPrivate(cField.modifiers) && !Modifier.isProtected(cField.modifiers)) continue;
            Assert.isTrue((boolean)cField.getter, (String)("Getter '" + entry.getKey() + "' is not found in: " + target.getName() + ", reference: " + reference.getName()));
            Assert.isTrue((boolean)cField.setter, (String)("Setter '" + entry.getKey() + "' is not found in: " + target.getName() + ", reference: " + reference.getName()));
        }
    }

    public static void reset() {
        classes.clear();
    }

    private static class CField {
        private String name;
        private Class<?> type;
        private int modifiers;
        private boolean setter = false;
        private boolean getter = false;

        private CField() {
        }
    }

    private static class CClass {
        private Map<String, CField> fields = new LinkedHashMap<String, CField>();

        private CClass() {
        }
    }
}

