/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.support;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import net.ideahut.springboot.grid.GridOption;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.message.MessageHandler;
import net.ideahut.springboot.object.Option;
import org.springframework.context.ApplicationContext;

public class GridOptionFromMessage
implements GridOption {
    private static final TypeReference<List<Option>> TYPE_REF = new TypeReference<List<Option>>(){};
    private final String messageCode;
    private MessageHandler messageHandler;
    private DataMapper dataMapper;

    public GridOptionFromMessage(String messageCode) {
        this.messageCode = messageCode;
    }

    @Override
    public List<Option> getOption(ApplicationContext applicationContext) {
        if (this.messageHandler == null) {
            this.messageHandler = (MessageHandler)applicationContext.getBean(MessageHandler.class);
            try {
                this.dataMapper = (DataMapper)applicationContext.getBean(DataMapper.class);
            }
            catch (Exception e) {
                this.dataMapper = new DataMapperImpl();
            }
        }
        String text = this.messageHandler.getText(this.messageCode);
        return this.dataMapper.read(text, TYPE_REF);
    }
}

