/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.sysparam;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.bean.BeanReload;
import net.ideahut.springboot.bean.BeanShutdown;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.support.CompareDtoAndEnt;
import net.ideahut.springboot.sysparam.SysParamHandler;
import net.ideahut.springboot.sysparam.SysParamHelper;
import net.ideahut.springboot.sysparam.SysParamReloader;
import net.ideahut.springboot.sysparam.SysParamRemover;
import net.ideahut.springboot.sysparam.SysParamUpdater;
import net.ideahut.springboot.sysparam.dto.SysParamDto;
import net.ideahut.springboot.util.FrameworkUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class SysParamHandlerImpl
implements SysParamHandler,
SysParamRemover,
SysParamReloader,
SysParamUpdater,
InitializingBean,
BeanReload,
BeanShutdown,
BeanConfigure<SysParamHandler> {
    private boolean configured = false;
    protected TrxManagerInfo trxManagerInfo;
    protected DataMapper dataMapper;
    protected String redisPrefix;
    protected RedisTemplate<String, byte[]> redisTemplate;
    private EntityTrxManager entityTrxManager;
    protected EntityClass entityClass;

    public SysParamHandlerImpl setRedisPrefix(String redisPrefix) {
        this.redisPrefix = redisPrefix;
        return this;
    }

    public SysParamHandlerImpl setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public SysParamHandlerImpl setRedisTemplate(RedisTemplate<String, byte[]> redisTemplate) {
        this.redisTemplate = redisTemplate;
        return this;
    }

    public SysParamHandlerImpl setEntityTrxManager(EntityTrxManager entityTrxManager) {
        this.entityTrxManager = entityTrxManager;
        return this;
    }

    public SysParamHandlerImpl setEntityClass(EntityClass entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.redisTemplate, (String)"redisTemplate is required");
        Assert.notNull((Object)this.entityTrxManager, (String)"entityTrxManager is required");
        Assert.notNull((Object)this.entityClass, (String)"entityClass is required");
        Assert.notNull(this.entityClass.getSysParam(), (String)"entityClass.sysParam is required");
        String trxManagerName = this.entityClass.getTrxManagerName();
        trxManagerName = trxManagerName != null ? trxManagerName.trim() : "";
        this.entityClass.setTrxManagerName(trxManagerName);
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        String string = this.redisPrefix = this.redisPrefix != null ? this.redisPrefix.trim() : "";
        if (this.redisPrefix.isEmpty()) {
            this.redisPrefix = "SysParamHandler";
        }
    }

    @Override
    public Callable<SysParamHandler> onConfigureBean(ApplicationContext applicationContext) {
        final SysParamHandlerImpl self = this;
        return new Callable<SysParamHandler>(){

            @Override
            public SysParamHandler call() throws Exception {
                SysParamHandlerImpl.this.trxManagerInfo = FrameworkUtil.getTrxManagerInfo(SysParamHandlerImpl.this.entityTrxManager, SysParamHandlerImpl.this.entityClass.getTrxManagerName());
                Assert.notNull((Object)SysParamHandlerImpl.this.trxManagerInfo, (String)("TrxManager is not found, for: " + SysParamHandlerImpl.this.entityClass.getTrxManagerName()));
                Assert.notNull((Object)SysParamHandlerImpl.this.trxManagerInfo.getEntityInfo(SysParamHandlerImpl.this.entityClass.getSysParam()), (String)("Entity class '" + SysParamHandlerImpl.this.entityClass.getSysParam().getName() + "' is not found in TrxManager: " + SysParamHandlerImpl.this.trxManagerInfo.getName()));
                CompareDtoAndEnt.check(SysParamDto.class, SysParamHandlerImpl.this.entityClass.getSysParam());
                SysParamHandlerImpl.this.onReloadBean();
                SysParamHandlerImpl.this.configured = true;
                return self;
            }
        };
    }

    @Override
    public boolean isBeanConfigured() {
        return this.configured;
    }

    public boolean onReloadBean() throws Exception {
        if (!SysParamHelper.lock(this)) {
            return false;
        }
        try {
            SysParamHelper.clear(this);
            SysParamHelper.reloadSysCodes(this, new String[0]);
        }
        finally {
            SysParamHelper.unlock(this);
        }
        return true;
    }

    @Override
    public void onShutdownBean() {
        SysParamHelper.unlock(this);
    }

    public void removeSysCodes(String ... sysCodes) {
        BeanConfigure.checkBeanConfigure(this);
        SysParamHelper.removeSysCodes(this, sysCodes);
    }

    public void removeSysParam(String sysCode, String paramCode) {
        BeanConfigure.checkBeanConfigure(this);
        SysParamHelper.removeSysParam(this, sysCode, paramCode);
    }

    public void reloadSysCodes(String ... sysCodes) {
        BeanConfigure.checkBeanConfigure(this);
        SysParamHelper.reloadSysCodes(this, sysCodes);
    }

    public SysParamDto getSysParam(String sysCode, String paramCode) {
        BeanConfigure.checkBeanConfigure(this);
        String key = SysParamHelper.Key.value(this.redisPrefix, sysCode, paramCode);
        byte[] value = (byte[])this.redisTemplate.opsForValue().get((Object)key);
        return value != null ? this.dataMapper.read(value, SysParamDto.class) : null;
    }

    public Map<String, SysParamDto> getSysParamMap(String sysCode) {
        BeanConfigure.checkBeanConfigure(this);
        String key = SysParamHelper.Key.map(this.redisPrefix, sysCode);
        byte[] value = (byte[])this.redisTemplate.opsForValue().get((Object)key);
        return value != null ? this.dataMapper.read(value, SysParamHelper.TypeRef.SYSPARAM_MAP) : new HashMap<String, SysParamDto>();
    }

    public Map<String, Map<String, SysParamDto>> getSysParamMaps(String ... sysCodes) {
        BeanConfigure.checkBeanConfigure(this);
        return SysParamHelper.getSysParamMaps(this, sysCodes);
    }

    public <T> T getValue(Class<T> type, String sysCode, String paramCode, T defaultValue) {
        BeanConfigure.checkBeanConfigure(this);
        SysParamDto sysParam = this.getSysParam(sysCode, paramCode);
        return (T)(sysParam != null ? sysParam.getValue(type, defaultValue) : defaultValue);
    }

    public <T> T getValue(Class<T> type, String sysCode, String paramCode) {
        return this.getValue(type, sysCode, paramCode, null);
    }

    public <T> T getValue(Class<T> type, Map<String, SysParamDto> sysMap, String paramCode, T defaultValue) {
        BeanConfigure.checkBeanConfigure(this);
        SysParamDto sysParam = sysMap.get(paramCode);
        return (T)(sysParam != null ? sysParam.getValue(type, defaultValue) : defaultValue);
    }

    public <T> T getValue(Class<T> type, Map<String, SysParamDto> sysMap, String paramCode) {
        return this.getValue(type, sysMap, paramCode, null);
    }

    public byte[] getBytes(String sysCode, String paramCode, byte[] defaultValue) {
        BeanConfigure.checkBeanConfigure(this);
        SysParamDto sysParam = this.getSysParam(sysCode, paramCode);
        byte[] bytes = sysParam != null ? sysParam.getBytes() : null;
        return bytes != null ? bytes : defaultValue;
    }

    public byte[] getBytes(String sysCode, String paramCode) {
        BeanConfigure.checkBeanConfigure(this);
        return this.getBytes(sysCode, paramCode, null);
    }

    public void updateSysParam(SysParamDto sysParamDto) {
        BeanConfigure.checkBeanConfigure(this);
        SysParamHelper.updateSysParam(this, sysParamDto);
    }

    public static class EntityClass {
        private String trxManagerName;
        private Class<?> sysParam;

        public EntityClass setTrxManagerName(String trxManagerName) {
            this.trxManagerName = trxManagerName;
            return this;
        }

        public EntityClass setSysParam(Class<?> sysParam) {
            this.sysParam = sysParam;
            return this;
        }

        public String getTrxManagerName() {
            return this.trxManagerName;
        }

        public Class<?> getSysParam() {
            return this.sysParam;
        }
    }
}

