/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.sysparam;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.sysparam.SysParamHandlerImpl;
import net.ideahut.springboot.sysparam.dto.SysParamDto;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.data.redis.core.ValueOperations;

final class SysParamHelper {
    private SysParamHelper() {
    }

    static synchronized boolean lock(SysParamHandlerImpl handler) {
        String key = Key.lock(handler.redisPrefix);
        ValueOperations valops = handler.redisTemplate.opsForValue();
        byte[] bytes = (byte[])valops.get((Object)key);
        if (bytes != null) {
            return false;
        }
        valops.set((Object)key, (Object)"1".getBytes());
        return true;
    }

    static void unlock(SysParamHandlerImpl handler) {
        String key = Key.lock(handler.redisPrefix);
        handler.redisTemplate.delete((Object)key);
    }

    static synchronized void clear(SysParamHandlerImpl handler) {
        ValueOperations operations = handler.redisTemplate.opsForValue();
        HashSet<String> ckeys = new HashSet<String>();
        String lkey = Key.syscodes(handler.redisPrefix);
        ckeys.add(lkey);
        byte[] bytes = (byte[])operations.get((Object)lkey);
        if (bytes != null) {
            Map<String, Set<String>> sysCodes = handler.dataMapper.read(bytes, TypeRef.SYSCODE_MAP);
            for (Map.Entry<String, Set<String>> entry : sysCodes.entrySet()) {
                ckeys.add(Key.map(handler.redisPrefix, entry.getKey()));
                for (String paramCode : entry.getValue()) {
                    ckeys.add(Key.value(handler.redisPrefix, entry.getKey(), paramCode));
                }
            }
        }
        handler.redisTemplate.delete(ckeys);
    }

    private static void removeSysCodes(SysParamHandlerImpl handler, List<String> rSysCodes, Map<String, Set<String>> mSysCodes) {
        ValueOperations valops = handler.redisTemplate.opsForValue();
        HashSet<String> ckeys = new HashSet<String>();
        while (!rSysCodes.isEmpty()) {
            String rSysCode = rSysCodes.remove(0);
            ckeys.add(Key.map(handler.redisPrefix, rSysCode));
            Set<String> rParamCodes = mSysCodes.remove(rSysCode);
            if (rParamCodes == null) continue;
            for (String rParamCode : rParamCodes) {
                ckeys.add(Key.value(handler.redisPrefix, rSysCode, rParamCode));
            }
        }
        if (!mSysCodes.isEmpty()) {
            byte[] mbytes = handler.dataMapper.writeAsBytes(mSysCodes, 1);
            valops.set((Object)Key.syscodes(handler.redisPrefix), (Object)mbytes);
        } else {
            ckeys.add(Key.syscodes(handler.redisPrefix));
        }
        handler.redisTemplate.delete(ckeys);
    }

    static synchronized void removeSysCodes(SysParamHandlerImpl handler, String ... sysCodes) {
        ValueOperations valops = handler.redisTemplate.opsForValue();
        byte[] bytes = (byte[])valops.get((Object)Key.syscodes(handler.redisPrefix));
        if (bytes != null) {
            Map<String, Set<String>> mSysCodes = handler.dataMapper.read(bytes, TypeRef.SYSCODE_MAP);
            ArrayList<String> rSysCodes = sysCodes != null && sysCodes.length != 0 ? new ArrayList<String>(Arrays.asList(sysCodes)) : new ArrayList<String>(mSysCodes.keySet());
            SysParamHelper.removeSysCodes(handler, rSysCodes, mSysCodes);
        }
    }

    static synchronized void removeSysParam(SysParamHandlerImpl handler, String sysCode, String paramCode) {
        ValueOperations valops = handler.redisTemplate.opsForValue();
        List lbytes = valops.multiGet(Arrays.asList(Key.syscodes(handler.redisPrefix), Key.map(handler.redisPrefix, sysCode)));
        if (lbytes != null && lbytes.size() == 2) {
            Map<String, Set<String>> sysCodes = lbytes.get(0) != null ? handler.dataMapper.read((byte[])lbytes.get(0), TypeRef.SYSCODE_MAP) : null;
            Map<String, SysParamDto> sysMap = lbytes.get(1) != null ? handler.dataMapper.read((byte[])lbytes.get(1), TypeRef.SYSPARAM_MAP) : null;
            HashMap<String, byte[]> mbytes = new HashMap<String, byte[]>();
            if (sysCodes != null) {
                Set<String> paramCodes = sysCodes.get(sysCode);
                if (paramCodes != null) {
                    paramCodes.remove(paramCode);
                }
                mbytes.put(Key.syscodes(handler.redisPrefix), handler.dataMapper.writeAsBytes(sysCodes, 1));
            }
            if (sysMap != null) {
                sysMap.remove(paramCode);
                mbytes.put(Key.map(handler.redisPrefix, sysCode), handler.dataMapper.writeAsBytes(sysMap, 1));
            }
            valops.multiSet(mbytes);
            handler.redisTemplate.delete((Object)Key.value(handler.redisPrefix, sysCode, paramCode));
        }
    }

    private static void reloadSysCodes(SysParamHandlerImpl handler, List<SysParamDto> sysParams) {
        HashMap<String, byte[]> values = new HashMap<String, byte[]>();
        ValueOperations valops = handler.redisTemplate.opsForValue();
        byte[] bytes = (byte[])valops.get((Object)Key.syscodes(handler.redisPrefix));
        HashMap<String, HashSet<String>> mSysCodes = bytes != null ? handler.dataMapper.read(bytes, TypeRef.SYSCODE_MAP) : new HashMap<String, HashSet<String>>();
        LinkedHashMap<String, LinkedHashMap<String, SysParamDto>> iSysMap = new LinkedHashMap<String, LinkedHashMap<String, SysParamDto>>();
        for (SysParamDto sysParamDto : sysParams) {
            String iSesKey = Key.map(handler.redisPrefix, sysParamDto.getSysCode());
            LinkedHashMap<String, SysParamDto> iParamMap = (LinkedHashMap<String, SysParamDto>)iSysMap.get(iSesKey);
            if (iParamMap == null) {
                iParamMap = new LinkedHashMap<String, SysParamDto>();
                iSysMap.put(iSesKey, iParamMap);
            }
            iParamMap.put(sysParamDto.getParamCode(), sysParamDto);
            HashSet<String> mParamCodes = (HashSet<String>)mSysCodes.get(sysParamDto.getSysCode());
            if (mParamCodes == null) {
                mParamCodes = new HashSet<String>();
                mSysCodes.put(sysParamDto.getSysCode(), mParamCodes);
            }
            mParamCodes.add(sysParamDto.getParamCode());
            byte[] value = handler.dataMapper.writeAsBytes(sysParamDto, 1);
            values.put(Key.value(handler.redisPrefix, sysParamDto.getSysCode(), sysParamDto.getParamCode()), value);
        }
        for (Map.Entry entry : iSysMap.entrySet()) {
            byte[] value = handler.dataMapper.writeAsBytes(entry.getValue(), 1);
            values.put((String)entry.getKey(), value);
        }
        byte[] value = handler.dataMapper.writeAsBytes(mSysCodes, 1);
        values.put(Key.syscodes(handler.redisPrefix), value);
        valops.multiSet(values);
        mSysCodes.clear();
        iSysMap.clear();
        values.clear();
    }

    static synchronized void reloadSysCodes(final SysParamHandlerImpl handler, final String ... sysCodes) {
        final boolean isAllSysCodes = sysCodes == null || sysCodes.length == 0;
        List<SysParamDto> sysParams = handler.trxManagerInfo.transaction(new SessionCallable<List<SysParamDto>>(){

            @Override
            public List<SysParamDto> call(Session session) throws Exception {
                Query query = session.createQuery("from " + handler.entityClass.getSysParam().getName() + (!isAllSysCodes ? " where sysCode in (?1)" : ""), Object.class);
                if (!isAllSysCodes) {
                    query.setParameter(1, Arrays.asList(sysCodes));
                }
                List items = query.getResultList();
                ArrayList<SysParamDto> sysParams = new ArrayList<SysParamDto>();
                while (!items.isEmpty()) {
                    Object item = items.remove(0);
                    handler.trxManagerInfo.loadLazy(item, handler.entityClass.getSysParam());
                    SysParamDto sysParam = handler.dataMapper.copy(item, SysParamDto.class);
                    sysParams.add(sysParam);
                }
                return sysParams;
            }
        });
        SysParamHelper.removeSysCodes(handler, sysCodes);
        if (sysParams != null) {
            SysParamHelper.reloadSysCodes(handler, sysParams);
        }
    }

    static Map<String, Map<String, SysParamDto>> getSysParamMaps(SysParamHandlerImpl handler, String ... sysCodes) {
        HashMap<String, Map<String, SysParamDto>> maps = new HashMap<String, Map<String, SysParamDto>>();
        if (sysCodes != null && sysCodes.length != 0) {
            ArrayList<String> lcodes = new ArrayList<String>();
            ArrayList<String> lkeys = new ArrayList<String>();
            for (String sysCode : sysCodes) {
                lcodes.add(sysCode);
                lkeys.add(Key.map(handler.redisPrefix, sysCode));
            }
            ValueOperations valops = handler.redisTemplate.opsForValue();
            List lvalues = valops.multiGet(lkeys);
            if (lvalues != null && lvalues.size() == lkeys.size()) {
                int i = 0;
                while (!lvalues.isEmpty()) {
                    byte[] lvalue = (byte[])lvalues.remove(0);
                    Map<Object, Object> mvalue = lvalue != null ? handler.dataMapper.read(lvalue, TypeRef.SYSPARAM_MAP) : new HashMap();
                    maps.put((String)lcodes.get(i), mvalue);
                    ++i;
                }
            }
            lcodes.clear();
            lkeys.clear();
        }
        return maps;
    }

    static void updateSysParam(SysParamHandlerImpl handler, SysParamDto sysParamDto) {
        final Object entity = handler.dataMapper.copy((Object)sysParamDto, handler.entityClass.getSysParam());
        handler.trxManagerInfo.transaction(true, new SessionCallable<Void>(){

            @Override
            public Void call(Session session) throws Exception {
                EntityHelper.saveOrUpdate(session, entity);
                return null;
            }
        });
    }

    static final class Key {
        private Key() {
        }

        static String lock(String prefix) {
            return prefix + "-SysParam-Lock";
        }

        static String syscodes(String prefix) {
            return prefix + "-SysParam-SysCodes";
        }

        static String map(String prefix, String sysCode) {
            return prefix + "-SysParam-Map-" + sysCode;
        }

        static String value(String prefix, String sysCode, String paramCode) {
            return prefix + "-SysParam-Val-" + sysCode + "::" + paramCode;
        }
    }

    static final class TypeRef {
        static final TypeReference<List<SysParamDto>> SYSPARAM_LIST = new TypeReference<List<SysParamDto>>(){};
        static final TypeReference<Map<String, SysParamDto>> SYSPARAM_MAP = new TypeReference<Map<String, SysParamDto>>(){};
        static final TypeReference<Map<String, Set<String>>> SYSCODE_MAP = new TypeReference<Map<String, Set<String>>>(){};

        private TypeRef() {
        }
    }
}

