/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import java.io.File;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import net.ideahut.springboot.annotation.ApiSkip;
import net.ideahut.springboot.annotation.Body;
import net.ideahut.springboot.annotation.Public;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.exception.ResultException;
import net.ideahut.springboot.exception.ResultRuntimeException;
import net.ideahut.springboot.object.ApplicationInfo;
import net.ideahut.springboot.object.BeanInfo;
import net.ideahut.springboot.object.RequestInfo;
import net.ideahut.springboot.object.Result;
import net.ideahut.springboot.object.VersionInfo;
import net.ideahut.springboot.util.ErrorUtil;
import net.ideahut.springboot.util.FrameworkUtil0;
import net.ideahut.springboot.util.WebFluxUtil;
import net.ideahut.springboot.util.WebMvcUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.filter.GenericFilterBean;
import org.springframework.web.method.HandlerMethod;

public final class FrameworkUtil {
    public static final String PACKAGE = "net.ideahut.springboot";
    public static final Character YES = Character.valueOf('Y');
    public static final Character NO = Character.valueOf('N');
    private static final Set<String> hibernateKeys = FrameworkUtil0.getHibernateKeys();

    private FrameworkUtil() {
    }

    public static void checkDependecies(ApplicationContext applicationContext) {
        FrameworkUtil0.checkDependecies(applicationContext);
    }

    public static Map<String, Object> getHibernateSettings(Environment environment, String prefix) {
        LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>();
        for (String key : hibernateKeys) {
            String value = environment.getProperty(prefix + "." + key);
            if (value == null) continue;
            settings.put(key, value);
        }
        return settings;
    }

    public static Map<String, Object> getHibernateSettings(Map<String, ?> map) {
        LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (!hibernateKeys.contains(entry.getKey())) continue;
            settings.put(entry.getKey(), entry.getValue());
        }
        return settings;
    }

    public static Properties getHibernateProperties(Environment environment, String prefix) {
        Properties properties = new Properties();
        for (String key : hibernateKeys) {
            String value = environment.getProperty(prefix + "." + key);
            if (value == null) continue;
            properties.setProperty(key, value);
        }
        return properties;
    }

    public static Properties getHibernateProperties(Map<String, ?> map) {
        Properties properties = new Properties();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (!hibernateKeys.contains(entry.getKey())) continue;
            properties.setProperty(entry.getKey(), entry.getValue() != null ? "" + entry.getValue() : null);
        }
        return properties;
    }

    public static <T extends GenericFilterBean> FilterRegistrationBean<T> createFilterBean(Environment environment, T filter, int order, String ... urlPatterns) {
        filter.setEnvironment(environment);
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter(filter);
        bean.addUrlPatterns(urlPatterns);
        bean.setOrder(order);
        return bean;
    }

    public static RuntimeException exception(Throwable e) {
        throw new RuntimeException(e);
    }

    public static RuntimeException exception(String text) {
        throw new RuntimeException(text);
    }

    public static RuntimeException exception(Result result) {
        throw new ResultRuntimeException(result);
    }

    public static void throwIf(boolean condition, Result result) {
        if (condition) {
            FrameworkUtil.exception(result);
        }
    }

    public static void throwIf(boolean condition, String code, String text) {
        FrameworkUtil.throwIf(condition, Result.error((String)code, (String)text));
    }

    public static void throwIf(boolean condition, String text) {
        if (condition) {
            FrameworkUtil.exception(text);
        }
    }

    public static <T> Class<T> classOf(String name, boolean initialize, ClassLoader loader) {
        try {
            return Class.forName(name, initialize, loader);
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    public static <T> Class<T> classOf(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    public static <T> T newInstance(Class type, Class[] constructorTypes, Object ... arguments) throws Exception {
        return type.getConstructor(constructorTypes).newInstance(arguments);
    }

    public static <T> T newInstance(Class type, Object ... arguments) throws Exception {
        Class[] constructorTypes = null;
        if (arguments != null) {
            constructorTypes = new Class[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                constructorTypes[i] = arguments[i].getClass();
            }
        }
        return FrameworkUtil.newInstance(type, constructorTypes, arguments);
    }

    public static <T> T newInstance(String classname, Class[] constructorTypes, Object ... arguments) throws Exception {
        return FrameworkUtil.newInstance(FrameworkUtil.classOf(classname), constructorTypes, arguments);
    }

    public static <T> T newInstance(String classname, Object ... arguments) throws Exception {
        return FrameworkUtil.newInstance(FrameworkUtil.classOf(classname), arguments);
    }

    public static byte[] resourceBytes(String target) throws Exception {
        byte[] bytes;
        String source;
        String string = source = target != null ? target.trim() : "";
        if (source.isEmpty()) {
            return new byte[0];
        }
        if (source.startsWith("https://") || source.startsWith("http://")) {
            URL url = new URL(source);
            bytes = IOUtils.toByteArray((InputStream)url.openStream());
        } else if (source.startsWith("file:")) {
            String path = source.substring(5);
            bytes = FileUtils.readFileToByteArray((File)new File(path));
        } else {
            if (source.startsWith("classpath:")) {
                source = source.substring(10);
            }
            bytes = IOUtils.toByteArray((InputStream)new ClassPathResource(source).getInputStream());
        }
        return bytes;
    }

    public static boolean isReactiveApplication(ApplicationContext applicationContext) {
        return FrameworkUtil0.isReactive(applicationContext);
    }

    public static List<RequestInfo> getRequestInfos(ApplicationContext applicationContext, boolean includeEmptyMethod) {
        boolean reactive = FrameworkUtil0.isReactive(applicationContext);
        if (reactive) {
            return WebFluxUtil.getRequestInfos(applicationContext, includeEmptyMethod);
        }
        return WebMvcUtil.getRequestInfos(applicationContext, includeEmptyMethod);
    }

    public static Boolean isBodyRequest(HandlerMethod handlerMethod) {
        Body body = FrameworkUtil0.getAnnotation(Body.class, handlerMethod);
        return body != null ? Boolean.valueOf(body.request()) : null;
    }

    public static Boolean isRequestReadable(Object handler) {
        if (handler instanceof HandlerMethod) {
            return FrameworkUtil.isBodyRequest((HandlerMethod)handler);
        }
        return null;
    }

    public static Boolean isBodyResponse(HandlerMethod handlerMethod) {
        Body body = FrameworkUtil0.getAnnotation(Body.class, handlerMethod);
        return body != null ? Boolean.valueOf(body.response()) : null;
    }

    public static Boolean isResponseWritable(Object handler) {
        if (handler instanceof HandlerMethod) {
            return FrameworkUtil.isBodyResponse((HandlerMethod)handler);
        }
        return null;
    }

    public static WebServer getWebServer(ApplicationContext applicationContext) {
        return FrameworkUtil0.getWebServer(applicationContext);
    }

    public static int getPort(ApplicationContext applicationContext) {
        return FrameworkUtil0.getPort(applicationContext);
    }

    public static boolean isDeleted(Object entity) {
        if (entity instanceof EntitySoftDelete) {
            return ((EntitySoftDelete)entity).getDeletedOn() != null;
        }
        return true;
    }

    public static boolean isTrue(Character character) {
        if (character == null) {
            return false;
        }
        if (YES == character) {
            return true;
        }
        if (NO == character) {
            return false;
        }
        throw FrameworkUtil.exception("Undefined boolean character: " + character);
    }

    public static <T extends Annotation> T getAnnotation(Class<T> type, HandlerMethod handlerMethod) {
        return FrameworkUtil0.getAnnotation(type, handlerMethod);
    }

    public static boolean isPublic(HandlerMethod handlerMethod) {
        Public anPublic = FrameworkUtil0.getAnnotation(Public.class, handlerMethod);
        return anPublic != null && anPublic.value();
    }

    public static boolean isApiSkip(HandlerMethod handlerMethod) {
        ApiSkip anApiSkip = FrameworkUtil0.getAnnotation(ApiSkip.class, handlerMethod);
        return anApiSkip != null && anApiSkip.value();
    }

    public static String replacePath(String text) {
        return FrameworkUtil.replacePath(text, true);
    }

    public static String replacePath(String text, boolean normalized) {
        if (text != null) {
            String str = text.replace("{user.home}", System.getProperty("user.home")).replace("{java.home}", System.getProperty("java.home")).replace("{java.io.tmpdir}", System.getProperty("java.io.tmpdir")).replace("{user.dir}", System.getProperty("user.dir"));
            if (normalized) {
                str = str.replace("\\", "/").replace("/", File.separator);
            }
            return str;
        }
        return text;
    }

    public static String digest(String algorithm, String text) {
        String result = "";
        if (text != null) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                byte[] b = md.digest(text.getBytes());
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < b.length; ++i) {
                    sb.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
                }
                result = sb.toString();
            }
            catch (Exception e) {
                throw FrameworkUtil.exception(e);
            }
        }
        return result;
    }

    public static ApplicationInfo getApplicationInfo(ApplicationContext applicationContext) {
        return FrameworkUtil0.getApplicationInfo(applicationContext);
    }

    public static VersionInfo getVersionInfo(ApplicationContext applicationContext) {
        return FrameworkUtil0.getVersionInfo(applicationContext);
    }

    public static List<BeanInfo> getBeanInfos(ApplicationContext applicationContext) {
        return FrameworkUtil0.getBeanInfos(applicationContext);
    }

    public static <T> T getOrDefault(T object, T defaultValue) {
        if (object != null) {
            return object;
        }
        return defaultValue;
    }

    public static String encryptToBase64(String text, Integer factor, Integer length) {
        if (factor == null) {
            factor = 64;
        }
        if (factor < 0 || factor >= 256) {
            throw FrameworkUtil.exception("Invalid factor: " + factor + " (0 - 255)");
        }
        Integer size = length != null && length >= 0 ? length : 0;
        byte[] bytes = text.getBytes();
        if (bytes.length < size) {
            throw FrameworkUtil.exception("Invalid length: " + size);
        }
        if (size == 0) {
            for (i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)(factor + bytes[i]);
            }
        } else {
            for (i = 0; i < size; ++i) {
                bytes[i] = (byte)(factor + bytes[i]);
            }
        }
        String content = Base64.getEncoder().encodeToString(bytes);
        String prefix = StringUtils.leftPad((String)UUID.randomUUID().toString(), (int)36, (char)' ') + factor + "$";
        return Base64.getEncoder().encodeToString((prefix + content + "@" + size).getBytes());
    }

    public static String encryptToBase64(String text, Integer factor) {
        return FrameworkUtil.encryptToBase64(text, factor, null);
    }

    public static String encryptToBase64(String text) {
        return FrameworkUtil.encryptToBase64(text, null, null);
    }

    public static String decryptFromBase64(String text) {
        try {
            String sdec = new String(Base64.getDecoder().decode(text)).substring(36);
            int idx = sdec.indexOf("$");
            Integer factor = Integer.parseInt(sdec.substring(0, idx));
            sdec = sdec.substring(idx + 1);
            idx = sdec.lastIndexOf("@");
            Integer size = Integer.parseInt(sdec.substring(idx + 1));
            sdec = sdec.substring(0, idx);
            byte[] bytes = Base64.getDecoder().decode(sdec.substring(0, idx));
            if (size == 0) {
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (byte)(bytes[i] - factor);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    bytes[i] = (byte)(bytes[i] - factor);
                }
            }
            return new String(bytes);
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    public static Result getErrorAsResult(Throwable throwable) {
        Throwable ex = ErrorUtil.getCause((Throwable)throwable);
        Result result = null;
        result = ex instanceof ResultException ? ((ResultException)ex).getResult() : (ex instanceof ResultRuntimeException ? ((ResultRuntimeException)ex).getResult() : Result.error((List)ErrorUtil.getErrors((Throwable)ex, (boolean)true)));
        return result;
    }

    public static TrxManagerInfo getTrxManagerInfo(EntityTrxManager entityTrxManager, String trxManagerName) {
        if (trxManagerName != null && !trxManagerName.isEmpty()) {
            return entityTrxManager.getTrxManagerInfo(trxManagerName);
        }
        return entityTrxManager.getDefaultTrxManagerInfo();
    }
}

