/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.IdeahutVersion;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.bean.BeanReload;
import net.ideahut.springboot.object.ApplicationInfo;
import net.ideahut.springboot.object.BeanInfo;
import net.ideahut.springboot.object.VersionInfo;
import org.hibernate.Version;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.util.Assert;
import org.springframework.web.method.HandlerMethod;

final class FrameworkUtil0 {
    private static final String[] hibernateClasses = new String[]{"org.hibernate.jpa.AvailableSettings", "org.hibernate.cfg.AvailableSettings", "org.hibernate.cfg.BatchSettings", "org.hibernate.cfg.BytecodeSettings", "org.hibernate.cfg.CacheSettings", "org.hibernate.cfg.EnvironmentSettings", "org.hibernate.cfg.FetchSettings", "org.hibernate.cfg.JdbcSettings", "org.hibernate.cfg.JpaComplianceSettings", "org.hibernate.cfg.ManagedBeanSettings", "org.hibernate.cfg.MappingSettings", "org.hibernate.cfg.MultiTenancySettings", "org.hibernate.cfg.PersistenceSettings", "org.hibernate.cfg.QuerySettings", "org.hibernate.cfg.SchemaToolingSettings", "org.hibernate.cfg.SessionEventSettings", "org.hibernate.cfg.StatisticsSettings", "org.hibernate.cfg.TransactionSettings", "org.hibernate.cfg.ValidationSettings", "net.ideahut.springboot.entity.EntityIntegrator"};
    private static final Set<String> hibernateKeys;
    private static final Class<?> reactiveGenericClass;
    private static final Method reactiveWebServerMethod;
    private static final Method servletWebServerMethod;

    private FrameworkUtil0() {
    }

    private static void checkDependecy(ApplicationContext applicationContext, Class<?> type) {
        if (type != null) {
            Map beans = applicationContext.getBeansOfType(type);
            Assert.isTrue((beans.size() < 2 ? 1 : 0) != 0, (String)String.format("Bean '%s' found more than 1 bean: %s", type.getName(), beans));
        }
    }

    static void checkDependecies(ApplicationContext applicationContext) {
        Class filterClass;
        boolean filterFound = false;
        if (FrameworkUtil0.isReactive(applicationContext)) {
            filterClass = FrameworkUtil0.getClass("net.ideahut.springboot.filter.WebFluxRequestFilter");
            filterFound = filterClass != null && applicationContext.getBean(filterClass) != null;
        } else {
            filterClass = FrameworkUtil0.getClass("net.ideahut.springboot.filter.WebMvcRequestFilter");
            if (filterClass != null) {
                Class servletBeanFilter = FrameworkUtil0.getClass("org.springframework.boot.web.servlet.AbstractFilterRegistrationBean");
                Method servletFilterMethod = FrameworkUtil0.getMethod(servletBeanFilter, "getFilter", new Class[0]);
                Map beans = applicationContext.getBeansOfType(servletBeanFilter);
                for (Object bean : beans.values()) {
                    Object filter = FrameworkUtil0.invoke(bean, servletFilterMethod, new Object[0]);
                    if (filter == null || !filterClass.isAssignableFrom(filter.getClass())) continue;
                    filterFound = true;
                    break;
                }
            }
        }
        Assert.isTrue((boolean)filterFound, (String)("Unregistered filter: " + filterClass));
        FrameworkUtil0.checkDependecy(applicationContext, FrameworkUtil0.getClass("net.ideahut.springboot.entity.EntityTrxManager"));
        FrameworkUtil0.checkDependecy(applicationContext, FrameworkUtil0.getClass("net.ideahut.springboot.admin.AdminHandler"));
        FrameworkUtil0.checkDependecy(applicationContext, FrameworkUtil0.getClass("net.ideahut.springboot.api.ApiHandler"));
        FrameworkUtil0.checkDependecy(applicationContext, FrameworkUtil0.getClass("net.ideahut.springboot.api.ApiService"));
        FrameworkUtil0.checkDependecy(applicationContext, FrameworkUtil0.getClass("net.ideahut.springboot.crud.CrudHandler"));
        FrameworkUtil0.checkDependecy(applicationContext, FrameworkUtil0.getClass("net.ideahut.springboot.sysparam.SysParamHandler"));
    }

    static Set<String> getHibernateKeys() {
        return hibernateKeys;
    }

    static boolean isReactive(ApplicationContext applicationContext) {
        return reactiveGenericClass != null && reactiveGenericClass.isAssignableFrom(applicationContext.getClass());
    }

    static WebServer getWebServer(ApplicationContext applicationContext) {
        WebServer webServer = FrameworkUtil0.isReactive(applicationContext) ? (WebServer)FrameworkUtil0.invoke(applicationContext, reactiveWebServerMethod, new Object[0]) : (WebServer)FrameworkUtil0.invoke(applicationContext, servletWebServerMethod, new Object[0]);
        return webServer;
    }

    static int getPort(ApplicationContext applicationContext) {
        WebServer webServer = FrameworkUtil0.getWebServer(applicationContext);
        return webServer != null ? webServer.getPort() : -1;
    }

    static ApplicationInfo getApplicationInfo(ApplicationContext applicationContext) {
        ApplicationInfo info = new ApplicationInfo();
        info.setApplicationName(applicationContext.getApplicationName());
        info.setBeanCount(Integer.valueOf(applicationContext.getBeanDefinitionCount()));
        info.setDisplayName(applicationContext.getDisplayName());
        info.setId(applicationContext.getId());
        info.setStartupDate(Long.valueOf(applicationContext.getStartupDate()));
        WebServer webServer = FrameworkUtil0.getWebServer(applicationContext);
        if (webServer != null) {
            info.setServerClassname(webServer.getClass().getName());
            info.setServerPort(Integer.valueOf(webServer.getPort()));
        }
        return info;
    }

    static VersionInfo getVersionInfo(ApplicationContext applicationContext) {
        VersionInfo info = new VersionInfo();
        info.setReactive(Boolean.valueOf(FrameworkUtil0.isReactive(applicationContext)));
        info.setHibernate(Version.getVersionString());
        info.setIdeahut(IdeahutVersion.getVersion());
        info.setJava(System.getProperty("java.version"));
        info.setSpringBoot(SpringBootVersion.getVersion());
        info.setSpringFramework(SpringVersion.getVersion());
        return info;
    }

    static List<BeanInfo> getBeanInfos(ApplicationContext applicationContext) {
        ArrayList<BeanInfo> infos = new ArrayList<BeanInfo>();
        for (String name : applicationContext.getBeanDefinitionNames()) {
            Object object = applicationContext.getBean(name);
            BeanInfo info = new BeanInfo();
            info.setBeanName(name);
            info.setClassName(object.getClass().getName());
            info.setIsProxy(Boolean.valueOf(Proxy.isProxyClass(object.getClass())));
            info.setIsReconfigure(Boolean.valueOf(object instanceof BeanConfigure));
            info.setIsReloadable(Boolean.valueOf(object instanceof BeanReload));
            infos.add(info);
        }
        return infos;
    }

    static <T extends Annotation> T getAnnotation(Class<T> type, HandlerMethod handlerMethod) {
        T annotation = null;
        if (handlerMethod != null && (annotation = (T)handlerMethod.getMethod().getAnnotation(type)) == null && (annotation = (T)handlerMethod.getBeanType().getAnnotation(type)) == null) {
            annotation = handlerMethod.getMethod().getDeclaringClass().getAnnotation(type);
        }
        return annotation;
    }

    private static <T> Class<T> getClass(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Method getMethod(String classname, String methodname, Class<?> ... parameterTypes) {
        return FrameworkUtil0.getMethod(FrameworkUtil0.getClass(classname), methodname, parameterTypes);
    }

    private static Method getMethod(Class<?> clazz, String methodname, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodname, parameterTypes);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object invoke(Object object, Method method, Object ... arguments) {
        try {
            return method.invoke(object, arguments);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Set<String> getHibernateKeys0(String classname) {
        HashSet<String> keys = new HashSet<String>();
        try {
            Class<?> clazz = Class.forName(classname);
            for (Field field : clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                field.setAccessible(true);
                String key = String.valueOf(field.get(null));
                if (!key.startsWith("hibernate.")) continue;
                keys.add(key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keys;
    }

    static {
        LinkedHashSet<String> hibernateKeys0 = new LinkedHashSet<String>();
        for (String classname : hibernateClasses) {
            Set<String> keys = FrameworkUtil0.getHibernateKeys0(classname);
            hibernateKeys0.addAll(keys);
        }
        hibernateKeys = hibernateKeys0;
        reactiveGenericClass = FrameworkUtil0.getClass("org.springframework.boot.web.reactive.context.GenericReactiveWebApplicationContext");
        reactiveWebServerMethod = FrameworkUtil0.getMethod("org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext", "getWebServer", new Class[0]);
        servletWebServerMethod = FrameworkUtil0.getMethod("org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext", "getWebServer", new Class[0]);
    }
}

