/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Public;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.MethodInfo;
import net.ideahut.springboot.object.RequestInfo;
import net.ideahut.springboot.object.Result;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.StringUtil;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMessage;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.result.condition.ConsumesRequestCondition;
import org.springframework.web.reactive.result.condition.PatternsRequestCondition;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.publisher.Mono;

public final class WebFluxUtil {
    private static final String SHARE_ALGORITHM = "sha256";

    private WebFluxUtil() {
    }

    public static Mono<Void> sendToClient(DataMapper dataMapper, ServerWebExchange exchange, Object object) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        byte[] data = null;
        if (object instanceof byte[]) {
            data = (byte[])object;
        } else {
            Long start;
            if (object instanceof Result && (start = Share.getStart((HttpMessage)exchange.getResponse())) != null) {
                ((Result)object).updateTime(Long.valueOf(System.nanoTime() - start));
            }
            String accept = WebFluxUtil.getHeader((HttpMessage)request, "Accept", "");
            int mapperType = 1;
            String contentType = "application/json";
            if (accept.indexOf("xml") != -1) {
                mapperType = 2;
                contentType = "application/xml";
            }
            data = dataMapper.writeAsBytes(object, mapperType);
            response.getHeaders().set("Content-Type", contentType);
        }
        DataBuffer buffer = response.bufferFactory().wrap(data);
        Share.clear((HttpMessage)exchange.getResponse());
        return response.writeAndFlushWith((Publisher)Mono.just((Object)Mono.just((Object)buffer)));
    }

    public static List<RequestInfo> getRequestInfos(RequestMappingHandlerMapping mapping, boolean includeEmptyMethod) {
        ArrayList<RequestInfo> infos = new ArrayList<RequestInfo>();
        Map map = mapping.getHandlerMethods();
        for (Map.Entry entry : map.entrySet()) {
            RequestMappingInfo rmi = (RequestMappingInfo)entry.getKey();
            if (!includeEmptyMethod && rmi.getMethodsCondition().getMethods().isEmpty()) continue;
            HandlerMethod hm = (HandlerMethod)entry.getValue();
            RequestInfo.Handler handler = new RequestInfo.Handler();
            handler.setBean(hm.getBeanType().getName());
            handler.setMethod(MethodInfo.of((Method)hm.getMethod()));
            ConsumesRequestCondition crc = rmi.getConsumesCondition();
            RequestInfo info = new RequestInfo();
            info.setBodyRequired(crc.isBodyRequired());
            info.setConsumableMediaTypes(crc.getConsumableMediaTypes());
            info.setDirectPaths(rmi.getDirectPaths());
            info.setHandler(handler);
            info.setMethods(rmi.getMethodsCondition().getMethods());
            info.setName(rmi.getName());
            info.setPatternValues(new LinkedHashSet<String>());
            PatternsRequestCondition prc = rmi.getPatternsCondition();
            for (PathPattern pp : prc.getPatterns()) {
                info.getPatternValues().add(pp.getPatternString());
            }
            info.setProducibleMediaTypes(rmi.getProducesCondition().getProducibleMediaTypes());
            Public anPublic = FrameworkUtil.getAnnotation(Public.class, hm);
            info.setPublic(anPublic != null && anPublic.value());
            ApiExclude anExclude = FrameworkUtil.getAnnotation(ApiExclude.class, hm);
            info.setExclude(anExclude != null && anExclude.value());
            infos.add(info);
        }
        return infos;
    }

    public static List<RequestInfo> getRequestInfos(ApplicationContext applicationContext, boolean includeEmptyMethod) {
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)applicationContext.getBean(RequestMappingHandlerMapping.class);
        return WebFluxUtil.getRequestInfos(mapping, includeEmptyMethod);
    }

    public static Map<String, List<String>> getRequestParameters(ServerHttpRequest request) {
        MultiValueMap mvm = request.getQueryParams();
        return new LinkedHashMap<String, List<String>>((Map<String, List<String>>)mvm);
    }

    public static String getHeader(HttpMessage message, String name, String defaultValue) {
        HttpHeaders headers = message.getHeaders();
        String value = headers.getFirst(name);
        if (value == null && (value = headers.getFirst(name.toLowerCase())) == null) {
            value = headers.getFirst(name.toUpperCase());
        }
        return value != null ? value : defaultValue;
    }

    public static String getHeader(HttpMessage message, String name) {
        return WebFluxUtil.getHeader(message, name, null);
    }

    public static <T> T getHeader(Class<T> type, HttpMessage message, String name, T defaultValue) {
        String value = WebFluxUtil.getHeader(message, name);
        return (T)StringUtil.valueOf(type, (String)value, defaultValue);
    }

    public static <T> T getHeader(Class<T> type, HttpMessage message, String name) {
        return WebFluxUtil.getHeader(type, message, name, null);
    }

    public static String[] getHeaders(HttpMessage message, String name) {
        HttpHeaders headers = message.getHeaders();
        List values = headers.get((Object)name);
        if (values == null && (values = headers.get((Object)name.toLowerCase())) == null) {
            values = headers.get((Object)name.toUpperCase());
        }
        return values != null ? values.toArray(new String[0]) : null;
    }

    public static String getRemoteHost(ServerHttpRequest request) {
        String host = WebFluxUtil.getHeader((HttpMessage)request, "X-Forwarded-For", "").trim();
        if (host.isEmpty()) {
            InetSocketAddress address = request.getRemoteAddress();
            host = address != null ? address.getAddress().getHostAddress() : "";
        }
        host = host.split("\\,")[0].trim();
        return host;
    }

    public static String getUserAgent(ServerHttpRequest request) {
        return WebFluxUtil.getHeader((HttpMessage)request, "User-Agent", "");
    }

    public static <T> T getContent(Mono<T> mono) {
        try {
            return mono.toFuture().get();
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    public static byte[] getDataBufferAsBytes(DataBuffer dataBuffer) {
        byte[] bytes = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(bytes);
        DataBufferUtils.release((DataBuffer)dataBuffer);
        return bytes;
    }

    public static final class Share {
        private static final String START = FrameworkUtil.digest("sha256", "" + System.nanoTime());
        private static final String REACTIVE = FrameworkUtil.digest("sha256", "" + System.nanoTime());
        private static final String LANGUAGE = FrameworkUtil.digest("sha256", "" + System.nanoTime());

        private Share() {
        }

        public static void setStart(HttpMessage message, Long startTime) {
            HttpHeaders headers = message.getHeaders();
            if (!headers.containsKey((Object)START)) {
                headers.set(START, "" + startTime);
            }
        }

        public static void setReactive(HttpMessage message, boolean isReactive) {
            HttpHeaders headers = message.getHeaders();
            if (!headers.containsKey((Object)REACTIVE)) {
                headers.set(REACTIVE, "" + isReactive);
            }
        }

        public static void setLanguage(HttpMessage message, String language) {
            HttpHeaders headers = message.getHeaders();
            if (!headers.containsKey((Object)LANGUAGE)) {
                headers.set(LANGUAGE, language);
            }
        }

        public static void setLanguage(ServerWebExchange exchange) {
            String language = WebFluxUtil.getHeader((HttpMessage)exchange.getRequest(), "Accept-Language", "");
            Share.setLanguage((HttpMessage)exchange.getResponse(), language);
        }

        public static void clear(HttpMessage message) {
            HttpHeaders headers = message.getHeaders();
            headers.remove((Object)START);
            headers.remove((Object)REACTIVE);
            headers.remove((Object)LANGUAGE);
        }

        public static Long getStart(HttpMessage message) {
            return WebFluxUtil.getHeader(Long.class, message, START);
        }

        public static boolean isReactive(HttpMessage message) {
            return WebFluxUtil.getHeader(Boolean.TYPE, message, REACTIVE, false);
        }

        public static String getLanguage(HttpMessage message) {
            return WebFluxUtil.getHeader(message, LANGUAGE);
        }
    }
}

