/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.annotation.Public;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.MethodInfo;
import net.ideahut.springboot.object.RequestInfo;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.StringUtil;
import org.apache.commons.io.IOUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.ConsumesRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public final class WebMvcUtil {
    private WebMvcUtil() {
    }

    public static void sendToClient(DataMapper dataMapper, HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        byte[] data = null;
        if (object instanceof byte[]) {
            data = (byte[])object;
        } else {
            String accept = WebMvcUtil.getHeader(request, "Accept", "");
            int mapperType = 1;
            String contentType = "application/json";
            if (accept.indexOf("xml") != -1) {
                mapperType = 2;
                contentType = "application/xml";
            }
            data = dataMapper.writeAsBytes(object, mapperType);
            response.setHeader("Content-Type", contentType);
        }
        response.getOutputStream().write(data);
    }

    public static List<RequestInfo> getRequestInfos(RequestMappingHandlerMapping mapping, boolean includeEmptyMethod) {
        ArrayList<RequestInfo> infos = new ArrayList<RequestInfo>();
        Map map = mapping.getHandlerMethods();
        for (Map.Entry entry : map.entrySet()) {
            RequestMappingInfo rmi = (RequestMappingInfo)entry.getKey();
            if (!includeEmptyMethod && rmi.getMethodsCondition().getMethods().isEmpty()) continue;
            HandlerMethod hm = (HandlerMethod)entry.getValue();
            RequestInfo.Handler handler = new RequestInfo.Handler();
            handler.setBean(hm.getBeanType().getName());
            handler.setMethod(MethodInfo.of((Method)hm.getMethod()));
            ConsumesRequestCondition crc = rmi.getConsumesCondition();
            RequestInfo info = new RequestInfo();
            info.setBodyRequired(crc.isBodyRequired());
            info.setConsumableMediaTypes(crc.getConsumableMediaTypes());
            info.setDirectPaths(rmi.getDirectPaths());
            info.setHandler(handler);
            info.setMethods(rmi.getMethodsCondition().getMethods());
            info.setName(rmi.getName());
            info.setPatternValues(rmi.getPatternValues());
            info.setProducibleMediaTypes(rmi.getProducesCondition().getProducibleMediaTypes());
            Public anPublic = FrameworkUtil.getAnnotation(Public.class, hm);
            info.setPublic(anPublic != null && anPublic.value());
            ApiExclude anExclude = FrameworkUtil.getAnnotation(ApiExclude.class, hm);
            info.setExclude(anExclude != null && anExclude.value());
            infos.add(info);
        }
        return infos;
    }

    public static List<RequestInfo> getRequestInfos(ApplicationContext applicationContext, boolean includeEmptyMethod) {
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)applicationContext.getBean(RequestMappingHandlerMapping.class);
        return WebMvcUtil.getRequestInfos(mapping, includeEmptyMethod);
    }

    public static Map<String, List<String>> getRequestParameters(HttpServletRequest request) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String[] values = request.getParameterValues(name);
            map.put(name, new ArrayList<String>(Arrays.asList(values)));
        }
        return map;
    }

    public static String getHeader(HttpServletRequest request, String name, String defaultValue) {
        String value = request.getHeader(name);
        if (value == null && (value = request.getHeader(name.toLowerCase())) == null) {
            value = request.getHeader(name.toUpperCase());
        }
        return value != null ? value : defaultValue;
    }

    public static String getHeader(HttpServletRequest request, String name) {
        return WebMvcUtil.getHeader(request, name, null);
    }

    public static <T> T getHeader(Class<T> type, HttpServletRequest request, String name, T defaultValue) {
        String value = WebMvcUtil.getHeader(request, name);
        return (T)StringUtil.valueOf(type, (String)value, defaultValue);
    }

    public static <T> T getHeader(Class<T> type, HttpServletRequest request, String name) {
        return WebMvcUtil.getHeader(type, request, name, null);
    }

    public static String[] getHeaders(HttpServletRequest request, String name) {
        Enumeration values = request.getHeaders(name);
        if (values == null && (values = request.getHeaders(name.toLowerCase())) == null) {
            values = request.getHeaders(name.toUpperCase());
        }
        return values != null ? Collections.list(values).toArray(new String[0]) : null;
    }

    public static String getRemoteHost(HttpServletRequest request) {
        String host = WebMvcUtil.getHeader(request, "X-Forwarded-For", "").trim();
        if (host.isEmpty()) {
            host = request.getRemoteAddr();
        }
        host = host.split("\\,")[0].trim();
        return host;
    }

    public static String getUserAgent(HttpServletRequest request) {
        return WebMvcUtil.getHeader(request, "User-Agent", "");
    }

    public static byte[] getBodyAsBytes(HttpServletRequest request) throws IOException {
        ServletInputStream stream = request.getInputStream();
        return IOUtils.toByteArray((InputStream)stream);
    }

    public static HttpServletRequest getRequest() {
        HttpServletRequest request = RequestContext.currentContext().getRequest();
        if (request == null) {
            RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
            request = attributes != null ? ((ServletRequestAttributes)attributes).getRequest() : null;
        }
        return request;
    }
}

