/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.io.Serializable;
import net.ideahut.springboot.api.ApiRequest;
import net.ideahut.springboot.object.MapStringObject;

public class ApiParameter
implements Serializable {
    private static final long serialVersionUID = -6811110135362660687L;
    private String apiKey;
    private String apiName;
    private String apiType;
    private String scheme;
    private String content;
    private String internalId;
    private ApiRequest apiRequest;
    private transient MapStringObject attributes;

    public ApiParameter setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public ApiParameter setApiName(String apiName) {
        this.apiName = apiName;
        return this;
    }

    public ApiParameter setApiType(String apiType) {
        this.apiType = apiType;
        return this;
    }

    public ApiParameter setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public ApiParameter setContent(String content) {
        this.content = content;
        return this;
    }

    public ApiParameter setInternalId(String internalId) {
        this.internalId = internalId;
        return this;
    }

    public ApiParameter setApiRequest(ApiRequest apiRequest) {
        this.apiRequest = apiRequest;
        return this;
    }

    public <T> ApiParameter setAttribute(String name, T value) {
        if (name != null) {
            if (this.attributes == null) {
                this.attributes = new MapStringObject();
            }
            this.attributes.put(name, value);
        }
        return this;
    }

    public <T> T getAttribute(String name, T defaultValue) {
        if (this.attributes != null) {
            Object value = this.attributes.get(name);
            return (T)(value != null ? value : defaultValue);
        }
        return defaultValue;
    }

    public <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public void removeAttribute(String ... names) {
        if (this.attributes != null && names != null && names.length != 0) {
            for (String name : names) {
                this.attributes.remove(name);
            }
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getApiType() {
        return this.apiType;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getContent() {
        return this.content;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public ApiRequest getApiRequest() {
        return this.apiRequest;
    }
}

