/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.util.StringUtil;

public class ApiRequest
implements Serializable {
    private static final long serialVersionUID = -6567574419756717837L;
    private String path;
    private Map<String, List<String>> headers;
    private String remoteHost;
    private String userAgent;
    private boolean publicMapping;
    private transient MapStringObject attributes;

    public ApiRequest setPath(String path) {
        this.path = path;
        return this;
    }

    public ApiRequest setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
        return this;
    }

    public ApiRequest setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
        return this;
    }

    public ApiRequest setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public ApiRequest setPublicMapping(boolean publicMapping) {
        this.publicMapping = publicMapping;
        return this;
    }

    public <T> ApiRequest setAttribute(String name, T value) {
        if (name != null) {
            if (this.attributes == null) {
                this.attributes = new MapStringObject();
            }
            this.attributes.put(name, value);
        }
        return this;
    }

    public <T> T getAttribute(String name, T defaultValue) {
        if (this.attributes != null) {
            Object value = this.attributes.get(name);
            return (T)(value != null ? value : defaultValue);
        }
        return defaultValue;
    }

    public <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public void removeAttribute(String ... names) {
        if (this.attributes != null && names != null && names.length != 0) {
            for (String name : names) {
                this.attributes.remove(name);
            }
        }
    }

    public String getHeader(String name, String defaultValue) {
        if (this.headers != null) {
            List<String> values = this.headers.get(name.toLowerCase());
            if (values == null && (values = this.headers.get(name)) == null) {
                values = this.headers.get(name.toUpperCase());
            }
            return values != null && !values.isEmpty() ? values.get(0) : defaultValue;
        }
        return defaultValue;
    }

    public String getHeader(String name) {
        return this.getHeader(name, null);
    }

    public <T> T getHeader(Class<T> type, String name, T defaultValue) {
        String value = this.getHeader(name);
        return StringUtil.valueOf(type, value, defaultValue);
    }

    public <T> T getHeader(Class<T> type, String name) {
        return this.getHeader(type, name, null);
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isPublicMapping() {
        return this.publicMapping;
    }
}

