/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.audit;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ideahut.springboot.context.RequestContext;

public class AuditInfo
implements Serializable {
    private static final long serialVersionUID = 7282772610580939787L;
    private static final String CONTEXT = AuditInfo.class.getName() + "_CONTEXT";
    private String auditor;
    private String info;
    private String type;
    private Boolean skip;
    private String id;
    private Map<Class<?>, Integer> replica;

    public AuditInfo() {
    }

    public AuditInfo(String auditor) {
        this(auditor, null);
    }

    public AuditInfo(String auditor, String info) {
        this.auditor = auditor;
        this.info = info;
    }

    public AuditInfo setAuditor(String auditor) {
        this.auditor = auditor;
        return this;
    }

    public AuditInfo setInfo(String info) {
        this.info = info;
        return this;
    }

    public AuditInfo setType(String type) {
        this.type = type;
        return this;
    }

    public AuditInfo setSkip(Boolean skip) {
        this.skip = skip;
        return this;
    }

    public AuditInfo setId(String id) {
        this.id = id;
        return this;
    }

    public AuditInfo setReplica(Class<?> entityClass, Integer replica) {
        if (this.replica == null) {
            this.replica = new LinkedHashMap();
        }
        this.replica.put(entityClass, replica);
        return this;
    }

    public Integer getReplica(Class<?> entityClass) {
        return this.replica != null ? this.replica.get(entityClass) : null;
    }

    public static AuditInfo context() {
        AuditInfo auditInfo = (AuditInfo)RequestContext.currentContext().getAttribute(CONTEXT);
        if (auditInfo == null) {
            auditInfo = new AuditInfo();
            RequestContext.currentContext().setAttribute(CONTEXT, auditInfo);
        }
        return auditInfo;
    }

    public String getAuditor() {
        return this.auditor;
    }

    public String getInfo() {
        return this.info;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getSkip() {
        return this.skip;
    }

    public String getId() {
        return this.id;
    }

    public Map<Class<?>, Integer> getReplica() {
        return this.replica;
    }
}

