/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.compiler;

import java.util.Map;
import java.util.Objects;
import net.ideahut.springboot.compiler.InMemoryFileManager;
import net.ideahut.springboot.compiler.JavaClassAsBytes;

public class InMemoryClassLoader
extends ClassLoader {
    private final InMemoryFileManager manager;

    public InMemoryClassLoader(ClassLoader parent, InMemoryFileManager manager) {
        super(parent);
        this.manager = Objects.requireNonNull(manager, "manager must not be null");
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Map<String, JavaClassAsBytes> compiledClasses = this.manager.getBytesMap();
        if (compiledClasses.containsKey(name)) {
            byte[] bytes = compiledClasses.get(name).getBytes();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        throw new ClassNotFoundException();
    }
}

