/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.compiler;

import java.util.Hashtable;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import net.ideahut.springboot.compiler.InMemoryClassLoader;
import net.ideahut.springboot.compiler.JavaClassAsBytes;

public class InMemoryFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final Map<String, JavaClassAsBytes> compiledClasses = new Hashtable<String, JavaClassAsBytes>();
    private final ClassLoader loader = new InMemoryClassLoader(this.getClass().getClassLoader(), this);

    public InMemoryFileManager(StandardJavaFileManager standardManager) {
        super(standardManager);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.loader;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
        JavaClassAsBytes classAsBytes = new JavaClassAsBytes(className, kind);
        this.compiledClasses.put(className, classAsBytes);
        return classAsBytes;
    }

    public Map<String, JavaClassAsBytes> getBytesMap() {
        return this.compiledClasses;
    }
}

