/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.context;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Set;
import net.ideahut.springboot.object.MapStringObject;

public final class RequestContext {
    private static final ThreadLocal<RequestContext> holder = new InheritableThreadLocal<RequestContext>();
    private static final ThreadLocal<Long> start = new InheritableThreadLocal<Long>();
    private final Long id;
    private final MapStringObject attributes = new MapStringObject();
    private HttpServletRequest request;
    private HttpServletResponse response;

    public static RequestContext currentContext() {
        RequestContext context = holder.get();
        if (context == null) {
            context = new RequestContext();
            holder.set(context);
        }
        return context;
    }

    public static void start() {
        if (start.get() == null) {
            start.set(System.nanoTime());
        }
    }

    public static Long time() {
        Long begin = start.get();
        if (begin != null) {
            return System.nanoTime() - begin;
        }
        return null;
    }

    public static void destroy() {
        holder.remove();
        start.remove();
    }

    private RequestContext() {
        this.id = System.nanoTime();
    }

    public Long getId() {
        return this.id;
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public <T> T getAttribute(String name, T defaultValue) {
        Object t = this.attributes.get(name);
        return (T)(t != null ? t : defaultValue);
    }

    public <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public <T> RequestContext setAttribute(String name, T value) {
        this.attributes.put(name, value);
        return this;
    }

    public <T> T removeAttribute(String name) {
        return (T)this.attributes.remove(name);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public static void setRequest(HttpServletRequest request) {
        RequestContext context = RequestContext.currentContext();
        context.request = request;
    }

    public static void setResponse(HttpServletResponse response) {
        RequestContext context = RequestContext.currentContext();
        context.response = response;
    }
}

