/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum Condition {
    ANY_LIKE(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " lower(" + name + ") like ?" + (index + 1), "%" + ("" + values[0]).toLowerCase() + "%");
        }
    }),
    ANY_START(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " lower(" + name + ") like ?" + (index + 1), ("" + values[0]).toLowerCase() + "%");
        }
    }),
    ANY_END(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " lower(" + name + ") like ?" + (index + 1), "%" + ("" + values[0]).toLowerCase());
        }
    }),
    ANY_EQUAL(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " lower(" + name + ") = ?" + (index + 1), ("" + values[0]).toLowerCase());
        }
    }),
    LIKE(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + " like ?" + (index + 1), values[0]);
        }
    }),
    START(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + " like ?" + (index + 1), values[0] + "%");
        }
    }),
    END(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + " like ?" + (index + 1), "%" + values[0]);
        }
    }),
    NOT_ANY_LIKE(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " lower(" + name + ") not like ?" + (index + 1), "%" + ("" + values[0]).toLowerCase() + "%");
        }
    }),
    NOT_ANY_START(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " lower(" + name + ") not like ?" + (index + 1), ("" + values[0]).toLowerCase() + "%");
        }
    }),
    NOT_ANY_END(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " lower(" + name + ") not like ?" + (index + 1), "%" + ("" + values[0]).toLowerCase());
        }
    }),
    NOT_ANY_EQUAL(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " lower(" + name + ") != ?" + (index + 1), ("" + values[0]).toLowerCase());
        }
    }),
    NOT_LIKE(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + " not like ?" + (index + 1), values[0]);
        }
    }),
    NOT_START(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + " not like ?" + (index + 1), values[0] + "%");
        }
    }),
    NOT_END(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + " not like ?" + (index + 1), "%" + values[0]);
        }
    }),
    NOT_EQUAL(true, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + " != ?" + (index + 1), values[0]);
        }
    }),
    BETWEEN(true, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            if (values.length != 2) {
                throw new RuntimeException("Invalid 'BETWEEN' value");
            }
            return QueryParameters.of(logic + " " + name + " between ?" + (index + 1) + " and ?" + (index + 2), values[0], values[1]);
        }
    }),
    NOT_NULL(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + " is not null", new Object[0]);
        }
    }),
    IS_NULL(false, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + " is null", new Object[0]);
        }
    }),
    GREATER_THAN(true, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + " > ?" + (index + 1), values[0]);
        }
    }),
    GREATER_EQUAL(true, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + " >= ?" + (index + 1), values[0]);
        }
    }),
    LESS_THAN(true, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + " < ?" + (index + 1), values[0]);
        }
    }),
    LESS_EQUAL(true, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + " <= ?" + (index + 1), values[0]);
        }
    }),
    IN(true, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            if (values.length == 0) {
                throw new RuntimeException("Invalid 'IN' value");
            }
            if (isNative) {
                Object query = logic + " (" + name + " in (";
                for (int i = 0; i < values.length; ++i) {
                    query = (String)query + "?" + (index + 1 + i) + ",";
                }
                query = ((String)query).substring(0, ((String)query).length() - 1);
                query = (String)query + "))";
                return QueryParameters.of((String)query, values);
            }
            return QueryParameters.of(logic + " " + name + " in (?" + (index + 1) + ")", values);
        }
    }),
    NOT_IN(true, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            if (values.length == 0) {
                throw new RuntimeException("Invalid 'NOT_IN' value");
            }
            if (isNative) {
                Object query = logic + " (" + name + " not in (";
                for (int i = 0; i < values.length; ++i) {
                    query = (String)query + "?" + (index + 1 + i) + ",";
                }
                query = ((String)query).substring(0, ((String)query).length() - 1);
                query = (String)query + "))";
                return QueryParameters.of((String)query, values);
            }
            return QueryParameters.of(logic + " " + name + " not in (?" + (index + 1) + ")", values);
        }
    }),
    EQUAL(true, new Builder(){

        @Override
        public QueryParameters build(boolean isNative, String logic, int index, String name, Object ... values) {
            return QueryParameters.of(logic + " " + name + "=?" + (index + 1), values[0]);
        }
    });

    private final boolean convert;
    private final Builder builder;

    private Condition(boolean convert, Builder builder) {
        this.convert = convert;
        this.builder = builder;
    }

    public boolean isConvert() {
        return this.convert;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public static Condition of(String value, Condition defaultValue) {
        try {
            return Condition.valueOf(value.toUpperCase());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static Condition of(String value) {
        return Condition.of(value, null);
    }

    public static interface Builder {
        public QueryParameters build(boolean var1, String var2, int var3, String var4, Object ... var5);
    }

    public static class QueryParameters {
        private String query;
        private List<Object> parameters;

        protected QueryParameters() {
        }

        private QueryParameters(String query, List<Object> parameters) {
            this.query = query != null ? query : "";
            this.parameters = parameters != null ? new ArrayList<Object>(parameters) : new ArrayList();
        }

        public static QueryParameters of(String query, List<Object> parameters) {
            return new QueryParameters(query, parameters);
        }

        public static QueryParameters of(String query, Object ... parameters) {
            ArrayList<Object> list = parameters != null ? new ArrayList<Object>(Arrays.asList(parameters)) : new ArrayList();
            return QueryParameters.of(query, list);
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public void setParameters(List<Object> parameters) {
            this.parameters = parameters;
        }

        public String getQuery() {
            return this.query;
        }

        public List<Object> getParameters() {
            return this.parameters;
        }
    }
}

