/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.job.dto;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ideahut.springboot.annotation.CompareIgnore;
import net.ideahut.springboot.job.dto.JobGroupDto;
import net.ideahut.springboot.job.dto.JobTypeDto;
import net.ideahut.springboot.job.dto.TriggerStatus;
import net.ideahut.springboot.util.StringUtil;

public class JobTriggerDto
implements Serializable {
    private static final long serialVersionUID = -7658532182671272092L;
    private String triggerId;
    private String groupId;
    private String typeId;
    private String instanceId;
    private String name;
    private String description;
    private String cronExpression;
    private Integer zoneOffsetSeconds;
    private Character isRunOnStartup;
    private Character isActive;
    private Character isSaveResult;
    private Long lastRunTime;
    private String lastRunData;
    @CompareIgnore
    private JobGroupDto group;
    @CompareIgnore
    private JobTypeDto type;
    @CompareIgnore
    private TriggerStatus status;
    @CompareIgnore
    private Map<String, String> config;

    public JobTriggerDto setTriggerId(String triggerId) {
        this.triggerId = triggerId;
        return this;
    }

    public JobTriggerDto setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public JobTriggerDto setTypeId(String typeId) {
        this.typeId = typeId;
        return this;
    }

    public JobTriggerDto setInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public JobTriggerDto setName(String name) {
        this.name = name;
        return this;
    }

    public JobTriggerDto setDescription(String description) {
        this.description = description;
        return this;
    }

    public JobTriggerDto setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
        return this;
    }

    public JobTriggerDto setZoneOffsetSeconds(Integer zoneOffsetSeconds) {
        this.zoneOffsetSeconds = zoneOffsetSeconds;
        return this;
    }

    public JobTriggerDto setIsRunOnStartup(Character isRunOnStartup) {
        this.isRunOnStartup = isRunOnStartup;
        return this;
    }

    public JobTriggerDto setIsActive(Character isActive) {
        this.isActive = isActive;
        return this;
    }

    public JobTriggerDto setIsSaveResult(Character isSaveResult) {
        this.isSaveResult = isSaveResult;
        return this;
    }

    public JobTriggerDto setLastRunTime(Long lastRunTime) {
        this.lastRunTime = lastRunTime;
        return this;
    }

    public JobTriggerDto setLastRunData(String lastRunData) {
        this.lastRunData = lastRunData;
        return this;
    }

    public JobTriggerDto setGroup(JobGroupDto group) {
        this.group = group;
        return this;
    }

    public JobTriggerDto setType(JobTypeDto type) {
        this.type = type;
        return this;
    }

    public JobTriggerDto setStatus(TriggerStatus status) {
        this.status = status;
        return this;
    }

    public JobTriggerDto setConfig(Map<String, String> config) {
        this.config = config;
        return this;
    }

    public JobTriggerDto setConfig(String name, String value) {
        if (name != null) {
            if (this.config == null) {
                this.config = new LinkedHashMap<String, String>();
            }
            this.config.put(name, value);
        }
        return this;
    }

    public <T> T getConfig(Class<T> type, String name, T defaultValue) {
        String value = this.config != null ? this.config.get(name) : null;
        return StringUtil.valueOf(type, value, defaultValue);
    }

    public <T> T getConfig(Class<T> type, String name) {
        return this.getConfig(type, name, null);
    }

    public String getConfig(String name, String defaultValue) {
        return this.getConfig(String.class, name, defaultValue);
    }

    public String getConfig(String name) {
        return this.getConfig(name, null);
    }

    public static JobTriggerDto create() {
        return new JobTriggerDto();
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public Integer getZoneOffsetSeconds() {
        return this.zoneOffsetSeconds;
    }

    public Character getIsRunOnStartup() {
        return this.isRunOnStartup;
    }

    public Character getIsActive() {
        return this.isActive;
    }

    public Character getIsSaveResult() {
        return this.isSaveResult;
    }

    public Long getLastRunTime() {
        return this.lastRunTime;
    }

    public String getLastRunData() {
        return this.lastRunData;
    }

    public JobGroupDto getGroup() {
        return this.group;
    }

    public JobTypeDto getType() {
        return this.type;
    }

    public TriggerStatus getStatus() {
        return this.status;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }
}

