/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.object;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.ideahut.springboot.object.KeyValue;
import net.ideahut.springboot.object.ParameterInfo;

public class MethodInfo
implements Serializable {
    private static final long serialVersionUID = -4607271279483325357L;
    private List<KeyValue<String, String>> annotations;
    private String declaringClass;
    private String defaultValue;
    private List<String> exceptionTypes;
    private List<String> genericExceptionTypes;
    private List<String> genericParameterTypes;
    private String genericReturnType;
    private int modifiers;
    private String name;
    private int parameterCount;
    private List<ParameterInfo> parameters;
    private String returnType;

    public static MethodInfo of(Method method) {
        MethodInfo info = new MethodInfo();
        info.annotations = new ArrayList<KeyValue<String, String>>();
        for (Annotation annotation : method.getAnnotations()) {
            KeyValue<String, String> nv = new KeyValue<String, String>(annotation.annotationType().getName(), annotation.toString());
            info.annotations.add(nv);
        }
        info.declaringClass = method.getDeclaringClass().getName();
        info.defaultValue = method.getDefaultValue() != null ? method.getDefaultValue().toString() : null;
        info.exceptionTypes = new ArrayList<String>();
        for (Class<?> clazz : method.getExceptionTypes()) {
            info.exceptionTypes.add(clazz.getName());
        }
        info.genericExceptionTypes = new ArrayList<String>();
        for (Type type : method.getGenericExceptionTypes()) {
            info.genericExceptionTypes.add(type.getTypeName());
        }
        info.genericParameterTypes = new ArrayList<String>();
        for (Type type : method.getGenericParameterTypes()) {
            info.genericParameterTypes.add(type.getTypeName());
        }
        info.genericReturnType = method.getGenericReturnType().getTypeName();
        info.modifiers = method.getModifiers();
        info.name = method.getName();
        info.parameterCount = method.getParameterCount();
        info.parameters = new ArrayList<ParameterInfo>();
        for (Parameter parameter : method.getParameters()) {
            info.parameters.add(ParameterInfo.of(parameter));
        }
        info.returnType = method.getReturnType().getName();
        return info;
    }

    public List<KeyValue<String, String>> getAnnotations() {
        return this.annotations;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public List<String> getExceptionTypes() {
        return this.exceptionTypes;
    }

    public List<String> getGenericExceptionTypes() {
        return this.genericExceptionTypes;
    }

    public List<String> getGenericParameterTypes() {
        return this.genericParameterTypes;
    }

    public String getGenericReturnType() {
        return this.genericReturnType;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setAnnotations(List<KeyValue<String, String>> annotations) {
        this.annotations = annotations;
    }

    public void setDeclaringClass(String declaringClass) {
        this.declaringClass = declaringClass;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setExceptionTypes(List<String> exceptionTypes) {
        this.exceptionTypes = exceptionTypes;
    }

    public void setGenericExceptionTypes(List<String> genericExceptionTypes) {
        this.genericExceptionTypes = genericExceptionTypes;
    }

    public void setGenericParameterTypes(List<String> genericParameterTypes) {
        this.genericParameterTypes = genericParameterTypes;
    }

    public void setGenericReturnType(String genericReturnType) {
        this.genericReturnType = genericReturnType;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameterCount(int parameterCount) {
        this.parameterCount = parameterCount;
    }

    public void setParameters(List<ParameterInfo> parameters) {
        this.parameters = parameters;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }
}

