/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.object;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.object.Filepart;

public class Multipart
implements Serializable {
    private static final long serialVersionUID = 5716720042051222738L;
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private Map<String, Set<Integer>> filePartIndex = new HashMap<String, Set<Integer>>();
    private List<Filepart> filePartList = new ArrayList<Filepart>();

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public void addParameterValue(String key, String value) {
        ArrayList<String> l = this.parameters.getOrDefault(key, null);
        if (l == null) {
            l = new ArrayList<String>();
            this.parameters.put(key, l);
        }
        l.add(value);
    }

    public String removeParameterValue(String key, String defaultValue) {
        String[] p = this.removeParameterValues(key);
        return p != null && p.length > 0 ? p[0] : defaultValue;
    }

    public String removeParameterValue(String key) {
        return this.removeParameterValue(key, null);
    }

    public String getParameterValue(String key, String defaultValue) {
        String[] p = this.getParameterValues(key);
        return p != null && p.length > 0 ? p[0] : defaultValue;
    }

    public String getParameterValue(String key) {
        return this.getParameterValue(key, null);
    }

    public String[] getParameterValues(String key) {
        List<String> l = this.parameters.get(key);
        if (l != null) {
            return l.toArray(new String[0]);
        }
        return new String[0];
    }

    public String[] removeParameterValues(String key) {
        List<String> l = this.parameters.remove(key);
        if (l != null) {
            return l.toArray(new String[0]);
        }
        return new String[0];
    }

    public Map<String, String[]> getParameters() {
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        for (String key : this.parameters.keySet()) {
            m.put(key, this.getParameterValues(key));
        }
        return Collections.unmodifiableMap(m);
    }

    public void addFilepart(String key, Filepart filepart) {
        this.filePartList.add(filepart);
        if (key == null || "".equals(key)) {
            return;
        }
        HashSet<Integer> indexSet = this.filePartIndex.getOrDefault(key, null);
        if (indexSet == null) {
            indexSet = new HashSet<Integer>();
            this.filePartIndex.put(key, indexSet);
        }
        indexSet.add(this.filePartList.size() - 1);
    }

    public void removeFilepartValues(String key) {
        Set<Integer> indexSet = this.filePartIndex.get(key);
        if (indexSet == null) {
            return;
        }
        for (int idx : indexSet) {
            this.filePartList.remove(idx);
        }
        this.filePartIndex.remove(key);
    }

    public Filepart[] getFilepartValues(String key) {
        Set<Integer> indexSet = this.filePartIndex.get(key);
        if (indexSet == null) {
            return new Filepart[0];
        }
        Filepart[] fileparts = new Filepart[indexSet.size()];
        for (Integer idx : indexSet) {
            fileparts[fileparts.length - 1] = this.filePartList.get(idx);
        }
        return fileparts;
    }

    public Set<String> getFilepartNames() {
        return this.filePartIndex.keySet();
    }

    public List<Filepart> getFileparts() {
        return Collections.unmodifiableList(this.filePartList);
    }
}

