/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.object;

import java.io.Serializable;
import java.util.List;
import net.ideahut.springboot.object.MapStringObject;

public class Page
implements Serializable {
    private static final long serialVersionUID = -6777969103590595404L;
    public static final Integer DEFAULT_PAGE_SIZE = 20;
    private Integer index;
    private Integer size;
    private Integer total;
    private Long records;
    private transient List<?> data;
    private transient MapStringObject info;
    private Boolean count;

    public Page() {
        this(null, null, null);
    }

    public Page(Integer index) {
        this(index, null, null);
    }

    public Page(Integer index, Integer size) {
        this(index, size, null);
    }

    public Page(Integer index, Integer size, Boolean count) {
        this.index = index != null && index > 0 ? index : 1;
        this.size = size != null && size > 0 ? size : DEFAULT_PAGE_SIZE;
        this.count = count != null ? count : Boolean.FALSE;
    }

    public Page setIndex(Integer index) {
        this.index = index;
        return this;
    }

    public Page setSize(Integer size) {
        this.size = size;
        return this;
    }

    public Page setTotal(Integer total) {
        this.total = total;
        return this;
    }

    public Page setCount(Boolean count) {
        this.count = count;
        return this;
    }

    public Page setRecords(Long records) {
        this.records = records;
        if (records != null && this.size > 0) {
            this.total = (int)Math.ceil((double)records.longValue() / (double)this.size.intValue());
        }
        return this;
    }

    public Page setData(List<?> data) {
        this.data = data;
        return this;
    }

    public Page setInfo(MapStringObject info) {
        this.info = info;
        return this;
    }

    public Page setInfo(String key, Object value) {
        if (this.info == null) {
            this.info = new MapStringObject();
        }
        this.info.put(key, value);
        return this;
    }

    public static Page of(Integer index) {
        return new Page(index, null, null);
    }

    public static Page of(Integer index, Integer size) {
        return new Page(index, size, null);
    }

    public static Page of(Integer index, Integer size, Boolean count) {
        return new Page(index, size, count);
    }

    public static Page empty() {
        return new Page();
    }

    public Integer getIndex() {
        return this.index;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getTotal() {
        return this.total;
    }

    public Long getRecords() {
        return this.records;
    }

    public List<?> getData() {
        return this.data;
    }

    public MapStringObject getInfo() {
        return this.info;
    }

    public Boolean getCount() {
        return this.count;
    }
}

