/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.tag;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlockTag
extends BodyTagSupport {
    private static final long serialVersionUID = -1218514856739999509L;
    private static final String ATTRIBUTE = BlockTag.class.getName();
    private static final String PREFIX = ATTRIBUTE + "_";
    private String name;
    private String target;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String toString() {
        return "BlockTag [name=" + this.name + ", target=" + this.target + "]";
    }

    public int doEndTag() throws JspException {
        BodyContent content = this.getBodyContent();
        if (this.name != null) {
            Map<String, List<String>> map = this.getMap();
            if (!map.containsKey(PREFIX + this.name)) {
                map.put(PREFIX + this.name, new ArrayList());
            }
            try {
                JspWriter out = content != null ? content.getEnclosingWriter() : this.pageContext.getOut();
                out.print("<" + PREFIX + this.name + "/>");
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        }
        if (this.target != null) {
            Map<String, List<String>> map = this.getMap();
            List<String> list = map.get(PREFIX + this.target);
            if (list == null) {
                list = new ArrayList<String>();
                map.put(PREFIX + this.target, list);
            }
            list.add(content.getString());
        } else {
            Map<String, List<String>> map = this.getMap();
            if (!map.isEmpty() && content != null) {
                String text = content.getString();
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    if (entry.getValue() == null) continue;
                    StringBuilder sb = new StringBuilder();
                    for (String str : entry.getValue()) {
                        sb.append("\n").append(str);
                    }
                    text = text.replace("<" + entry.getKey() + "/>", sb.toString());
                }
                try {
                    JspWriter out = content.getEnclosingWriter();
                    out.print(text);
                }
                catch (IOException e) {
                    throw new JspException((Throwable)e);
                }
            }
        }
        return super.doEndTag();
    }

    private Map<String, List<String>> getMap() {
        HashMap map = (HashMap)this.pageContext.getAttribute(ATTRIBUTE);
        if (map == null) {
            map = new HashMap();
            this.pageContext.setAttribute(ATTRIBUTE, map);
        }
        return map;
    }
}

