/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.task;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.ideahut.springboot.task.TaskInput;
import net.ideahut.springboot.task.TaskProcess;
import net.ideahut.springboot.task.TaskResult;

public class TaskListExecutor {
    private final ExecutorService executor;
    private final List<TaskProcess> list = new ArrayList<TaskProcess>();

    private TaskListExecutor(Integer threads) {
        if (threads == null || threads <= 0) {
            throw new IllegalArgumentException("Invalid num of threads: " + threads);
        }
        this.executor = Executors.newFixedThreadPool(threads);
    }

    public static TaskListExecutor of(Integer threads) {
        return new TaskListExecutor(threads);
    }

    public TaskListExecutor add(TaskInput input) {
        this.list.add(TaskProcess.of(this.executor, input));
        return this;
    }

    public TaskListExecutor add(Callable<?> callable) {
        return this.add(TaskInput.of(callable));
    }

    public TaskListExecutor add(List<TaskInput> inputs) {
        if (inputs != null) {
            for (TaskInput input : inputs) {
                this.list.add(TaskProcess.of(this.executor, input));
            }
        }
        return this;
    }

    public void parallel(ParallelListResult parallelListResult) {
        if (this.executor.isShutdown()) {
            throw new RuntimeException("Tasks have been processed");
        }
        int index = 0;
        while (!this.list.isEmpty()) {
            block8: {
                TaskProcess process = this.list.remove(0);
                TaskInput input = process.getInput();
                Future<?> future = process.getFuture();
                if (future == null) {
                    if (parallelListResult != null) {
                        parallelListResult.onParallelListResult(index, TaskResult.of(null));
                    }
                } else {
                    try {
                        Object value = input.getTimeUnit() != null && input.getTimeout() != null ? future.get(input.getTimeout(), input.getTimeUnit()) : future.get();
                        if (parallelListResult != null) {
                            parallelListResult.onParallelListResult(index, TaskResult.of(value));
                        }
                    }
                    catch (Exception e) {
                        if (parallelListResult == null) break block8;
                        parallelListResult.onParallelListResult(index, TaskResult.of(e));
                    }
                }
            }
            ++index;
        }
        this.executor.shutdownNow();
        this.list.clear();
    }

    public List<TaskResult<?>> parallelResult() {
        final ArrayList results = new ArrayList();
        this.parallel(new ParallelListResult(){

            @Override
            public void onParallelListResult(Integer index, TaskResult<?> result) {
                results.add(result);
            }
        });
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concurrent(ConcurrentListResult concurrentListResult) throws Exception {
        if (this.executor.isShutdown()) {
            throw new Exception("Tasks have been processed");
        }
        try {
            int index = 0;
            while (!this.list.isEmpty()) {
                TaskProcess process = this.list.remove(0);
                TaskInput input = process.getInput();
                Future<?> future = process.getFuture();
                if (future == null) {
                    if (concurrentListResult != null) {
                        concurrentListResult.onConcurrentListResult(index, null);
                    }
                } else {
                    Object value = input.getTimeUnit() != null && input.getTimeout() != null ? future.get(input.getTimeout(), input.getTimeUnit()) : future.get();
                    if (concurrentListResult != null) {
                        concurrentListResult.onConcurrentListResult(index, value);
                    }
                }
                ++index;
            }
        }
        finally {
            this.executor.shutdownNow();
            this.list.clear();
        }
    }

    public List<Object> concurrentResult() throws Exception {
        final ArrayList<Object> results = new ArrayList<Object>();
        this.concurrent(new ConcurrentListResult(){

            @Override
            public void onConcurrentListResult(Integer index, Object value) throws Exception {
                results.add(value);
            }
        });
        return results;
    }

    public static interface ParallelListResult {
        public void onParallelListResult(Integer var1, TaskResult<?> var2);
    }

    public static interface ConcurrentListResult {
        public void onConcurrentListResult(Integer var1, Object var2) throws Exception;
    }
}

