/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.task;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.ideahut.springboot.task.TaskInput;
import net.ideahut.springboot.task.TaskProcess;
import net.ideahut.springboot.task.TaskResult;

public class TaskMapExecutor {
    private final ExecutorService executor;
    private final Map<Object, TaskProcess> map = new LinkedHashMap<Object, TaskProcess>();

    private TaskMapExecutor(Integer threads) {
        if (threads == null || threads <= 0) {
            throw new IllegalArgumentException("Invalid num of threads: " + threads);
        }
        this.executor = Executors.newFixedThreadPool(threads);
    }

    public static TaskMapExecutor of(Integer threads) {
        return new TaskMapExecutor(threads);
    }

    public TaskMapExecutor put(Object key, TaskInput input) {
        if (key == null) {
            throw new IllegalArgumentException("key is required");
        }
        if (this.map.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate key: " + key);
        }
        this.map.put(key, TaskProcess.of(this.executor, input));
        return this;
    }

    public TaskMapExecutor put(Object key, Callable<?> callable) {
        return this.put(key, TaskInput.of(callable));
    }

    public TaskMapExecutor put(Map<Object, TaskInput> inputs) {
        if (inputs != null) {
            for (Map.Entry<Object, TaskInput> entry : inputs.entrySet()) {
                if (entry.getKey() == null) {
                    throw new IllegalArgumentException("key is required");
                }
                if (!this.map.containsKey(entry.getKey())) continue;
                throw new IllegalArgumentException("Duplicate key: " + entry.getKey());
            }
            for (Map.Entry<Object, TaskInput> entry : inputs.entrySet()) {
                this.map.put(entry.getKey(), TaskProcess.of(this.executor, entry.getValue()));
            }
        }
        return this;
    }

    public void parallel(ParallelMapResult parallelMapResult) {
        if (this.executor.isShutdown()) {
            throw new RuntimeException("Tasks have been processed");
        }
        for (Map.Entry<Object, TaskProcess> entry : this.map.entrySet()) {
            TaskProcess process = entry.getValue();
            TaskInput input = process.getInput();
            Future<?> future = process.getFuture();
            if (future == null) {
                if (parallelMapResult == null) continue;
                parallelMapResult.onParallelMapResult(entry.getKey(), TaskResult.of(null));
                continue;
            }
            try {
                Object value = input.getTimeUnit() != null && input.getTimeout() != null ? future.get(input.getTimeout(), input.getTimeUnit()) : future.get();
                if (parallelMapResult == null) continue;
                parallelMapResult.onParallelMapResult(entry.getKey(), TaskResult.of(value));
            }
            catch (Exception e) {
                if (parallelMapResult == null) continue;
                parallelMapResult.onParallelMapResult(entry.getKey(), TaskResult.of(e));
            }
        }
        this.executor.shutdownNow();
        this.map.clear();
    }

    public Map<Object, TaskResult<?>> parallelResult() {
        final HashMap results = new HashMap();
        this.parallel(new ParallelMapResult(){

            @Override
            public void onParallelMapResult(Object key, TaskResult<?> result) {
                results.put(key, result);
            }
        });
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concurrent(ConcurrentMapResult concurrentMapResult) throws Exception {
        if (this.executor.isShutdown()) {
            throw new RuntimeException("Tasks have been processed");
        }
        try {
            for (Map.Entry<Object, TaskProcess> entry : this.map.entrySet()) {
                TaskProcess process = entry.getValue();
                TaskInput input = process.getInput();
                Future<?> future = process.getFuture();
                if (future == null) {
                    if (concurrentMapResult == null) continue;
                    concurrentMapResult.onConcurrentMapResult(entry.getKey(), null);
                    continue;
                }
                Object value = input.getTimeUnit() != null && input.getTimeout() != null ? future.get(input.getTimeout(), input.getTimeUnit()) : future.get();
                if (concurrentMapResult == null) continue;
                concurrentMapResult.onConcurrentMapResult(entry.getKey(), value);
            }
        }
        finally {
            this.executor.shutdownNow();
            this.map.clear();
        }
    }

    public Map<Object, Object> concurrentResult() throws Exception {
        final HashMap<Object, Object> results = new HashMap<Object, Object>();
        this.concurrent(new ConcurrentMapResult(){

            @Override
            public void onConcurrentMapResult(Object key, Object value) throws Exception {
                results.put(key, value);
            }
        });
        return results;
    }

    public static interface ParallelMapResult {
        public void onParallelMapResult(Object var1, TaskResult<?> var2);
    }

    public static interface ConcurrentMapResult {
        public void onConcurrentMapResult(Object var1, Object var2) throws Exception;
    }
}

