/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.util.StringUtil0;

public final class StringUtil {
    private static final String LEN_STR = "%0{len}d";
    private static final String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final int ALPHA_NUMERIC_LENGTH = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length();

    private StringUtil() {
    }

    public static String[] split(String text, String delim, int max, boolean allowEmpty, boolean isTrim) {
        if (delim == null || "".equals(delim)) {
            return new String[]{text};
        }
        ArrayList<String> list = new ArrayList<String>();
        String str = String.valueOf(text);
        int idx = str.indexOf(delim);
        int len = delim.length();
        while (idx != -1 && (max <= -1 || list.size() != max - 1)) {
            String txt = isTrim ? str.substring(0, idx).trim() : str.substring(0, idx);
            str = str.substring(idx + len, str.length());
            idx = str.indexOf(delim);
            if (allowEmpty) {
                list.add(txt);
                continue;
            }
            if ("".equals(txt)) continue;
            list.add(txt);
        }
        if (str.length() > 0) {
            list.add(str);
        }
        return list.toArray(new String[0]);
    }

    public static String[] split(String text, String delim, int max, boolean allowEmpty) {
        return StringUtil.split(text, delim, max, allowEmpty, false);
    }

    public static String[] split(String text, String delim, boolean allowEmpty, boolean isTrim) {
        return StringUtil.split(text, delim, -1, allowEmpty, isTrim);
    }

    public static String[] split(String text, String delim, int max) {
        return StringUtil.split(text, delim, max, true, false);
    }

    public static String[] split(String text, String delim, boolean allowEmpty) {
        return StringUtil.split(text, delim, -1, allowEmpty, false);
    }

    public static String[] split(String text, String delim) {
        return StringUtil.split(text, delim, -1, true, false);
    }

    public static Map<String, String> parseToMap(String text, String delim, String sep, boolean isTrim) {
        String[] ss;
        HashMap<String, String> map = new HashMap<String, String>();
        if (text == null || delim == null || sep == null || "".equals(delim) || "".equals(sep)) {
            return map;
        }
        for (String s : ss = StringUtil.split(text, delim)) {
            String[] dd;
            if (isTrim) {
                s = s.trim();
            }
            if ((dd = StringUtil.split(s, sep, 2)).length != 2) continue;
            if (isTrim) {
                map.put(dd[0].trim(), dd[1].trim());
                continue;
            }
            map.put(dd[0], dd[1]);
        }
        return map;
    }

    public static Map<String, String> parseToMap(String text, String delim, String sep) {
        return StringUtil.parseToMap(text, delim, sep, false);
    }

    public static String getUniqueNumber() {
        return StringUtil.getUniqueNumber(0);
    }

    public static String getUniqueNumber(int len) {
        if (len > 0) {
            long div = (long)Math.pow(10.0, len);
            long number = System.nanoTime() / (long)len % div;
            return String.format(LEN_STR.replace("{len}", "" + len), number);
        }
        return "" + System.nanoTime();
    }

    public static String getRandomAlphaNumeric(int count) {
        try {
            StringBuilder builder = new StringBuilder();
            SecureRandom random = SecureRandom.getInstanceStrong();
            while (count != 0) {
                int character = random.nextInt(ALPHA_NUMERIC_LENGTH);
                builder.append(ALPHA_NUMERIC_STRING.charAt(character));
                --count;
            }
            return builder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String beautifyJson(String json, int indent) {
        return StringUtil0.beautifyJson(json, indent);
    }

    public static String removeEnd(String text, String end) {
        if (text != null && end != null && end.length() != 0) {
            String string = text;
            while (string.endsWith(end)) {
                string = string.substring(0, string.length() - end.length());
            }
            return string;
        }
        return text;
    }

    public static String removeStart(String text, String start) {
        if (text != null && start != null && start.length() != 0) {
            String string = text;
            while (string.startsWith(start)) {
                string = string.substring(start.length());
            }
            return string;
        }
        return text;
    }

    public static <T> T valueOf(Class<T> type, String value, T defaultValue) {
        if (type != null) {
            if (type.isPrimitive()) {
                return StringUtil0.primitiveValueOf(type, value, defaultValue);
            }
            if (Number.class.isAssignableFrom(type)) {
                return StringUtil0.numberValueOf(type, value, defaultValue);
            }
            return StringUtil0.objectValueOf(type, value, defaultValue);
        }
        return defaultValue;
    }

    public static <T> T valueOf(Class<T> type, String value) {
        return StringUtil.valueOf(type, value, null);
    }

    public static Map<String, List<String>> queryStringToMap(String queryString) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        if (queryString != null) {
            String[] split;
            for (String s : split = queryString.split("&")) {
                int i = s.indexOf("=");
                if (i == -1) continue;
                String name = s.substring(0, i);
                String value = s.substring(i + 1);
                List values = map.getOrDefault(name, new ArrayList());
                values.add(value);
                map.put(name, values);
            }
        }
        return map;
    }

    public static String mapToQueryString(Map<String, List<String>> map) {
        if (map == null) {
            return "";
        }
        try {
            StringBuilder queryString = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                for (String value : entry.getValue()) {
                    queryString.append(entry.getKey()).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8.name())).append("&");
                }
            }
            if (queryString.length() != 0) {
                queryString.deleteCharAt(queryString.length() - 1);
            }
            return queryString.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

