/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class StringUtil0 {
    private static final Map<Class<?>, Converter> primitiveConverters = new HashMap();

    private StringUtil0() {
    }

    static <T> T primitiveValueOf(Class<T> type, String value, T defaultValue) {
        Converter converter = primitiveConverters.get(type);
        return (T)(converter != null ? converter.valueOf(value) : defaultValue);
    }

    static <T> T objectValueOf(Class<T> type, String value, T defaultValue) {
        if (String.class.isAssignableFrom(type)) {
            return (T)(value != null ? value : defaultValue);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return StringUtil0.booleanValueOf(value, defaultValue);
        }
        if (Character.class.isAssignableFrom(type)) {
            return StringUtil0.characterValueOf(value, defaultValue);
        }
        if (Class.class.isAssignableFrom(type)) {
            return StringUtil0.classValueOf(value, defaultValue);
        }
        if (Byte.class.isAssignableFrom(type)) {
            return StringUtil0.byteValueOf(value, defaultValue);
        }
        if (Byte[].class.isAssignableFrom(type)) {
            return StringUtil0.byteArrayValueOf(value, defaultValue);
        }
        return defaultValue;
    }

    static <T> T numberValueOf(Class<T> type, String value, T defaultValue) {
        String text;
        String string = text = value != null ? value.trim() : "";
        if (!text.isEmpty()) {
            try {
                return type.getConstructor(String.class).newInstance(text);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return defaultValue;
    }

    private static <T> T booleanValueOf(String value, T defaultValue) {
        String text;
        Object result = defaultValue;
        String string = text = value != null ? value.trim().toLowerCase() : "";
        if ("1".equals(text) || "true".equals(text)) {
            result = Boolean.TRUE;
        } else if ("0".equals(text) || "false".equals(text)) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private static <T> T classValueOf(String value, T defaultValue) {
        String text;
        String string = text = value != null ? value.trim() : "";
        if (!text.isEmpty()) {
            try {
                return (T)Class.forName(text);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return defaultValue;
    }

    private static <T> T characterValueOf(String value, T defaultValue) {
        String text;
        String string = text = value != null ? value.trim() : "";
        if (!text.isEmpty()) {
            return (T)Character.valueOf(text.charAt(0));
        }
        return defaultValue;
    }

    private static <T> T byteValueOf(String value, T defaultValue) {
        String text;
        String string = text = value != null ? value : "";
        if (!text.isEmpty()) {
            return (T)Byte.valueOf(text);
        }
        return defaultValue;
    }

    private static <T> T byteArrayValueOf(String value, T defaultValue) {
        String text;
        String string = text = value != null ? value : "";
        if (!text.isEmpty()) {
            byte[] bytes = text.getBytes();
            Byte[] setyb = new Byte[bytes.length];
            Arrays.setAll(setyb, i -> bytes[i]);
            return (T)setyb;
        }
        return defaultValue;
    }

    static String beautifyJson(String json, int indent) {
        char[] chars = json.toCharArray();
        String newline = System.lineSeparator();
        StringBuilder ret = new StringBuilder();
        boolean beginQuotes = false;
        int den = 0;
        block6: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\"') {
                ret.append(c);
                beginQuotes = !beginQuotes;
                continue;
            }
            if (!beginQuotes) {
                switch (c) {
                    case '[': 
                    case '{': {
                        ret.append(c).append(newline).append(String.format("%" + (den += indent) + "s", ""));
                        continue block6;
                    }
                    case ']': 
                    case '}': {
                        ret.append(newline).append((den -= indent) > 0 ? String.format("%" + den + "s", "") : "").append(c);
                        continue block6;
                    }
                    case ':': {
                        ret.append(c).append(" ");
                        continue block6;
                    }
                    case ',': {
                        ret.append(c).append(newline).append(den > 0 ? String.format("%" + den + "s", "") : "");
                        continue block6;
                    }
                    default: {
                        if (Character.isWhitespace(c)) continue block6;
                    }
                }
            }
            ret.append(c).append((String)(c == '\\' ? "" + chars[++i] : ""));
        }
        return ret.toString();
    }

    static {
        primitiveConverters.put(Boolean.TYPE, value -> {
            String text = value != null ? value.trim().toLowerCase() : "";
            return "1".equals(text) || "true".equals(text);
        });
        primitiveConverters.put(byte[].class, text -> text != null ? text.getBytes() : null);
        primitiveConverters.put(Byte.TYPE, value -> {
            String text = value != null ? value.trim() : "";
            return !text.isEmpty() ? Byte.parseByte(text) : (byte)0;
        });
        primitiveConverters.put(Character.TYPE, value -> {
            String text = value != null ? value.trim() : "";
            return Character.valueOf(!text.isEmpty() ? text.charAt(0) : (char)'\u0000');
        });
        primitiveConverters.put(Double.TYPE, value -> {
            String text = value != null ? value.trim() : "";
            return !text.isEmpty() ? Double.parseDouble(text) : 0.0;
        });
        primitiveConverters.put(Float.TYPE, value -> {
            String text = value != null ? value.trim() : "";
            return Float.valueOf(!text.isEmpty() ? Float.parseFloat(text) : 0.0f);
        });
        primitiveConverters.put(Integer.TYPE, value -> {
            String text = value != null ? value.trim() : "";
            return !text.isEmpty() ? Integer.parseInt(text) : 0;
        });
        primitiveConverters.put(Long.TYPE, value -> {
            String text = value != null ? value.trim() : "";
            return !text.isEmpty() ? Long.parseLong(text) : 0L;
        });
        primitiveConverters.put(Short.TYPE, value -> {
            String text = value != null ? value.trim() : "";
            return !text.isEmpty() ? Short.parseShort(text) : (short)0;
        });
    }

    protected static interface Converter {
        public Object valueOf(String var1);
    }
}

